/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.marshall;

import org.jgroups.blocks.MethodCall;

import java.lang.reflect.Method;

/**
 * A subclass of the JGroups MethodCall class, which adds a method id.
 * <p/>
 * NB: The reason for not using JGroups' MethodCall class directly, which does contain an id property
 * since JGroups 2.2.9, is for backward compatibility with JGroups 2.2.7 and 2.2.8.
 *
 * @author <a href="mailto:manik@jboss.org">Manik Surtani (manik@jboss.org)</a>
 */
public class JBCMethodCall extends MethodCall
{
    private int methodId;

    public JBCMethodCall()
    {
    }

    public JBCMethodCall(Method method, Object[] arguments, int methodId)
    {
        super(method, arguments);
        this.methodId = methodId;
    }

    public int getMethodId()
    {
        return methodId;
    }

    public void setMethodId(int methodId)
    {
        this.methodId = methodId;
    }

    public boolean equals(Object o)
    {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        final JBCMethodCall that = (JBCMethodCall) o;

        return (methodId == that.methodId) && super.equals(o);
    }

    public int hashCode()
    {
        return super.hashCode() * 10 + methodId;
    }
}
