/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.optimistic;

import org.jboss.cache.DataNode;
import org.jboss.cache.TreeNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;

import java.util.Map;
import java.util.Set;

/**
 * Represents a type of {@link org.jboss.cache.Node} that is to be copied into a {@link TransactionWorkspace} for optimistically locked
 * nodes.  Adds versioning and dirty flags over conventional Nodes.
 * 
 * @author Manik Surtani (<a href="mailto:manik@jboss.org">manik@jboss.org</a>)
 * @author Steve Woodcock (<a href="mailto:stevew@jofti.com">stevew@jofti.com</a>)
 */
public interface WorkspaceNode extends TreeNode
{
    public Map getMergedChildren();

    public DataVersion getVersion();

    public void setVersion(DataVersion version);

    public Set getKeys();

    public boolean isDirty();

    public Map getMergedData();

    public DataNode getNode();

    public Set getChildrenNames();

    public boolean isDeleted();

    public void markAsDeleted();

    public TransactionWorkspace getTransactionWorkspace();

    public boolean isCreated();

    public void markAsCreated();

    public TreeNode createChild(Object child_name, Fqn fqn, TreeNode parent, TreeCache cache, DataVersion version);
}
