/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.LogFactory;

public class Fqn
implements Cloneable,
Externalizable {
    public static final String SEPARATOR = "/";
    private List elements;
    private transient int hash_code = 0;
    static boolean REL_123_COMPATIBLE = false;
    private static final long serialVersionUID = -5351930616956603651L;
    public static final Fqn ROOT;

    static {
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String compatible = System.getProperty("jboss.cache.fqn.123compatible");
                    REL_123_COMPATIBLE = Boolean.valueOf(compatible);
                    return null;
                }
            });
        }
        catch (SecurityException securityException) {
        }
        catch (Throwable t) {
            LogFactory.getLog(Fqn.class).error((Object)"Caught throwable reading system property jboss.cache.fqn.123compatible", t);
        }
        ROOT = new Fqn();
    }

    public Fqn() {
        this.elements = Collections.EMPTY_LIST;
    }

    public Fqn(Object name) {
        this.elements = Collections.singletonList(name);
    }

    public Fqn(List names) {
        this.elements = names != null ? new ArrayList(names) : Collections.EMPTY_LIST;
    }

    public Fqn(Object[] names) {
        this.elements = names == null ? Collections.EMPTY_LIST : Arrays.asList(names);
    }

    public Fqn(Fqn base, Object relative_name) {
        this.elements = new ArrayList(base.elements.size() + 1);
        this.elements.addAll(base.elements);
        this.elements.add(relative_name);
    }

    public Fqn(Fqn base, Fqn relative) {
        this(base, relative.elements);
    }

    public Fqn(Fqn base, List relative) {
        this.elements = new ArrayList(base.elements.size() + relative.size());
        this.elements.addAll(base.elements);
        this.elements.addAll(relative);
    }

    public Fqn(Fqn base, Object relative_name1, Object relative_name2) {
        this.elements = new ArrayList(base.elements.size() + 2);
        this.elements.addAll(base.elements);
        this.elements.add(relative_name1);
        this.elements.add(relative_name2);
    }

    public Fqn(Fqn base, Object relative_name1, Object relative_name2, Object relative_name3) {
        this.elements = new ArrayList(base.elements.size() + 3);
        this.elements.addAll(base.elements);
        this.elements.add(relative_name1);
        this.elements.add(relative_name2);
        this.elements.add(relative_name3);
    }

    private static Fqn createFqn(List list) {
        Fqn fqn = new Fqn();
        fqn.elements = list;
        return fqn;
    }

    public static Fqn fromString(String fqn) {
        if (fqn == null) {
            return ROOT;
        }
        return Fqn.createFqn(Fqn.parse(fqn));
    }

    private static List parse(String fqn) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(fqn, SEPARATOR);
        while (tok.hasMoreTokens()) {
            list.add(tok.nextToken());
        }
        return list;
    }

    public Fqn getFqnChild(int index) {
        return Fqn.createFqn(this.elements.subList(0, index));
    }

    public Fqn getFqnChild(int startIndex, int endIndex) {
        return Fqn.createFqn(this.elements.subList(startIndex, endIndex));
    }

    public int size() {
        return this.elements.size();
    }

    public Object get(int index) {
        return this.elements.get(index);
    }

    public Object getLast() {
        if (this.isRoot()) {
            return SEPARATOR;
        }
        return this.elements.get(this.elements.size() - 1);
    }

    public boolean hasElement(Object o) {
        return this.elements.lastIndexOf(o) != -1;
    }

    public Object clone() {
        return new Fqn(this.elements);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Fqn)) {
            return false;
        }
        Fqn other = (Fqn)obj;
        return this.elements.equals(other.elements);
    }

    public int hashCode() {
        if (this.hash_code == 0) {
            this.hash_code = this._hashCode();
        }
        return this.hash_code;
    }

    public String toString() {
        if (this.isRoot()) {
            return SEPARATOR;
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            sb.append(SEPARATOR).append(it.next());
        }
        return sb.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (REL_123_COMPATIBLE) {
            out.writeObject(this.elements);
        } else {
            out.writeShort(this.elements.size());
            for (Object element : this.elements) {
                out.writeObject(element);
            }
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (REL_123_COMPATIBLE) {
            this.elements = (List)in.readObject();
        } else {
            int length = in.readShort();
            this.elements = new ArrayList(length);
            int i = 0;
            while (i < length) {
                this.elements.add(in.readObject());
                ++i;
            }
        }
    }

    public boolean isChildOf(Fqn parentFqn) {
        if (parentFqn.elements.size() == this.elements.size()) {
            return false;
        }
        return this.isChildOrEquals(parentFqn);
    }

    public boolean isChildOrEquals(Fqn parentFqn) {
        List parentList = parentFqn.elements;
        if (parentList.size() > this.elements.size()) {
            return false;
        }
        int i = parentList.size() - 1;
        while (i >= 0) {
            if (!parentList.get(i).equals(this.elements.get(i))) {
                return false;
            }
            --i;
        }
        return true;
    }

    private int _hashCode() {
        int hashCode = 0;
        int count = 1;
        for (Object o : this.elements) {
            hashCode += o == null ? 0 : o.hashCode() * count++;
        }
        if (hashCode == 0) {
            hashCode = 65261;
        }
        return hashCode;
    }

    public Fqn getParent() {
        switch (this.elements.size()) {
            case 0: 
            case 1: {
                return ROOT;
            }
        }
        return Fqn.createFqn(this.elements.subList(0, this.elements.size() - 1));
    }

    public boolean isRoot() {
        return this.elements.isEmpty();
    }

    public String getName() {
        if (this.isRoot()) {
            return SEPARATOR;
        }
        return String.valueOf(this.getLast());
    }

    public List peekElements() {
        return Collections.unmodifiableList(this.elements);
    }
}

