/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.lang.reflect.Method;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.TransactionManagerLookup;
import org.jboss.cache.transaction.DummyTransactionManager;

public class GenericTransactionManagerLookup
implements TransactionManagerLookup {
    private static Log log = LogFactory.getLog(GenericTransactionManagerLookup.class);
    private static boolean lookupDone = false;
    private static boolean lookupFailed = false;
    private static TransactionManager tm = null;
    private static String[][] knownJNDIManagers = new String[][]{{"java:/TransactionManager", "JBoss, JRun4"}, {"java:comp/UserTransaction", "Resin, Orion, JOnAS (JOTM)"}, {"javax.transaction.TransactionManager", "BEA WebLogic"}};
    private static final String WS_FACTORY_CLASS_5_1 = "com.ibm.ws.Transaction.TransactionManagerFactory";
    private static final String WS_FACTORY_CLASS_5_0 = "com.ibm.ejs.jts.jta.TransactionManagerFactory";
    private static final String WS_FACTORY_CLASS_4 = "com.ibm.ejs.jts.jta.JTSXA";

    public TransactionManager getTransactionManager() {
        if (!lookupDone) {
            GenericTransactionManagerLookup.doLookups();
        }
        if (tm != null) {
            return tm;
        }
        if (lookupFailed) {
            tm = DummyTransactionManager.getInstance();
            log.warn((Object)"Falling back to DummyTransactionManager from JBossCache");
        }
        return tm;
    }

    private static void doLookups() {
        Class<?> clazz;
        InitialContext ctx;
        if (lookupFailed) {
            return;
        }
        try {
            ctx = new InitialContext();
        }
        catch (NamingException e) {
            log.error((Object)"Could not create an initial JNDI context!", (Throwable)e);
            lookupFailed = true;
            return;
        }
        Object jndiObject = null;
        int i = 0;
        while (i < knownJNDIManagers.length) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Trying to lookup TransactionManager for " + knownJNDIManagers[i][1]));
                }
                jndiObject = ctx.lookup(knownJNDIManagers[i][0]);
            }
            catch (NamingException e) {
                log.info((Object)("Failed to perform a lookup for [" + knownJNDIManagers[i][0] + " (" + knownJNDIManagers[i][1] + ")]"));
            }
            if (jndiObject instanceof TransactionManager) {
                tm = (TransactionManager)jndiObject;
                log.info((Object)("Found TransactionManager for " + knownJNDIManagers[i][1]));
                return;
            }
            ++i;
        }
        try {
            log.debug((Object)"Trying WebSphere 5.1: com.ibm.ws.Transaction.TransactionManagerFactory");
            clazz = Class.forName(WS_FACTORY_CLASS_5_1);
            log.info((Object)"Found WebSphere 5.1: com.ibm.ws.Transaction.TransactionManagerFactory");
        }
        catch (ClassNotFoundException ex) {
            try {
                log.debug((Object)"Trying WebSphere 5.0: com.ibm.ejs.jts.jta.TransactionManagerFactory");
                clazz = Class.forName(WS_FACTORY_CLASS_5_0);
                log.info((Object)"Found WebSphere 5.0: com.ibm.ejs.jts.jta.TransactionManagerFactory");
            }
            catch (ClassNotFoundException ex2) {
                try {
                    log.debug((Object)"Trying WebSphere 4: com.ibm.ejs.jts.jta.JTSXA");
                    clazz = Class.forName(WS_FACTORY_CLASS_4);
                    log.info((Object)"Found WebSphere 4: com.ibm.ejs.jts.jta.JTSXA");
                }
                catch (ClassNotFoundException ex3) {
                    log.info((Object)"Couldn't find any WebSphere TransactionManager factory class, neither for WebSphere version 5.1 nor 5.0 nor 4");
                    lookupFailed = true;
                    return;
                }
            }
        }
        try {
            Class[] signature = null;
            Object[] args = null;
            Method method = clazz.getMethod("getTransactionManager", signature);
            tm = (TransactionManager)method.invoke(null, args);
        }
        catch (Exception ex) {
            log.error((Object)("Found WebSphere TransactionManager factory class [" + clazz.getName() + "], but couldn't invoke its static 'getTransactionManager' method"), (Throwable)ex);
        }
    }
}

