/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jgroups.Address;

public class GlobalTransaction
implements Externalizable {
    Address addr = null;
    long id = -1L;
    private static long sid = 0L;
    private transient boolean remote = false;
    private static final long serialVersionUID = 8011434781266976149L;
    private transient int hash_code = -1;

    public GlobalTransaction() {
    }

    private GlobalTransaction(Address addr) {
        this.addr = addr;
        this.id = GlobalTransaction.newId();
    }

    private static synchronized long newId() {
        return ++sid;
    }

    public static GlobalTransaction create(Address addr) {
        return new GlobalTransaction(addr);
    }

    public Object getAddress() {
        return this.addr;
    }

    public void setAddress(Address address) {
        this.addr = address;
    }

    public long getId() {
        return this.id;
    }

    public int hashCode() {
        if (this.hash_code == -1) {
            this.hash_code = (this.addr != null ? this.addr.hashCode() : 0) + (int)this.id;
        }
        return this.hash_code;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GlobalTransaction)) {
            return false;
        }
        return this.compareTo(other) == 0;
    }

    public int compareTo(Object o) {
        int comp;
        if (o == null || !(o instanceof GlobalTransaction)) {
            throw new ClassCastException("GlobalTransaction.compareTo(): other object is " + o);
        }
        GlobalTransaction other = (GlobalTransaction)o;
        int n = comp = this.addr != null ? this.addr.compareTo((Object)other.addr) : 0;
        if (comp == 0) {
            if (this.id < other.getId()) {
                comp = -1;
            } else if (this.id > other.getId()) {
                comp = 1;
            }
        }
        return comp;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("GlobalTransaction:<").append(this.addr).append(">:").append(this.id);
        return sb.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.addr);
        out.writeLong(this.id);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.addr = (Address)in.readObject();
        this.id = in.readLong();
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public void setId(long id) {
        this.id = id;
    }
}

