/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.config.Option;
import org.jboss.cache.lock.IdentityLock;
import org.jgroups.blocks.MethodCall;

public class TransactionEntry {
    static Log log = LogFactory.getLog(TransactionEntry.class);
    protected Transaction ltx = null;
    protected Option option;
    protected List modification_list = new LinkedList();
    protected List cl_mod_list = new LinkedList();
    protected List undo_list = new LinkedList();
    protected List locks = new LinkedList();
    protected List dummyNodesCreatedByCacheLoader;

    public void addModification(MethodCall m) {
        if (m == null) {
            return;
        }
        this.modification_list.add(m);
    }

    public void addCacheLoaderModification(MethodCall m) {
        if (m != null) {
            this.cl_mod_list.add(m);
        }
    }

    public List getModifications() {
        return this.modification_list;
    }

    public List getCacheLoaderModifications() {
        return this.cl_mod_list;
    }

    public void addUndoOperation(MethodCall m) {
        this.undo_list.add(m);
    }

    public List getUndoOperations() {
        return this.undo_list;
    }

    public void setTransaction(Transaction tx) {
        this.ltx = tx;
    }

    public Transaction getTransaction() {
        return this.ltx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLock(IdentityLock l) {
        if (l != null) {
            List list = this.locks;
            synchronized (list) {
                if (!this.locks.contains(l)) {
                    this.locks.add(l);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocks(Collection newLocks) {
        if (newLocks != null) {
            List list = this.locks;
            synchronized (list) {
                for (IdentityLock tmp : newLocks) {
                    if (this.locks.contains(tmp)) continue;
                    this.locks.add(tmp);
                }
            }
        }
    }

    public List getLocks() {
        return this.locks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAllLocks(Object owner) {
        this.releaseAllLocksFIFO(owner);
        List list = this.locks;
        synchronized (list) {
            this.locks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAllLocksLIFO(Object owner) {
        List list = this.locks;
        synchronized (list) {
            ListIterator i = this.locks.listIterator(this.locks.size());
            while (i.hasPrevious()) {
                IdentityLock lock = (IdentityLock)i.previous();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("releasing lock for " + lock.getFqn() + " (" + lock + ")"));
                }
                lock.release(owner);
            }
            this.locks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAllLocksFIFO(Object owner) {
        List list = this.locks;
        synchronized (list) {
            for (IdentityLock lock : this.locks) {
                lock.release(owner);
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("releasing lock for " + lock.getFqn() + " (" + lock + ")"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undoOperations(TreeCache cache) {
        ArrayList l;
        List list = this.undo_list;
        synchronized (list) {
            l = new ArrayList(this.undo_list);
        }
        ListIterator i = l.listIterator(l.size());
        while (i.hasPrevious()) {
            MethodCall undo_op = (MethodCall)i.previous();
            this.undo(undo_op, cache);
        }
    }

    private void undo(MethodCall undo_op, TreeCache cache) {
        try {
            Object retval = undo_op.invoke((Object)cache);
            if (retval instanceof Throwable) {
                throw (Throwable)retval;
            }
        }
        catch (Throwable t) {
            log.error((Object)("undo operation failed, error=" + t));
            log.trace((Object)t, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nmodification_list: ").append(this.modification_list);
        List list = this.undo_list;
        synchronized (list) {
            sb.append("\nundo_list: ").append(this.undo_list);
        }
        list = this.locks;
        synchronized (list) {
            sb.append("\nlocks: ").append(this.locks);
        }
        return sb.toString();
    }

    public void loadUninitialisedNode(Fqn fqn) {
        if (this.dummyNodesCreatedByCacheLoader == null) {
            this.dummyNodesCreatedByCacheLoader = new LinkedList();
        }
        this.dummyNodesCreatedByCacheLoader.add(fqn);
    }

    public List getDummyNodesCreatedByCacheLoader() {
        return this.dummyNodesCreatedByCacheLoader;
    }

    public void setOption(Option o) {
        this.option = o;
    }

    public Option getOption() {
        return this.option;
    }
}

