/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.io.File;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.PropertyConfigurator;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeCacheGui2;
import org.jboss.cache.TreeCacheView;

public class TreeCacheView2 {
    static TreeCacheGui2 gui_ = null;
    static boolean useConsole = false;
    TreeCache cache_ = null;
    static Log log_ = LogFactory.getLog((String)TreeCacheView2.class.getName());

    public TreeCacheView2(TreeCache cache) throws Exception {
        this.cache_ = cache;
    }

    public static void setCache(TreeCache cache) {
        gui_.setCache(cache);
    }

    public void start() throws Exception {
        if (gui_ == null) {
            log_.info((Object)"start(): creating the GUI");
            gui_ = new TreeCacheGui2(this.cache_);
        }
    }

    public void stop() {
        if (gui_ != null) {
            log_.info((Object)"stop(): disposing the GUI");
            gui_.stopGui();
            gui_ = null;
        }
    }

    void populateTree(String dir) throws Exception {
        String[] children;
        File file = new File(dir);
        if (!file.exists()) {
            return;
        }
        this.put(dir, null);
        if (file.isDirectory() && (children = file.list()) != null && children.length > 0) {
            int i = 0;
            while (i < children.length) {
                this.populateTree(String.valueOf(dir) + "/" + children[i]);
                ++i;
            }
        }
    }

    void put(String fqn, Map m) {
        try {
            this.cache_.put(fqn, m);
        }
        catch (Throwable t) {
            log_.error((Object)("TreeCacheView2.put(): " + t));
        }
    }

    public static void main(String[] args) {
        TreeCache tree = null;
        String start_directory = null;
        String resource = "META-INF/replSync-service.xml";
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-console")) {
                useConsole = true;
            } else if (args[i].equals("-config")) {
                resource = args[++i];
            } else {
                TreeCacheView2.help();
                return;
            }
            ++i;
        }
        try {
            if (useConsole) {
                TreeCacheView2 demo = new TreeCacheView2(null);
                demo.start();
            } else {
                tree = new TreeCache();
                PropertyConfigurator config = new PropertyConfigurator();
                config.configure((Object)tree, resource);
                tree.addTreeCacheListener(new TreeCacheView.MyListener());
                tree.start();
                TreeCacheView2 demo = new TreeCacheView2(tree);
                demo.start();
                if (start_directory != null && start_directory.length() > 0) {
                    demo.populateTree(start_directory);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static void help() {
        System.out.println("TreeCacheView [-help] [-mbean_name <name of TreeCache MBean>] [-start_directory <dirname>] [-props <props>] [-use_queue <true/false>] [-queue_interval <ms>] [-console][-queue_max_elements <num>]");
    }
}

