/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.StringTokenizer;

public class Version {
    public static final String version = "1.4.0.SP1";
    public static byte[] version_id = new byte[]{48, 49, 52, 48, 83, 80, 49};
    public static final String cvs = "$Id: Version.java 2368 2006-08-11 19:59:14Z  $";
    private static final int MAJOR_SHIFT = 11;
    private static final int MINOR_SHIFT = 6;
    private static final int MAJOR_MASK = 63488;
    private static final int MINOR_MASK = 1984;
    private static final int PATCH_MASK = 63;
    private static final short SHORT_1_2_3 = Version.encodeVersion(1, 2, 3);
    private static final short SHORT_1_2_4_SP2 = Version.encodeVersion(1, 2, 4);

    public static void main(String[] args) {
        System.out.println("\nVersion: \t1.4.0.SP1");
        System.out.println("CVS:      \t$Id: Version.java 2368 2006-08-11 19:59:14Z  $");
        System.out.println("History:  \t(see docs/Changelog.txt for details)\n");
    }

    public static String printVersion() {
        return "JBossCache 1.4.0.SP1[ $Id: Version.java 2368 2006-08-11 19:59:14Z  $]";
    }

    public static String printVersionId(byte[] v, int len) {
        StringBuffer sb = new StringBuffer();
        if (v != null) {
            if (len <= 0) {
                len = v.length;
            }
            int i = 0;
            while (i < len) {
                sb.append((char)v[i]);
                ++i;
            }
        }
        return sb.toString();
    }

    public static String printVersionId(byte[] v) {
        StringBuffer sb = new StringBuffer();
        if (v != null) {
            int i = 0;
            while (i < v.length) {
                sb.append((char)v[i]);
                ++i;
            }
        }
        return sb.toString();
    }

    public static boolean compareTo(byte[] v) {
        if (v == null) {
            return false;
        }
        if (v.length < version_id.length) {
            return false;
        }
        int i = 0;
        while (i < version_id.length) {
            if (version_id[i] != v[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int getLength() {
        return version_id.length;
    }

    public static short getVersionShort() {
        return Version.getVersionShort(version);
    }

    public static short getVersionShort(String versionString) {
        if (versionString == null) {
            throw new IllegalArgumentException("versionString is null");
        }
        if ("1.2.4".equals(versionString)) {
            return 124;
        }
        if ("1.2.4.SP1".equals(versionString)) {
            return 1241;
        }
        StringTokenizer tokenizer = new StringTokenizer(versionString, ".");
        int major = 0;
        int minor = 0;
        int patch = 0;
        if (tokenizer.hasMoreTokens()) {
            major = Integer.parseInt(tokenizer.nextToken());
        }
        if (tokenizer.hasMoreTokens()) {
            minor = Integer.parseInt(tokenizer.nextToken());
        }
        if (tokenizer.hasMoreTokens()) {
            patch = Integer.parseInt(tokenizer.nextToken());
        }
        return Version.encodeVersion(major, minor, patch);
    }

    public static String getVersionString(short versionShort) {
        if (versionShort == SHORT_1_2_4_SP2) {
            return "1.2.4.SP2";
        }
        switch (versionShort) {
            case 124: {
                return "1.2.4";
            }
            case 1241: {
                return "1.2.4.SP1";
            }
        }
        return Version.decodeVersion(versionShort);
    }

    public static short encodeVersion(int major, int minor, int patch) {
        short version = (short)((major << 11) + (minor << 6) + patch);
        return version;
    }

    public static String decodeVersion(short version) {
        int major = (version & 0xF800) >> 11;
        int minor = (version & 0x7C0) >> 6;
        int patch = version & 0x3F;
        String versionString = String.valueOf(major) + "." + minor + "." + patch;
        return versionString;
    }

    public static boolean isBefore124(short version) {
        return version > 1241 && version <= SHORT_1_2_3;
    }
}

