/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop;

import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.joinpoint.FieldInvocation;
import org.jboss.aop.joinpoint.FieldReadInvocation;
import org.jboss.aop.joinpoint.FieldWriteInvocation;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.cache.Fqn;
import org.jboss.cache.aop.AOPInstance;
import org.jboss.cache.aop.BaseInterceptor;
import org.jboss.cache.aop.CachedType;
import org.jboss.cache.aop.PojoCache;
import org.jboss.cache.aop.WriteReplaceable;
import org.jboss.cache.aop.util.AopUtil;

public class CacheInterceptor
implements BaseInterceptor {
    protected static final Log log_ = LogFactory.getLog(CacheInterceptor.class);
    protected PojoCache cache;
    protected CachedType type;
    protected Fqn fqn;
    boolean checkSerialization;
    protected String name;
    protected AOPInstance aopInstance;
    static Method writeExternal;
    static Method readExternal;

    static {
        try {
            writeExternal = Externalizable.class.getMethod("writeExternal", ObjectOutput.class);
            readExternal = Externalizable.class.getMethod("readExternal", ObjectInput.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CacheInterceptor(PojoCache cache, Fqn fqn, CachedType type) {
        this.cache = cache;
        this.fqn = fqn;
        this.type = type;
        this.checkSerialization = !WriteReplaceable.class.isAssignableFrom(type.getType());
    }

    public AOPInstance getAopInstance() {
        return this.aopInstance;
    }

    public void setAopInstance(AOPInstance aopInstance) {
        this.aopInstance = aopInstance;
    }

    public String getName() {
        if (this.name == null) {
            this.name = "CacheInterceptor on [" + this.fqn + "]";
        }
        return this.name;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (this.isPojoDetached(invocation)) {
            return invocation.invokeNext();
        }
        if (invocation instanceof FieldWriteInvocation) {
            FieldInvocation fieldInvocation = (FieldInvocation)invocation;
            Advisor advisor = fieldInvocation.getAdvisor();
            Field field = fieldInvocation.getField();
            CachedType fieldType = this.cache.getCachedType(field.getType());
            CachedType parentType = this.cache.getCachedType(field.getDeclaringClass());
            if (!this.isNonReplicatable(field, advisor, parentType)) {
                Object value = ((FieldWriteInvocation)fieldInvocation).getValue();
                if (fieldType.isImmediate() || this.hasSerializableAnnotation(field, advisor, parentType)) {
                    this.cache.put(this.fqn, (Object)field.getName(), value);
                } else {
                    this.cache.putObject(new Fqn(this.fqn, field.getName()), value);
                }
            }
        } else if (invocation instanceof FieldReadInvocation) {
            FieldInvocation fieldInvocation = (FieldInvocation)invocation;
            Field field = fieldInvocation.getField();
            Advisor advisor = fieldInvocation.getAdvisor();
            CachedType fieldType = this.cache.getCachedType(field.getType());
            CachedType parentType = this.cache.getCachedType(field.getDeclaringClass());
            if (!this.isNonReplicatable(field, advisor, parentType)) {
                Object result = fieldType.isImmediate() || this.hasSerializableAnnotation(field, advisor, parentType) ? this.cache.get(this.fqn, (Object)field.getName()) : this.cache.getObject(new Fqn(this.fqn, field.getName()));
                if (result != null) {
                    return result;
                }
                Object value = invocation.getTargetObject();
                if (value == null || field.get(value) == null) {
                    return null;
                }
                if (log_.isTraceEnabled()) {
                    log_.trace((Object)("invoke(): DataNode on fqn: " + this.fqn + " has obviously been evicted. Will need to reconstruct it"));
                }
                this.cache.putObject(this.fqn, value);
            }
        } else if (this.checkSerialization) {
            MethodInvocation methodInvocation = (MethodInvocation)invocation;
            Method method = methodInvocation.getMethod();
            if (method != null && method.getName().equals("writeReplace") && method.getReturnType().equals(Object.class) && method.getParameterTypes().length == 0) {
                this.beforeSerialization(invocation.getTargetObject());
            } else if (method == writeExternal) {
                Object target = methodInvocation.getTargetObject();
                this.beforeSerialization(target);
            }
        }
        return invocation.invokeNext();
    }

    private boolean isNonReplicatable(Field field, Advisor advisor, CachedType type) {
        if (CachedType.hasAnnotation(field.getDeclaringClass(), advisor, type) && CachedType.hasTransientAnnotation(field, advisor)) {
            return true;
        }
        return CachedType.isPrimitiveNonReplicatable(field);
    }

    private boolean hasSerializableAnnotation(Field field, Advisor advisor, CachedType type) {
        return CachedType.hasAnnotation(field.getDeclaringClass(), advisor, type) && CachedType.hasSerializableAnnotation(field, advisor);
    }

    protected boolean isPojoDetached(Invocation invocation) throws Exception {
        boolean detached = false;
        if (!this.cache.exists(this.fqn, (Object)"__jboss:internal:class__")) {
            detached = true;
            Object obj = invocation.getTargetObject();
            if (!(obj instanceof Advised)) {
                throw new RuntimeException("Interception on non-advised pojo " + obj.toString());
            }
            InstanceAdvisor advisor = ((Advised)obj)._getInstanceAdvisor();
            CacheInterceptor interceptor = (CacheInterceptor)AopUtil.findCacheInterceptor(advisor);
            if (interceptor != null) {
                if (log_.isDebugEnabled()) {
                    log_.debug((Object)("isPojoDetached(): removed cache interceptor fqn: " + this.fqn + " interceptor: " + interceptor));
                }
                advisor.removeInterceptor(interceptor.getName());
            }
        }
        return detached;
    }

    protected void checkCacheConsistency() throws Exception {
        if (this != this.cache.peek(this.fqn, AOPInstance.KEY)) {
            throw new RuntimeException("Cache inconsistency: Outdated AOPInstance");
        }
    }

    public void beforeSerialization(Object target) throws Exception {
        Iterator i = this.type.getFieldsIterator();
        while (i.hasNext()) {
            Field field = (Field)i.next();
            CachedType fieldType = this.cache.getCachedType(field.getType());
            Object value = null;
            value = fieldType.isImmediate() ? this.cache.get(this.fqn, (Object)field.getName()) : this.cache.getObject(new Fqn(this.fqn, field.getName()));
            field.set(target, value);
        }
    }

    boolean isChildOf(Fqn parentFqn) {
        return this.fqn.isChildOf(parentFqn);
    }

    public Fqn getFqn() {
        return this.fqn;
    }

    public void setFqn(Fqn fqn) {
        this.fqn = fqn;
    }
}

