/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.proxy.ClassProxy;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.TreeNode;
import org.jboss.cache.aop.AOPInstance;
import org.jboss.cache.aop.BaseInterceptor;
import org.jboss.cache.aop.CacheInterceptor;
import org.jboss.cache.aop.CachedType;
import org.jboss.cache.aop.CollectionClassHandler;
import org.jboss.cache.aop.InternalDelegate;
import org.jboss.cache.aop.ObjectGraphHandler;
import org.jboss.cache.aop.PojoCache;
import org.jboss.cache.aop.SerializableObjectHandler;
import org.jboss.cache.aop.collection.AbstractCollectionInterceptor;
import org.jboss.cache.aop.util.AopUtil;
import org.jboss.cache.aop.util.SecurityActions;
import org.jboss.cache.marshall.JBCMethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;

public class TreeCacheAopDelegate {
    protected PojoCache cache_;
    protected static final Log log = LogFactory.getLog(TreeCacheAopDelegate.class);
    protected InternalDelegate internal_;
    protected ObjectGraphHandler graphHandler_;
    protected CollectionClassHandler collectionHandler_;
    protected SerializableObjectHandler serializableHandler_;
    protected ThreadLocal bulkRemove_ = new ThreadLocal();
    protected final String DETACH = "DETACH";

    public TreeCacheAopDelegate(PojoCache cache) {
        this.cache_ = cache;
        this.internal_ = new InternalDelegate(cache);
        this.graphHandler_ = new ObjectGraphHandler(this.cache_, this.internal_, this);
        this.collectionHandler_ = new CollectionClassHandler(this.cache_, this.internal_, this.graphHandler_);
        this.serializableHandler_ = new SerializableObjectHandler(this.cache_, this.internal_);
    }

    public void setBulkRemove(boolean bulk) {
        this.bulkRemove_.set(bulk);
    }

    public boolean getBulkRemove() {
        return (Boolean)this.bulkRemove_.get();
    }

    protected Object _getObject(Fqn fqn) throws CacheException {
        Object pojo = this.internal_.getPojoWithGravitation(fqn);
        if (pojo != null) {
            return pojo;
        }
        ClassLoader prevCL = Thread.currentThread().getContextClassLoader();
        try {
            if (this.cache_.getRegionManager() != null) {
                this.cache_.getRegionManager().setUnmarshallingClassLoader(fqn);
            }
            Object object = this._getObjectInternal(fqn);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevCL);
        }
    }

    protected Object _getObjectInternal(Fqn fqn) throws CacheException {
        Class clazz = this.internal_.peekAopClazz(fqn);
        if (clazz == null) {
            return null;
        }
        CachedType type = this.cache_.getCachedType(clazz);
        Object obj = this.graphHandler_.objectGraphGet(fqn);
        if (obj != null) {
            return obj;
        }
        AOPInstance aopInstance = this.internal_.getAopInstance(fqn);
        if (aopInstance == null) {
            throw new RuntimeException("TreeCacheAopDelegate._getObject(): null AOPInstance.");
        }
        if (Advised.class.isAssignableFrom(clazz)) {
            try {
                Constructor ctr = clazz.getDeclaredConstructor(null);
                SecurityActions.setAccessible(ctr);
                obj = ctr.newInstance(null);
            }
            catch (Exception e) {
                throw new CacheException("failed creating instance of " + clazz.getName(), e);
            }
            InstanceAdvisor advisor = ((Advised)obj)._getInstanceAdvisor();
            CacheInterceptor interceptor = new CacheInterceptor(this.cache_, fqn, type);
            interceptor.setAopInstance(aopInstance);
            advisor.appendInterceptor((Interceptor)interceptor);
            this.cache_.addUndoInterceptor(advisor, interceptor, 0);
        } else {
            try {
                obj = this.collectionHandler_.collectionObjectGet(fqn, clazz);
                if (obj == null) {
                    obj = this.serializableHandler_.serializableObjectGet(fqn);
                }
            }
            catch (Exception e) {
                throw new CacheException("failure creating proxy", e);
            }
        }
        this.internal_.setPojo(aopInstance, obj);
        return obj;
    }

    protected Object _putObject(Fqn fqn, Object obj) throws CacheException {
        if (!this.cache_.isMarshallNonSerializable()) {
            AopUtil.checkObjectType(obj);
        }
        if (obj == null) {
            return this.cache_._removeObject(fqn, true);
        }
        Object oldValue = this.internal_.getPojo(fqn);
        if (oldValue == obj) {
            return obj;
        }
        if (oldValue != null) {
            this.setBulkRemove(true);
            this.cache_._removeObject(fqn, true);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("putObject(): fqn: " + fqn));
        }
        if (obj instanceof Advised) {
            CachedType type = this.cache_.getCachedType(obj.getClass());
            InstanceAdvisor advisor = ((Advised)obj)._getInstanceAdvisor();
            if (advisor == null) {
                throw new RuntimeException("_putObject(): InstanceAdvisor is null for: " + obj);
            }
            Interceptor interceptor = AopUtil.findCacheInterceptor(advisor);
            if (this.graphHandler_.objectGraphPut(fqn, interceptor, type, obj)) {
                return oldValue;
            }
            this._regularPutObject(fqn, obj, advisor, type);
        } else if (!this.collectionHandler_.collectionObjectPut(fqn, obj) && !this.serializableHandler_.serializableObjectPut(fqn, obj)) {
            throw new RuntimeException("putObject(): obj: " + obj + " type is not recognizable.");
        }
        return oldValue;
    }

    protected boolean bulkRemove(Fqn fqn, Object obj) throws CacheException {
        HashMap undoMap = new HashMap();
        if (this.pojoGraphMultipleReferenced(obj, undoMap)) {
            this.undoInterceptorDetach(undoMap);
            return false;
        }
        this.cache_.remove(fqn);
        return true;
    }

    protected void detachInterceptor(InstanceAdvisor advisor, Interceptor interceptor, boolean detachOnly, Map undoMap) {
        if (!detachOnly) {
            advisor.removeInterceptor(interceptor.getName());
            undoMap.put(advisor, interceptor);
        } else {
            undoMap.put("DETACH", interceptor);
        }
    }

    protected void undoInterceptorDetach(Map undoMap) {
        for (Object obj : undoMap.keySet()) {
            if (obj instanceof InstanceAdvisor) {
                InstanceAdvisor advisor = (InstanceAdvisor)obj;
                BaseInterceptor interceptor = (BaseInterceptor)undoMap.get(advisor);
                if (interceptor == null) {
                    throw new IllegalStateException("TreeCacheAopDelegate.undoInterceptorDetach(): null interceptor");
                }
                advisor.appendInterceptor((Interceptor)interceptor);
                continue;
            }
            BaseInterceptor interceptor = (BaseInterceptor)undoMap.get(obj);
            boolean copyToCache = false;
            ((AbstractCollectionInterceptor)interceptor).attach(null, copyToCache);
        }
    }

    protected boolean pojoGraphMultipleReferenced(Object obj, Map undoMap) throws CacheException {
        if (obj instanceof Advised) {
            CachedType type = this.cache_.getCachedType(obj.getClass());
            InstanceAdvisor advisor = ((Advised)obj)._getInstanceAdvisor();
            if (advisor == null) {
                throw new RuntimeException("pojoGraphMultipleReferenced(): InstanceAdvisor is null for: " + obj);
            }
            BaseInterceptor interceptor = (BaseInterceptor)AopUtil.findCacheInterceptor(advisor);
            if (interceptor == null) {
                return false;
            }
            AOPInstance aopInstance = interceptor.getAopInstance();
            if (aopInstance.getRefCount() != 0) {
                return true;
            }
            if (aopInstance.getRefFqn() != null) {
                return true;
            }
            boolean hasFieldAnnotation = this.hasAnnotation(obj.getClass(), ((Advised)obj)._getAdvisor(), type);
            Iterator i = type.getFieldsIterator();
            while (i.hasNext()) {
                Field field = (Field)i.next();
                Object value = null;
                try {
                    value = field.get(obj);
                }
                catch (IllegalAccessException e) {
                    throw new CacheException("field access failed", e);
                }
                CachedType fieldType = this.cache_.getCachedType(field.getType());
                if (fieldType.isImmediate() || hasFieldAnnotation && CachedType.hasSerializableAnnotation(field, ((Advised)obj)._getAdvisor()) || CachedType.isPrimitiveNonReplicatable(field) || !hasFieldAnnotation && CachedType.hasTransientAnnotation(field, ((Advised)obj)._getAdvisor())) continue;
                if (value == null) {
                    value = this._getObject(new Fqn(interceptor.getFqn(), field.getName()));
                }
                if (value == null || !this.pojoGraphMultipleReferenced(value, undoMap)) continue;
                return true;
            }
            boolean detachOnly = false;
            this.detachInterceptor(advisor, interceptor, detachOnly, undoMap);
        } else if (obj instanceof Map || obj instanceof List || obj instanceof Set) {
            if (!(obj instanceof ClassProxy)) {
                return false;
            }
            InstanceAdvisor advisor = ((ClassProxy)obj)._getInstanceAdvisor();
            BaseInterceptor interceptor = (BaseInterceptor)AopUtil.findCollectionInterceptor(advisor);
            AOPInstance aopInstance = interceptor.getAopInstance();
            if (aopInstance == null) {
                return false;
            }
            if (aopInstance.getRefCount() != 0) {
                return true;
            }
            if (aopInstance.getRefFqn() != null) {
                return true;
            }
            if (obj instanceof Map) {
                Iterator<Object> it = ((Map)obj).keySet().iterator();
                while (it.hasNext()) {
                    Object subObj = ((Map)obj).get(it.next());
                    if (!this.pojoGraphMultipleReferenced(subObj, undoMap)) continue;
                    return true;
                }
            } else if (obj instanceof List || obj instanceof Set) {
                for (Object subObj : (Collection)obj) {
                    if (!this.pojoGraphMultipleReferenced(subObj, undoMap)) continue;
                    return true;
                }
            }
            boolean removeFromCache = false;
            ((AbstractCollectionInterceptor)interceptor).detach(removeFromCache);
            boolean detachOnly = true;
            this.detachInterceptor(advisor, interceptor, detachOnly, undoMap);
        }
        return false;
    }

    protected void _regularPutObject(Fqn fqn, Object obj, InstanceAdvisor advisor, CachedType type) throws CacheException {
        Object value;
        if (advisor == null) {
            advisor = new ClassInstanceAdvisor(obj);
            ((Advised)obj)._setInstanceAdvisor(advisor);
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        AOPInstance aopInstance = this.internal_.initializeAopInstance(fqn);
        CacheInterceptor interceptor = new CacheInterceptor(this.cache_, fqn, type);
        interceptor.setAopInstance(aopInstance);
        advisor.appendInterceptor((Interceptor)interceptor);
        this.cache_.addUndoInterceptor(advisor, interceptor, 0);
        map.put(AOPInstance.KEY, aopInstance);
        this.internal_.putAopClazz(fqn, type.getType(), map);
        HashMap<Field, Object> subPojoMap = new HashMap<Field, Object>();
        boolean hasFieldAnnotation = this.hasAnnotation(obj.getClass(), ((Advised)obj)._getAdvisor(), type);
        boolean todo = false;
        Iterator i = type.getFieldsIterator();
        while (i.hasNext()) {
            Field field = (Field)i.next();
            value = null;
            try {
                value = field.get(obj);
            }
            catch (IllegalAccessException e) {
                throw new CacheException("field access failed", e);
            }
            CachedType fieldType = this.cache_.getCachedType(field.getType());
            if (hasFieldAnnotation && CachedType.hasTransientAnnotation(field, ((Advised)obj)._getAdvisor()) || CachedType.isPrimitiveNonReplicatable(field)) continue;
            if (fieldType.isImmediate() || hasFieldAnnotation && CachedType.hasSerializableAnnotation(field, ((Advised)obj)._getAdvisor())) {
                map.put(field.getName(), value);
                continue;
            }
            subPojoMap.put(field, value);
        }
        this.cache_.put(fqn, map, this.internal_.getLockOption());
        this.internal_.setPojo(aopInstance, obj);
        for (Field field : subPojoMap.keySet()) {
            value = subPojoMap.get(field);
            Fqn tmpFqn = new Fqn(fqn, field.getName());
            this._putObject(tmpFqn, value);
            this.collectionHandler_.collectionReplaceWithProxy(obj, value, field, tmpFqn);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("_regularPutObject(): inserting with fqn: " + fqn));
        }
    }

    private boolean hasAnnotation(Class clazz, Advisor advisor, CachedType type) {
        return CachedType.hasAnnotation(clazz, advisor, type);
    }

    private void createNode(Fqn fqn, GlobalTransaction tx) {
        Fqn tmp_fqn = Fqn.ROOT;
        if (fqn == null) {
            return;
        }
        int treeNodeSize = fqn.size();
        TreeNode n = this.cache_.getRoot();
        int i = 0;
        while (i < treeNodeSize) {
            Object child_name = fqn.get(i);
            tmp_fqn = new Fqn(tmp_fqn, child_name);
            TreeNode child_node = n.getChild(child_name);
            if (child_node == null) {
                child_node = n.createChild(child_name, tmp_fqn, n);
                if (tx != null) {
                    JBCMethodCall undo_op = MethodCallFactory.create(MethodDeclarations.removeNodeMethodLocal, new Object[]{tx, tmp_fqn, Boolean.FALSE});
                    this.cache_.addUndoOperation(tx, undo_op);
                }
            }
            n = child_node;
            ++i;
        }
    }

    public Object _removeObject(Fqn fqn, boolean removeCacheInterceptor, boolean evict) throws CacheException {
        Object result;
        Class clazz = this.internal_.peekAopClazz(fqn);
        if (clazz == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("_removeObject(): clasz is null. fqn: " + fqn + " No need to remove."));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("_removeObject(): removing object from fqn: " + fqn));
        }
        if ((result = this.cache_.getObject(fqn)) == null) {
            if (this.cache_.exists(fqn)) {
                if (!evict) {
                    this.cache_.remove(fqn);
                } else {
                    this.cache_._evict(fqn);
                }
            }
            return null;
        }
        if (this.getBulkRemove()) {
            if (this.bulkRemove(fqn, result)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("_removeObject(): fqn: " + fqn + "removing exisiting object in bulk."));
                }
                return result;
            }
            this.setBulkRemove(false);
        }
        if (this.graphHandler_.objectGraphRemove(fqn, removeCacheInterceptor, result, evict)) {
            return result;
        }
        if (Advised.class.isAssignableFrom(clazz)) {
            this._regularRemoveObject(fqn, removeCacheInterceptor, result, clazz, evict);
        } else if (!this.collectionHandler_.collectionObjectRemove(fqn, removeCacheInterceptor, evict)) {
            this.serializableHandler_.serializableObjectRemove(fqn);
        }
        this.internal_.cleanUp(fqn, evict);
        return result;
    }

    protected void _regularRemoveObject(Fqn fqn, boolean removeCacheInterceptor, Object result, Class clazz, boolean evict) throws CacheException {
        CacheInterceptor interceptor;
        InstanceAdvisor advisor = ((Advised)result)._getInstanceAdvisor();
        CachedType type = this.cache_.getCachedType(clazz);
        Iterator i = type.getFieldsIterator();
        while (i.hasNext()) {
            Field field = (Field)i.next();
            CachedType fieldType = this.cache_.getCachedType(field.getType());
            if (fieldType.isImmediate()) continue;
            this._removeObject(new Fqn(fqn, field.getName()), removeCacheInterceptor, evict);
        }
        this.cache_.removeData(fqn);
        if (removeCacheInterceptor && (interceptor = (CacheInterceptor)AopUtil.findCacheInterceptor(advisor)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("regularRemoveObject(): removed cache interceptor fqn: " + fqn + " interceptor: " + interceptor));
            }
            advisor.removeInterceptor(interceptor.getName());
            this.cache_.addUndoInterceptor(advisor, interceptor, 1);
        }
    }

    boolean isAopNode(Fqn fqn) {
        try {
            return this.internal_.isAopNode(fqn);
        }
        catch (Exception e) {
            log.warn((Object)("isAopNode(): cache get operation generated exception " + e));
            return false;
        }
    }

    protected Map _findObjects(Fqn fqn) throws CacheException {
        HashMap<Fqn, Object> map = new HashMap<Fqn, Object>();
        Object pojo = this._getObject(fqn);
        if (pojo != null) {
            map.put(fqn, pojo);
            return map;
        }
        this.findChildObjects(fqn, map);
        if (log.isDebugEnabled()) {
            log.debug((Object)("_findObjects(): Fqn: " + fqn + " size of pojos found: " + map.size()));
        }
        return map;
    }

    protected void findChildObjects(Fqn fqn, Map map) throws CacheException {
        Set set = this.cache_.getChildrenNames(fqn);
        if (set == null) {
            return;
        }
        for (String obj : set) {
            Fqn newFqn = new Fqn(fqn, obj);
            Object pojo = this._getObject(newFqn);
            if (pojo != null) {
                map.put(newFqn, pojo);
                continue;
            }
            this.findChildObjects(newFqn, map);
        }
    }
}

