/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop;

import bsh.ConsoleInterface;
import bsh.Interpreter;
import bsh.util.JConsole;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeCacheListener;
import org.jboss.cache.aop.AOPInstance;
import org.jboss.cache.aop.ShutdownThread;
import org.jboss.cache.aop.TreeCacheView2;
import org.jgroups.View;

class TreeCacheGui2
extends JFrame
implements WindowListener,
TreeCacheListener,
TreeSelectionListener,
TableModelListener {
    private static final long serialVersionUID = -1242167331988194987L;
    TreeCache cache_;
    DefaultTreeModel tree_model = null;
    Log log = LogFactory.getLog(this.getClass());
    JTree jtree = null;
    DefaultTableModel table_model = new DefaultTableModel();
    JTable table = new JTable(this.table_model);
    MyNode root = new MyNode(SEP);
    String props = null;
    String selected_node = null;
    JPanel tablePanel = null;
    JMenu operationsMenu = null;
    JPopupMenu operationsPopup = null;
    JMenuBar menubar = null;
    boolean use_system_exit = false;
    static String SEP = "/";
    private static final int KEY_COL_WIDTH = 20;
    private static final int VAL_COL_WIDTH = 300;
    final String STRING = String.class.getName();
    final String MAP = Map.class.getName();
    final String OBJECT = Object.class.getName();
    TransactionManager tx_mgr = null;
    Transaction tx = null;
    JPanel mainPanel;

    public TreeCacheGui2(TreeCache cache) throws Exception {
        this.addNotify();
        this.tree_model = new DefaultTreeModel(this.root);
        this.jtree = new JTree(this.tree_model);
        this.jtree.setDoubleBuffered(true);
        this.jtree.getSelectionModel().setSelectionMode(1);
        JScrollPane scroll_pane = new JScrollPane(this.jtree);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)scroll_pane, "Center");
        this.addWindowListener(this);
        this.table_model.setColumnIdentifiers(new String[]{"Name", "Value"});
        this.table_model.addTableModelListener(this);
        this.setTableColumnWidths();
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BorderLayout());
        this.tablePanel.add((Component)this.table.getTableHeader(), "North");
        this.tablePanel.add((Component)this.table, "Center");
        this.mainPanel.add((Component)this.tablePanel, "South");
        JSplitPane contentPanel = null;
        if (TreeCacheView2.useConsole) {
            JConsole bshConsole = new JConsole();
            Interpreter interpreter = new Interpreter((ConsoleInterface)bshConsole);
            interpreter.getNameSpace().importCommands("org.jboss.cache.util");
            interpreter.setShowResults(!interpreter.getShowResults());
            System.setOut(bshConsole.getOut());
            System.setErr(bshConsole.getErr());
            Thread t = new Thread((Runnable)interpreter);
            t.start();
            contentPanel = new JSplitPane(0, this.mainPanel, (Component)bshConsole);
            this.getContentPane().add(contentPanel);
        } else {
            this.getContentPane().add(this.mainPanel);
        }
        this.jtree.addTreeSelectionListener(this);
        MouseAdapter ml = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int selRow = TreeCacheGui2.this.jtree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = TreeCacheGui2.this.jtree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1) {
                    TreeCacheGui2.this.selected_node = TreeCacheGui2.this.makeFQN(selPath.getPath());
                    TreeCacheGui2.this.jtree.setSelectionPath(selPath);
                    if (e.getModifiers() == 4) {
                        TreeCacheGui2.this.operationsPopup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        };
        this.jtree.addMouseListener(ml);
        this.createMenus();
        this.setLocation(50, 50);
        this.setSize(this.getInsets().left + this.getInsets().right + 485, this.getInsets().top + this.getInsets().bottom + 367);
        this.init();
        this.setCache(cache);
        this.setVisible(true);
        if (TreeCacheView2.useConsole) {
            contentPanel.setDividerLocation(0.65);
        }
    }

    public void setCache(TreeCache tree) {
        this.cache_ = tree;
        if (this.cache_ != null) {
            Runtime.getRuntime().addShutdownHook(new ShutdownThread(tree));
            this.cache_.addTreeCacheListener(this);
            this.setTitle("TreeCacheGui2: mbr=" + this.getLocalAddress());
            this.tx_mgr = this.cache_.getTransactionManager();
            this.populateTree();
        } else {
            this.setTitle("Cache undefined");
            if (this.tree_model != null) {
                this.root = new MyNode(SEP);
                this.tree_model.setRoot(this.root);
                this.tree_model.reload();
            }
            if (this.table_model != null) {
                this.clearTable();
            }
        }
    }

    void setSystemExit(boolean flag) {
        this.use_system_exit = flag;
    }

    public void windowClosed(WindowEvent event) {
    }

    public void windowDeiconified(WindowEvent event) {
    }

    public void windowIconified(WindowEvent event) {
    }

    public void windowActivated(WindowEvent event) {
    }

    public void windowDeactivated(WindowEvent event) {
    }

    public void windowOpened(WindowEvent event) {
    }

    public void windowClosing(WindowEvent event) {
        this.stopGui();
    }

    public void tableChanged(TableModelEvent evt) {
        if (evt.getType() == 0) {
            int row = evt.getFirstRow();
            int col = evt.getColumn();
            if (col == 0) {
                String key = (String)this.table_model.getValueAt(row, col);
                String val = (String)this.table_model.getValueAt(row, col + 1);
                if (key != null && val != null) {
                    try {
                        this.cache_.put(this.selected_node, (Object)key, (Object)val);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                String key = (String)this.table_model.getValueAt(row, col - 1);
                String val = (String)this.table.getValueAt(row, col);
                if (key != null && val != null) {
                    this.put(this.selected_node, key, val);
                }
            }
        }
    }

    public void valueChanged(TreeSelectionEvent evt) {
        TreePath path = evt.getPath();
        String fqn = SEP;
        Map data = null;
        int i = 0;
        while (i < path.getPathCount()) {
            String component_name = ((MyNode)path.getPathComponent((int)i)).name;
            if (!component_name.equals(SEP)) {
                fqn = fqn.equals(SEP) ? String.valueOf(fqn) + component_name : String.valueOf(fqn) + SEP + component_name;
            }
            ++i;
        }
        data = this.getData(Fqn.fromString(fqn));
        if (data != null) {
            this.mainPanel.add((Component)this.tablePanel, "South");
            this.populateTable(data);
            this.validate();
        } else {
            this.clearTable();
            this.mainPanel.remove(this.tablePanel);
            this.validate();
        }
    }

    public void nodeCreated(Fqn fqn) {
        MyNode n = this.root.add(fqn.toString());
        if (n != null) {
            MyNode p = (MyNode)n.getParent();
            this.tree_model.reload(p);
            this.jtree.scrollPathToVisible(new TreePath(n.getPath()));
        }
    }

    public void nodeRemoved(Fqn fqn) {
        MyNode n = this.root.findNode(fqn.toString());
        if (n != null) {
            n.removeAllChildren();
            TreeNode par = n.getParent();
            n.removeFromParent();
            this.tree_model.reload(par);
        }
    }

    public void nodeLoaded(Fqn fqn) {
        this.nodeCreated(fqn);
    }

    public void nodeEvicted(Fqn fqn) {
        this.nodeRemoved(fqn);
    }

    public void nodeModified(Fqn fqn) {
        Map data = this.getData(fqn);
        this.populateTable(data);
    }

    public void nodeVisited(Fqn fqn) {
    }

    public void cacheStarted(TreeCache cache) {
    }

    public void cacheStopped(TreeCache cache) {
    }

    public void viewChange(final View new_view) {
        new Thread(){

            public void run() {
                Vector mbrship;
                if (new_view != null && (mbrship = new_view.getMembers()) != null) {
                    TreeCacheGui2.this._put(SEP, "members", mbrship);
                    TreeCacheGui2.this._put(SEP, "coordinator", mbrship.firstElement());
                }
            }
        }.start();
    }

    public void run() {
    }

    void init() {
        Vector mbrship = null;
        Vector vector = mbrship = this.getMembers() != null ? (Vector)this.getMembers().clone() : null;
        if (mbrship != null && mbrship.size() > 0) {
            this._put(SEP, "members", mbrship);
            this._put(SEP, "coordinator", mbrship.firstElement());
        }
    }

    private void populateTree() {
        this.addGuiNode(SEP);
    }

    void addGuiNode(String fqn) {
        if (fqn == null) {
            return;
        }
        this.root.add(fqn);
        Set children = this.getChildrenNames(fqn);
        if (children != null) {
            Iterator it = children.iterator();
            while (it.hasNext()) {
                String child_name = it.next().toString();
                this.addGuiNode(String.valueOf(fqn) + SEP + child_name);
            }
        }
    }

    String makeFQN(Object[] path) {
        String tmp_name;
        StringBuffer sb = new StringBuffer("");
        if (path == null) {
            return null;
        }
        int i = 0;
        while (i < path.length) {
            tmp_name = ((MyNode)path[i]).name;
            if (!tmp_name.equals(SEP)) {
                sb.append(String.valueOf(SEP) + tmp_name);
            }
            ++i;
        }
        tmp_name = sb.toString();
        if (tmp_name.length() == 0) {
            return SEP;
        }
        return tmp_name;
    }

    void clearTable() {
        int num_rows = this.table.getRowCount();
        if (num_rows > 0) {
            int i = 0;
            while (i < num_rows) {
                this.table_model.removeRow(0);
                ++i;
            }
            this.table_model.fireTableRowsDeleted(0, num_rows - 1);
            this.repaint();
        }
    }

    void populateTable(Map data) {
        String strval = "<null>";
        int num_rows = 0;
        if (data == null) {
            return;
        }
        num_rows = data.size();
        this.clearTable();
        if (num_rows > 0) {
            for (Map.Entry entry : data.entrySet()) {
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                if (this.IsPojoInternalNode(key)) continue;
                if (val != null) {
                    strval = val.toString();
                }
                this.table_model.addRow(new Object[]{key, strval});
            }
            this.table_model.fireTableRowsInserted(0, num_rows - 1);
            this.validate();
        }
    }

    private boolean IsPojoInternalNode(String key) {
        if (key.equals("__jboss:internal:class__")) {
            return true;
        }
        if (key.equals(AOPInstance.KEY)) {
            return true;
        }
        return key.equals("_lock_");
    }

    private void setTableColumnWidths() {
        this.table.sizeColumnsToFit(1);
        TableColumn column = null;
        column = this.table.getColumnModel().getColumn(0);
        column.setMinWidth(20);
        column.setPreferredWidth(20);
        column = this.table.getColumnModel().getColumn(1);
        column.setPreferredWidth(300);
    }

    private void createMenus() {
        this.menubar = new JMenuBar();
        this.operationsMenu = new JMenu("Operations");
        AddNodeAction addNode = new AddNodeAction();
        addNode.putValue("Name", "Add to this node");
        LoadAction load_action = new LoadAction();
        load_action.putValue("Name", "Load from the CacheLoader");
        RemoveNodeAction removeNode = new RemoveNodeAction();
        removeNode.putValue("Name", "Remove this node");
        EvictAction evict_action = new EvictAction();
        evict_action.putValue("Name", "Evict from the Cache");
        AddModifyDataForNodeAction addModAction = new AddModifyDataForNodeAction();
        addModAction.putValue("Name", "Add/Modify data");
        PrintLockInfoAction print_locks = new PrintLockInfoAction();
        print_locks.putValue("Name", "Print lock information (stdout)");
        ReleaseAllLocksAction release_locks = new ReleaseAllLocksAction();
        release_locks.putValue("Name", "Release all locks");
        ExitAction exitAction = new ExitAction();
        exitAction.putValue("Name", "Exit");
        StartTransaction start_tx = new StartTransaction();
        start_tx.putValue("Name", "Start TX");
        CommitTransaction commit_tx = new CommitTransaction();
        commit_tx.putValue("Name", "Commit TX");
        RollbackTransaction rollback_tx = new RollbackTransaction();
        rollback_tx.putValue("Name", "Rollback TX");
        this.operationsMenu.add(addNode);
        this.operationsMenu.add(load_action);
        this.operationsMenu.add(removeNode);
        this.operationsMenu.add(evict_action);
        this.operationsMenu.add(addModAction);
        this.operationsMenu.add(print_locks);
        this.operationsMenu.add(release_locks);
        this.operationsMenu.add(start_tx);
        this.operationsMenu.add(commit_tx);
        this.operationsMenu.add(rollback_tx);
        this.operationsMenu.add(exitAction);
        this.menubar.add(this.operationsMenu);
        this.setJMenuBar(this.menubar);
        this.operationsPopup = new JPopupMenu();
        this.operationsPopup.add(addNode);
        this.operationsPopup.add(load_action);
        this.operationsPopup.add(evict_action);
        this.operationsPopup.add(removeNode);
        this.operationsPopup.add(addModAction);
    }

    Object getLocalAddress() {
        try {
            return this.cache_.getLocalAddress();
        }
        catch (Throwable t) {
            this.log.error((Object)("TreeCacheGui2.getLocalAddress(): " + t));
            return null;
        }
    }

    Map getData(Fqn fqn) {
        return this.cache_._getData(fqn);
    }

    void load(String fqn) {
        try {
            this.cache_.load(fqn);
        }
        catch (Throwable t) {
            this.log.error((Object)("TreeCacheGui2.load(): " + t));
        }
    }

    void evict(String fqn) {
        try {
            this.cache_.evict(Fqn.fromString(fqn));
        }
        catch (Throwable t) {
            this.log.error((Object)("TreeCacheGui2.evict(): " + t));
        }
    }

    void put(String fqn, Map m) {
        try {
            this.cache_.put(fqn, m);
        }
        catch (Throwable t) {
            this.log.error((Object)("TreeCacheGui2.put(): " + t));
        }
    }

    void _put(String fqn, Map m) {
        try {
            this.cache_._put(null, fqn, m, false);
        }
        catch (Throwable t) {
            this.log.error((Object)("TreeCacheGui2._put(): " + t));
        }
    }

    void put(String fqn, String key, Object value) {
        try {
            this.cache_.put(fqn, (Object)key, value);
        }
        catch (Throwable t) {
            this.log.error((Object)("TreeCacheGui2.put(): " + t));
        }
    }

    void _put(String fqn, String key, Object value) {
        try {
            this.cache_._put(null, fqn, (Object)key, value, false);
        }
        catch (Throwable t) {
            this.log.error((Object)("TreeCacheGui2._put(): " + t));
        }
    }

    Set getKeys(String fqn) {
        try {
            return this.cache_.getKeys(fqn);
        }
        catch (Throwable t) {
            this.log.error((Object)("TreeCacheGui2.getKeys(): " + t));
            return null;
        }
    }

    Object get(String fqn, String key) {
        try {
            return this.cache_.get(fqn, (Object)key);
        }
        catch (Throwable t) {
            this.log.error((Object)("TreeCacheGui2.get(): " + t));
            return null;
        }
    }

    Set getChildrenNames(String fqn) {
        try {
            return this.cache_.getChildrenNames(fqn);
        }
        catch (Throwable t) {
            this.log.error((Object)("TreeCacheGui2.getChildrenNames(): " + t));
            return null;
        }
    }

    Vector getMembers() {
        try {
            return this.cache_.getMembers();
        }
        catch (Throwable t) {
            this.log.error((Object)("TreeCacheGui.getMembers(): " + t));
            return null;
        }
    }

    void stopGui() {
        if (this.cache_ != null) {
            try {
                this.cache_.stopService();
                this.cache_.destroyService();
                this.cache_ = null;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.dispose();
        System.exit(0);
    }

    class AddModifyDataForNodeAction
    extends AbstractAction {
        private static final long serialVersionUID = -7656592171312920825L;

        AddModifyDataForNodeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            HashMap<String, String> data = TreeCacheGui2.this.getData(Fqn.fromString(TreeCacheGui2.this.selected_node));
            if (data == null || data.size() <= 0) {
                TreeCacheGui2.this.clearTable();
                data = new HashMap<String, String>();
                data.put("Add Key", "Add Value");
            }
            TreeCacheGui2.this.populateTable(data);
            TreeCacheGui2.this.getContentPane().add((Component)TreeCacheGui2.this.tablePanel, "South");
            TreeCacheGui2.this.validate();
        }
    }

    class AddNodeAction
    extends AbstractAction {
        private static final long serialVersionUID = 7084928639244438800L;

        AddNodeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTextField fqnTextField = new JTextField();
            if (TreeCacheGui2.this.selected_node != null) {
                fqnTextField.setText(TreeCacheGui2.this.selected_node);
            }
            Object[] information = new Object[]{"Enter fully qualified name", fqnTextField};
            String btnString1 = "OK";
            String btnString2 = "Cancel";
            Object[] options = new Object[]{"OK", "Cancel"};
            int userChoice = JOptionPane.showOptionDialog(null, information, "Add DataNode", 0, -1, null, options, options[0]);
            if (userChoice == 0) {
                String userInput = fqnTextField.getText();
                TreeCacheGui2.this.put(userInput, null);
            }
        }
    }

    class CommitTransaction
    extends AbstractAction {
        private static final long serialVersionUID = 5426108920883879873L;

        CommitTransaction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (TreeCacheGui2.this.tx == null) {
                TreeCacheGui2.this.log.error((Object)"transaction is not running");
                return;
            }
            try {
                try {
                    TreeCacheGui2.this.tx.commit();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    TreeCacheGui2.this.tx = null;
                }
            }
            finally {
                TreeCacheGui2.this.tx = null;
            }
        }
    }

    class EvictAction
    extends AbstractAction {
        private static final long serialVersionUID = 6007500908549034215L;

        EvictAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTextField fqnTextField = new JTextField();
            if (TreeCacheGui2.this.selected_node != null) {
                fqnTextField.setText(TreeCacheGui2.this.selected_node);
            }
            Object[] information = new Object[]{"Enter fully qualified name", fqnTextField};
            String btnString1 = "OK";
            String btnString2 = "Cancel";
            Object[] options = new Object[]{"OK", "Cancel"};
            int userChoice = JOptionPane.showOptionDialog(null, information, "Evict DataNode", 0, -1, null, options, options[0]);
            if (userChoice == 0) {
                String userInput = fqnTextField.getText();
                TreeCacheGui2.this.evict(userInput);
            }
        }
    }

    class ExitAction
    extends AbstractAction {
        private static final long serialVersionUID = -5364163916172148038L;

        ExitAction() {
        }

        public void actionPerformed(ActionEvent e) {
            TreeCacheGui2.this.stopGui();
        }
    }

    class LoadAction
    extends AbstractAction {
        private static final long serialVersionUID = -6998760732995584428L;

        LoadAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTextField fqnTextField = new JTextField();
            if (TreeCacheGui2.this.selected_node != null) {
                fqnTextField.setText(TreeCacheGui2.this.selected_node);
            }
            Object[] information = new Object[]{"Enter fully qualified name", fqnTextField};
            String btnString1 = "OK";
            String btnString2 = "Cancel";
            Object[] options = new Object[]{"OK", "Cancel"};
            int userChoice = JOptionPane.showOptionDialog(null, information, "Load DataNode", 0, -1, null, options, options[0]);
            if (userChoice == 0) {
                String userInput = fqnTextField.getText();
                TreeCacheGui2.this.load(userInput);
            }
        }
    }

    class MyNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 4882445905140460053L;
        String name = "<unnamed>";

        MyNode(String name) {
            this.name = name;
        }

        public MyNode add(String fqn) {
            MyNode ret = null;
            if (fqn == null) {
                return null;
            }
            MyNode curr = this;
            StringTokenizer tok = new StringTokenizer(fqn, SEP);
            while (tok.hasMoreTokens()) {
                String child_name = tok.nextToken();
                MyNode n = curr.findChild(child_name);
                if (n == null) {
                    n = new MyNode(child_name);
                    if (ret == null) {
                        ret = n;
                    }
                    curr.add(n);
                }
                curr = n;
            }
            return ret;
        }

        public void remove(String fqn) {
            this.removeFromParent();
        }

        MyNode findNode(String fqn) {
            if (fqn == null) {
                return null;
            }
            MyNode curr = this;
            StringTokenizer tok = new StringTokenizer(fqn, SEP);
            while (tok.hasMoreTokens()) {
                String child_name = tok.nextToken();
                MyNode n = curr.findChild(child_name);
                if (n == null) {
                    return null;
                }
                curr = n;
            }
            return curr;
        }

        MyNode findChild(String relative_name) {
            if (relative_name == null || this.getChildCount() == 0) {
                return null;
            }
            int i = 0;
            while (i < this.getChildCount()) {
                MyNode child = (MyNode)this.getChildAt(i);
                if (child.name != null && child.name.equals(relative_name)) {
                    return child;
                }
                ++i;
            }
            return null;
        }

        String print(int indent) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < indent) {
                sb.append(" ");
                ++i;
            }
            if (!this.isRoot()) {
                if (this.name == null) {
                    sb.append("/<unnamed>");
                } else {
                    sb.append(String.valueOf(SEP) + this.name);
                }
            }
            sb.append("\n");
            if (this.getChildCount() > 0) {
                indent = this.isRoot() ? 0 : (indent += 4);
                i = 0;
                while (i < this.getChildCount()) {
                    sb.append(((MyNode)this.getChildAt(i)).print(indent));
                    ++i;
                }
            }
            return sb.toString();
        }

        public String toString() {
            return this.name;
        }
    }

    class PrintLockInfoAction
    extends AbstractAction {
        private static final long serialVersionUID = -2171307516592250436L;

        PrintLockInfoAction() {
        }

        public void actionPerformed(ActionEvent e) {
            System.out.println("\n*** lock information ****\n" + TreeCacheGui2.this.cache_.printLockInfo());
        }
    }

    class ReleaseAllLocksAction
    extends AbstractAction {
        private static final long serialVersionUID = 6894888234400908985L;

        ReleaseAllLocksAction() {
        }

        public void actionPerformed(ActionEvent e) {
            TreeCacheGui2.this.cache_.releaseAllLocks("/");
        }
    }

    class RemoveNodeAction
    extends AbstractAction {
        private static final long serialVersionUID = 3746013603940497991L;

        RemoveNodeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                TreeCacheGui2.this.cache_.remove(TreeCacheGui2.this.selected_node);
            }
            catch (Throwable t) {
                TreeCacheGui2.this.log.error((Object)("RemoveNodeAction.actionPerformed(): " + t));
            }
        }
    }

    class RollbackTransaction
    extends AbstractAction {
        private static final long serialVersionUID = -4836748411400541430L;

        RollbackTransaction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (TreeCacheGui2.this.tx == null) {
                TreeCacheGui2.this.log.error((Object)"transaction is not running");
                return;
            }
            try {
                try {
                    TreeCacheGui2.this.tx.rollback();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    TreeCacheGui2.this.tx = null;
                }
            }
            finally {
                TreeCacheGui2.this.tx = null;
            }
        }
    }

    class StartTransaction
    extends AbstractAction {
        private static final long serialVersionUID = 7059131008813144857L;

        StartTransaction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (TreeCacheGui2.this.tx_mgr == null) {
                TreeCacheGui2.this.log.error((Object)"no TransactionManager specified");
                return;
            }
            if (TreeCacheGui2.this.tx != null) {
                TreeCacheGui2.this.log.error((Object)("transaction is already running: " + TreeCacheGui2.this.tx));
                return;
            }
            try {
                TreeCacheGui2.this.tx_mgr.begin();
                TreeCacheGui2.this.tx = TreeCacheGui2.this.tx_mgr.getTransaction();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

