/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class CachedListAbstract
implements List {
    public void clear() {
        int i = this.size() - 1;
        while (i >= 0) {
            this.remove(i);
            --i;
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object[] toArray() {
        Object[] objs = new Object[this.size()];
        int i = 0;
        while (i < this.size()) {
            objs[i] = this.get(i);
            ++i;
        }
        return objs;
    }

    public Object[] toArray(Object[] a) {
        int actualLength = this.size();
        if (actualLength > a.length) {
            a = new Object[actualLength];
        }
        int looper = 0;
        while (looper < actualLength) {
            a[looper] = this.get(looper);
            ++looper;
        }
        while (looper < a.length) {
            a[looper] = null;
            ++looper;
        }
        return a;
    }

    public boolean add(Object o) {
        this.add(this.size(), o);
        return true;
    }

    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    public boolean remove(Object o) {
        int i = this.indexOf(o);
        if (i == -1) {
            return false;
        }
        this.remove(i);
        return true;
    }

    public boolean addAll(int index, Collection c) {
        if (c.size() == 0) {
            return false;
        }
        for (Object o : c) {
            this.add(index++, o);
        }
        return true;
    }

    public boolean addAll(Collection c) {
        if (c.size() == 0) {
            return false;
        }
        for (Object o : c) {
            this.add(o);
        }
        return true;
    }

    public boolean containsAll(Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    public boolean removeAll(Collection c) {
        for (Object o : c) {
            this.remove(o);
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        int i = 0;
        while (i < this.size()) {
            Object o = this.get(i);
            result += o == null ? 0 : o.hashCode();
            ++i;
        }
        return result;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.size() != list.size()) {
            return false;
        }
        int i = 0;
        while (i < list.size()) {
            Object value = list.get(i);
            if (!this.contains(value)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int size = this.size();
        int i = 0;
        while (i < size) {
            Object key = this.get(i);
            buf.append("[").append(key).append("]");
            if (i <= size) {
                buf.append(", ");
            }
            ++i;
        }
        return buf.toString();
    }

    public boolean retainAll(Collection c) {
        boolean changedAnything = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (c.contains(iter.next())) continue;
            iter.remove();
            changedAnything = true;
        }
        return changedAnything;
    }
}

