/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop.collection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.proxy.ClassProxy;
import org.jboss.aop.proxy.ClassProxyFactory;
import org.jboss.aop.util.MethodHashing;
import org.jboss.cache.Fqn;
import org.jboss.cache.aop.PojoCache;
import org.jboss.cache.aop.collection.AbstractCollectionInterceptor;
import org.jboss.cache.aop.collection.CachedListInterceptor;
import org.jboss.cache.aop.collection.CachedMapInterceptor;
import org.jboss.cache.aop.collection.CachedSetInterceptor;
import org.jboss.cache.aop.util.AopUtil;

public class CollectionInterceptorUtil {
    static Log log = LogFactory.getLog((String)CollectionInterceptorUtil.class.getName());

    public static ClassProxy createProxy(Class clazz, AbstractCollectionInterceptor interceptor) throws Exception {
        ClassProxy result = ClassProxyFactory.newInstance((Class)clazz);
        InstanceAdvisor advisor = result._getInstanceAdvisor();
        advisor.appendInterceptor((Interceptor)interceptor);
        return result;
    }

    public static ClassProxy createMapProxy(PojoCache cache, Fqn fqn, Class clazz, Map obj) throws Exception {
        return CollectionInterceptorUtil.createProxy(clazz, new CachedMapInterceptor(cache, fqn, clazz, obj));
    }

    public static ClassProxy createListProxy(PojoCache cache, Fqn fqn, Class clazz, List obj) throws Exception {
        return CollectionInterceptorUtil.createProxy(clazz, new CachedListInterceptor(cache, fqn, clazz, obj));
    }

    public static ClassProxy createSetProxy(PojoCache cache, Fqn fqn, Class clazz, Set obj) throws Exception {
        return CollectionInterceptorUtil.createProxy(clazz, new CachedSetInterceptor(cache, fqn, clazz, obj));
    }

    public static AbstractCollectionInterceptor getInterceptor(ClassProxy proxy) {
        InstanceAdvisor advisor = proxy._getInstanceAdvisor();
        return (AbstractCollectionInterceptor)AopUtil.findCollectionInterceptor(advisor);
    }

    public static Map getMethodMap(Class clazz) {
        HashMap result = ClassProxyFactory.getMethodMap((String)clazz.getName());
        if (result == null) {
            try {
                ClassProxyFactory.newInstance((Class)clazz);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            result = ClassProxyFactory.getMethodMap((String)clazz.getName());
        }
        return result;
    }

    public static Map getManagedMethods(Class clazz) {
        Method tostring = null;
        try {
            tostring = Object.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new RuntimeException("getManagedMathods: " + e);
        }
        HashMap<Long, Method> managedMethods = new HashMap<Long, Method>();
        try {
            Method[] methods = clazz.getDeclaredMethods();
            int i = 0;
            while (i < methods.length) {
                long hash = MethodHashing.methodHash((Method)methods[i]);
                managedMethods.put(new Long(hash), methods[i]);
                ++i;
            }
            long hash = MethodHashing.methodHash((Method)tostring);
            managedMethods.put(new Long(hash), tostring);
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
        return managedMethods;
    }

    public static Object invoke(Invocation invocation, Object interceptor, Map methodMap, Map managedMethods) throws Throwable {
        try {
            if (invocation instanceof MethodInvocation) {
                MethodInvocation methodInvocation = (MethodInvocation)invocation;
                Long methodHash = new Long(methodInvocation.getMethodHash());
                Method method = (Method)managedMethods.get(methodHash);
                if (log.isDebugEnabled() && method != null) {
                    log.trace((Object)("invoke(): method intercepted " + method.getName()));
                }
                Object[] args = methodInvocation.getArguments();
                if (method != null) {
                    return method.invoke(interceptor, args);
                }
                method = methodInvocation.getMethod();
                if (method == null) {
                    method = (Method)methodMap.get(methodHash);
                }
                log.trace((Object)("invke(): invoke non-managed method: " + method.toString()));
                Object target = methodInvocation.getTargetObject();
                if (target == null) {
                    throw new RuntimeException("CollectionInterceptorUtil.invoke(): targetObject is null. Can't invoke " + method.toString());
                }
                return method.invoke(target, args);
            }
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                throw e.getCause();
            }
            if (e.getTargetException() != null) {
                throw e.getTargetException();
            }
            throw e;
        }
        return invocation.invokeNext();
    }
}

