/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop.util;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.aop.Advised;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.cache.Fqn;
import org.jboss.cache.aop.BaseInterceptor;
import org.jboss.cache.aop.CacheInterceptor;

public class AopUtil {
    static Log log = LogFactory.getLog((String)AopUtil.class.getName());

    public static Interceptor findCacheInterceptor(InstanceAdvisor advisor, Fqn fqn) {
        Interceptor[] interceptors = advisor.getInterceptors();
        int i = 0;
        while (i < interceptors.length) {
            CacheInterceptor inter;
            Interceptor interceptor = interceptors[i];
            if (interceptor instanceof CacheInterceptor && (inter = (CacheInterceptor)interceptor) != null && inter.getFqn().equals(fqn)) {
                return interceptor;
            }
            ++i;
        }
        return null;
    }

    public static Interceptor findCacheInterceptor(InstanceAdvisor advisor) {
        Interceptor[] interceptors = advisor.getInterceptors();
        int i = 0;
        while (i < interceptors.length) {
            Interceptor interceptor = interceptors[i];
            if (interceptor instanceof CacheInterceptor) {
                return interceptor;
            }
            ++i;
        }
        return null;
    }

    public static Interceptor findCollectionInterceptor(InstanceAdvisor advisor) {
        Interceptor[] interceptors = advisor.getInterceptors();
        int i = 0;
        while (i < interceptors.length) {
            Interceptor interceptor = interceptors[i];
            if (interceptor instanceof BaseInterceptor) {
                return interceptor;
            }
            ++i;
        }
        return null;
    }

    public static void checkObjectType(Object obj) {
        if (obj == null) {
            return;
        }
        if (!(obj instanceof Advised)) {
            boolean allowedType;
            boolean bl = allowedType = obj instanceof Serializable || obj.getClass().isArray() && obj.getClass().getComponentType().isPrimitive();
            if (!allowedType) {
                throw new IllegalArgumentException("PojoCache.putObject(): Object type is neither  aspectized nor Serializable nor an array of primitives. Object class name is " + obj.getClass().getName());
            }
        }
    }

    public static Fqn constructFqn(Fqn baseFqn, Object relative) {
        return new Fqn(baseFqn, relative.toString());
    }
}

