/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jboss.cache.xml.XmlHelper;

public class CacheLoaderConfig {
    private boolean passivation;
    private String preload;
    private List cacheLoaderConfigs = new ArrayList();
    private boolean shared;

    public String getPreload() {
        return this.preload;
    }

    public void setPreload(String preload) {
        this.preload = preload;
    }

    public void setPassivation(boolean passivation) {
        this.passivation = passivation;
    }

    public boolean isPassivation() {
        return this.passivation;
    }

    public void addIndividualCacheLoaderConfig(IndividualCacheLoaderConfig clc) {
        this.cacheLoaderConfigs.add(clc);
    }

    public List getIndividualCacheLoaderConfigs() {
        return this.cacheLoaderConfigs;
    }

    public IndividualCacheLoaderConfig getFirstCacheLoaderConfig() {
        if (this.cacheLoaderConfigs.size() == 0) {
            return null;
        }
        return (IndividualCacheLoaderConfig)this.cacheLoaderConfigs.get(0);
    }

    public boolean useChainingCacheLoader() {
        return !this.isPassivation() && this.cacheLoaderConfigs.size() > 1;
    }

    public String toString() {
        return new StringBuffer().append("CacheLoaderConfig{").append("shared=").append(this.shared).append(", passivation=").append(this.passivation).append(", preload='").append(this.preload).append('\'').append(", cacheLoaderConfigs.size()=").append(this.cacheLoaderConfigs.size()).append('}').toString();
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public boolean isShared() {
        return this.shared;
    }

    public static class IndividualCacheLoaderConfig {
        private String className;
        private boolean async;
        private boolean ignoreModifications;
        private boolean fetchPersistentState;
        private boolean purgeOnStartup;
        private Properties properties;

        public boolean isPurgeOnStartup() {
            return this.purgeOnStartup;
        }

        public boolean isFetchPersistentState() {
            return this.fetchPersistentState;
        }

        public void setFetchPersistentState(boolean fetchPersistentState) {
            this.fetchPersistentState = fetchPersistentState;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        public void setAsync(boolean async) {
            this.async = async;
        }

        public boolean isAsync() {
            return this.async;
        }

        public void setIgnoreModifications(boolean ignoreModifications) {
            this.ignoreModifications = ignoreModifications;
        }

        public boolean isIgnoreModifications() {
            return this.ignoreModifications;
        }

        public void setProperties(String properties) throws IOException {
            if (properties == null) {
                return;
            }
            properties = XmlHelper.escapeBackslashes(properties);
            ByteArrayInputStream is = new ByteArrayInputStream(properties.trim().getBytes("ISO8859_1"));
            this.properties = new Properties();
            this.properties.load(is);
            is.close();
        }

        public void setProperties(Properties properties) {
            this.properties = properties;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public String toString() {
            return new StringBuffer().append("IndividualCacheLoaderConfig{").append("className='").append(this.className).append('\'').append(", async=").append(this.async).append(", ignoreModifications=").append(this.ignoreModifications).append(", fetchPersistentState=").append(this.fetchPersistentState).append(", properties=").append(this.properties).append('}').toString();
        }

        public void setPurgeOnStartup(boolean purgeOnStartup) {
            this.purgeOnStartup = purgeOnStartup;
        }
    }
}

