/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.EvictedEventNode;
import org.jboss.cache.eviction.EvictionAlgorithm;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.EvictionPolicy;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.NodeEntry;
import org.jboss.cache.eviction.Region;
import org.jboss.cache.lock.TimeoutException;

public abstract class BaseEvictionAlgorithm
implements EvictionAlgorithm {
    private static final Log log = LogFactory.getLog(BaseEvictionAlgorithm.class);
    protected Region region;
    protected BoundedBuffer recycleQueue = new BoundedBuffer();
    protected EvictionQueue evictionQueue;

    protected abstract EvictionQueue setupEvictionQueue(Region var1) throws EvictionException;

    protected abstract boolean shouldEvictNode(NodeEntry var1);

    protected BaseEvictionAlgorithm() {
    }

    protected void initialize(Region region) throws EvictionException {
        this.region = region;
        this.evictionQueue = this.setupEvictionQueue(region);
    }

    public void process(Region region) throws EvictionException {
        if (this.region == null) {
            this.initialize(region);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("process(): region: " + region.getFqn()));
        }
        this.processQueues(region);
        this.emptyRecycleQueue();
        this.prune();
    }

    public void resetEvictionQueue(Region region) {
    }

    public EvictionQueue getEvictionQueue() {
        return this.evictionQueue;
    }

    protected void processQueues(Region region) throws EvictionException {
        EvictedEventNode node;
        int count = 0;
        while ((node = region.takeLastEventNode()) != null) {
            int eventType = node.getEvent();
            Fqn fqn = node.getFqn();
            ++count;
            switch (eventType) {
                case 0: {
                    this.processAddedNodes(fqn, node.getElementDifference(), node.isResetElementCount());
                    break;
                }
                case 1: {
                    this.processRemovedNodes(fqn);
                    break;
                }
                case 2: {
                    this.processVisitedNodes(fqn);
                    break;
                }
                case 3: {
                    this.processAddedElement(fqn);
                    break;
                }
                case 4: {
                    this.processRemovedElement(fqn);
                    break;
                }
                case 5: {
                    this.processMarkInUseNodes(fqn, node.getInUseTimeout());
                    break;
                }
                case 6: {
                    this.processUnmarkInUseNodes(fqn);
                    break;
                }
                default: {
                    throw new RuntimeException("Illegal Eviction Event type " + eventType);
                }
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("processed " + count + " node events in region: " + region.getFqn()));
        }
    }

    protected void evict(NodeEntry ne) {
        if (ne != null) {
            this.evictionQueue.removeNodeEntry(ne);
            if (!this.evictCacheNode(ne.getFqn())) {
                try {
                    this.recycleQueue.put((Object)ne.getFqn());
                }
                catch (InterruptedException e) {
                    log.debug((Object)"InterruptedException", (Throwable)e);
                }
            }
        }
    }

    protected boolean evictCacheNode(Fqn fqn) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Attempting to evict cache node with fqn of " + fqn));
        }
        EvictionPolicy policy = this.region.getEvictionPolicy();
        try {
            policy.evict(fqn);
        }
        catch (Exception e) {
            if (e instanceof TimeoutException) {
                log.warn((Object)("eviction of " + fqn + " timed out. Will retry later."));
                return false;
            }
            e.printStackTrace();
            return false;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Eviction of cache node with fqn of " + fqn + " successful"));
        }
        return true;
    }

    protected void processMarkInUseNodes(Fqn fqn, long inUseTimeout) throws EvictionException {
        NodeEntry ne;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Marking node " + fqn + " as in use with a usage timeout of " + inUseTimeout));
        }
        if ((ne = this.evictionQueue.getNodeEntry(fqn)) != null) {
            ne.setCurrentlyInUse(true, inUseTimeout);
        }
    }

    protected void processUnmarkInUseNodes(Fqn fqn) throws EvictionException {
        NodeEntry ne;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Unmarking node " + fqn + " as in use"));
        }
        if ((ne = this.evictionQueue.getNodeEntry(fqn)) != null) {
            ne.setCurrentlyInUse(false, 0L);
        }
    }

    protected void processAddedNodes(Fqn fqn, int numAddedElements, boolean resetElementCount) throws EvictionException {
        NodeEntry ne;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Adding node " + fqn + " with " + numAddedElements + " elements to eviction queue"));
        }
        if ((ne = this.evictionQueue.getNodeEntry(fqn)) != null) {
            ne.setModifiedTimeStamp(System.currentTimeMillis());
            ne.setNumberOfNodeVisits(ne.getNumberOfNodeVisits() + 1);
            if (resetElementCount) {
                ne.setNumberOfElements(numAddedElements);
            } else {
                ne.setNumberOfElements(ne.getNumberOfElements() + numAddedElements);
            }
            return;
        }
        long stamp = System.currentTimeMillis();
        ne = new NodeEntry(fqn);
        ne.setModifiedTimeStamp(stamp);
        ne.setNumberOfNodeVisits(1);
        ne.setNumberOfElements(numAddedElements);
        if (this.evictionQueue.containsNodeEntry(ne)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Queue already contains " + ne.getFqn() + " processing it as visited"));
            }
            this.processVisitedNodes(ne.getFqn());
            return;
        }
        this.evictionQueue.addNodeEntry(ne);
        if (log.isTraceEnabled()) {
            log.trace((Object)(ne.getFqn() + " added successfully to eviction queue"));
        }
    }

    protected void processRemovedNodes(Fqn fqn) throws EvictionException {
        NodeEntry ne;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Removing node " + fqn + " from eviction queue and attempting eviction"));
        }
        if ((ne = this.evictionQueue.getNodeEntry(fqn)) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("processRemoveNodes(): Can't find node associated with fqn: " + fqn + "Could have been evicted earlier. Will just continue."));
            }
            return;
        }
        this.evictionQueue.removeNodeEntry(ne);
        if (log.isTraceEnabled()) {
            log.trace((Object)(fqn + " removed from eviction queue"));
        }
    }

    protected void processVisitedNodes(Fqn fqn) throws EvictionException {
        NodeEntry ne = this.evictionQueue.getNodeEntry(fqn);
        if (ne == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Visiting node that was not added to eviction queues. Assuming that it has 1 element.");
            }
            this.processAddedNodes(fqn, 1, false);
            return;
        }
        ne.setNumberOfNodeVisits(ne.getNumberOfNodeVisits() + 1);
        ne.setModifiedTimeStamp(System.currentTimeMillis());
    }

    protected void processRemovedElement(Fqn fqn) throws EvictionException {
        NodeEntry ne = this.evictionQueue.getNodeEntry(fqn);
        if (ne == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing element from " + fqn + " but eviction queue does not contain this node. " + "Ignoring removeElement event."));
            }
            return;
        }
        ne.setNumberOfElements(ne.getNumberOfElements() - 1);
        ne.setNumberOfNodeVisits(ne.getNumberOfNodeVisits() + 1);
        ne.setModifiedTimeStamp(System.currentTimeMillis());
    }

    protected void processAddedElement(Fqn fqn) throws EvictionException {
        NodeEntry ne = this.evictionQueue.getNodeEntry(fqn);
        if (ne == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding element " + fqn + " for a node that doesn't exist yet. Process as an add."));
            }
            this.processAddedNodes(fqn, 1, false);
            return;
        }
        ne.setNumberOfElements(ne.getNumberOfElements() + 1);
        ne.setNumberOfNodeVisits(ne.getNumberOfNodeVisits() + 1);
        ne.setModifiedTimeStamp(System.currentTimeMillis());
    }

    protected void emptyRecycleQueue() throws EvictionException {
        block7: {
            Fqn fqn;
            do {
                try {
                    fqn = (Fqn)this.recycleQueue.poll(0L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    break block7;
                }
                if (fqn == null) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Recycle queue is empty");
                    }
                    break block7;
                }
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("emptying recycle bin. Evict node " + fqn));
            } while (this.evictCacheNode(fqn));
            try {
                this.recycleQueue.put((Object)fqn);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean isNodeInUseAndNotTimedOut(NodeEntry ne) {
        if (ne.isCurrentlyInUse()) {
            if (ne.getInUseTimeoutTimestamp() == 0L) {
                return true;
            }
            if (System.currentTimeMillis() < ne.getInUseTimeoutTimestamp()) {
                return true;
            }
        }
        return false;
    }

    protected void prune() throws EvictionException {
        NodeEntry entry;
        while ((entry = this.evictionQueue.getFirstNodeEntry()) != null) {
            if (!this.shouldEvictNode(entry)) break;
            this.evict(entry);
        }
    }
}

