/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.ConfigureException;
import org.jboss.cache.eviction.EvictionConfiguration;
import org.jboss.cache.xml.XmlHelper;
import org.w3c.dom.Element;

public class ElementSizeConfiguration
implements EvictionConfiguration {
    private static final Log log = LogFactory.getLog(ElementSizeConfiguration.class);
    private int maxElementsPerNode;
    private int maxNodes;

    public int getMaxElementsPerNode() {
        return this.maxElementsPerNode;
    }

    public void setMaxElementsPerNode(int maxElementsPerNode) {
        this.maxElementsPerNode = maxElementsPerNode;
    }

    public int getMaxNodes() {
        return this.maxNodes;
    }

    public void setMaxNodes(int maxNodes) {
        this.maxNodes = maxNodes;
    }

    public void parseXMLConfig(Element element) throws ConfigureException {
        String name = element.getAttribute("name");
        if (name == null || name.equals("")) {
            throw new ConfigureException("Name is required for the eviction region");
        }
        String maxNodes = XmlHelper.getAttr(element, "maxNodes", "attribute", "name");
        if (maxNodes != null && !maxNodes.equals("")) {
            this.setMaxNodes(Integer.parseInt(maxNodes));
        } else {
            this.setMaxNodes(0);
        }
        String maxElementsPerNode = XmlHelper.getAttr(element, "maxElementsPerNode", "attribute", "name");
        if (maxElementsPerNode == null) {
            throw new ConfigureException("ElementSizeConfiguration.parseXMLConfig(): Null maxElementsPerNode element");
        }
        this.setMaxElementsPerNode(Integer.parseInt(maxElementsPerNode));
        if (log.isDebugEnabled()) {
            log.debug((Object)("parseConfig: name -- " + name + " maxNodes -- " + this.getMaxNodes() + " maxElementsPerNode -- " + this.getMaxElementsPerNode()));
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("ElementSizeConfiguration: maxElementsPerNode =");
        str.append(this.getMaxElementsPerNode()).append(" maxNodes =").append(this.getMaxNodes());
        return str.toString();
    }
}

