/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.eviction.EvictionAlgorithm;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.EvictionPolicy;
import org.jboss.cache.eviction.Region;

public class EvictionTimerTask
extends TimerTask {
    private Log log = LogFactory.getLog(EvictionTimerTask.class);
    private final Set processedRegions = Collections.synchronizedSet(new HashSet());

    public void addRegionToProcess(Region region) {
        this.processedRegions.add(region);
    }

    public void removeRegionToProcess(Region region) {
        this.processedRegions.remove(region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Set set = this.processedRegions;
        synchronized (set) {
            for (Region region : this.processedRegions) {
                EvictionPolicy policy = region.getEvictionPolicy();
                Region region2 = region;
                synchronized (region2) {
                    EvictionAlgorithm algo = policy.getEvictionAlgorithm();
                    try {
                        algo.process(region);
                    }
                    catch (EvictionException e) {
                        this.log.error((Object)("run(): error processing eviction with exception: " + e.toString() + " will reset the eviction queue list."));
                        region.resetEvictionQueues();
                        this.log.debug((Object)"trace", (Throwable)e);
                    }
                }
            }
        }
    }
}

