/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.ConfigureException;
import org.jboss.cache.eviction.EvictionConfiguration;
import org.jboss.cache.xml.XmlHelper;
import org.w3c.dom.Element;

public class FIFOConfiguration
implements EvictionConfiguration {
    private static final Log log = LogFactory.getLog(FIFOConfiguration.class);
    private int maxNodes;

    public int getMaxNodes() {
        return this.maxNodes;
    }

    public void setMaxNodes(int maxNodes) {
        this.maxNodes = maxNodes;
    }

    public void parseXMLConfig(Element element) throws ConfigureException {
        String name = element.getAttribute("name");
        if (name == null || name.equals("")) {
            throw new ConfigureException("Name is required for the eviction region");
        }
        String maxNodes = XmlHelper.getAttr(element, "maxNodes", "attribute", "name");
        if (maxNodes == null || maxNodes.equals("")) {
            throw new ConfigureException("FIFOConfiguration requires maxNodes attribute");
        }
        this.setMaxNodes(Integer.parseInt(maxNodes));
        if (log.isDebugEnabled()) {
            log.debug((Object)("parseConfig: name -- " + name + " maxNodes -- " + this.getMaxNodes()));
        }
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("LFUConfiguration: maxNodes = ").append(this.getMaxNodes());
        return ret.toString();
    }
}

