/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.ConfigureException;
import org.jboss.cache.eviction.EvictionConfiguration;
import org.jboss.cache.xml.XmlHelper;
import org.w3c.dom.Element;

public class LFUConfiguration
implements EvictionConfiguration {
    private static final Log log = LogFactory.getLog(LFUConfiguration.class);
    private int minNodes;
    private int maxNodes;

    public int getMinNodes() {
        return this.minNodes;
    }

    public void setMinNodes(int minNodes) {
        this.minNodes = minNodes;
    }

    public int getMaxNodes() {
        return this.maxNodes;
    }

    public void setMaxNodes(int maxNodes) {
        this.maxNodes = maxNodes;
    }

    public void parseXMLConfig(Element element) throws ConfigureException {
        String name = element.getAttribute("name");
        if (name == null || name.equals("")) {
            throw new ConfigureException("Name is required for the eviction region");
        }
        String maxNodes = XmlHelper.getAttr(element, "maxNodes", "attribute", "name");
        if (maxNodes != null) {
            this.setMaxNodes(Integer.parseInt(maxNodes));
        } else {
            this.setMaxNodes(0);
        }
        String minNodes = XmlHelper.getAttr(element, "minNodes", "attribute", "name");
        if (minNodes != null) {
            this.setMinNodes(Integer.parseInt(minNodes));
        } else {
            this.setMinNodes(0);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("parseConfig: name -- " + name + " maxNodes -- " + this.getMaxNodes() + " minNodes -- " + this.getMinNodes()));
        }
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("LFUConfiguration: maxNodes = ").append(this.getMaxNodes()).append(" minNodes = ").append(this.getMinNodes());
        return ret.toString();
    }
}

