/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.NodeEntry;
import org.jboss.cache.eviction.SortedEvictionQueue;

public class LFUQueue
implements SortedEvictionQueue {
    private Map nodeMap = new HashMap();
    private LinkedList evictionList;
    private Comparator comparator = new LFUComparator();
    private Set removalQueue;
    private int numElements = 0;

    LFUQueue() {
        this.evictionList = new LinkedList();
        this.removalQueue = new HashSet();
    }

    public NodeEntry getFirstNodeEntry() {
        try {
            NodeEntry ne;
            while ((ne = (NodeEntry)this.evictionList.getFirst()) != null) {
                if (!this.removalQueue.contains(ne)) break;
                this.evictionList.removeFirst();
                this.removalQueue.remove(ne);
            }
            return ne;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public NodeEntry getNodeEntry(Fqn fqn) {
        return (NodeEntry)this.nodeMap.get(fqn);
    }

    public NodeEntry getNodeEntry(String fqn) {
        return this.getNodeEntry(Fqn.fromString(fqn));
    }

    public boolean containsNodeEntry(NodeEntry entry) {
        Fqn fqn = entry.getFqn();
        return this.getNodeEntry(fqn) != null;
    }

    public void removeNodeEntry(NodeEntry entry) {
        NodeEntry ne = (NodeEntry)this.nodeMap.remove(entry.getFqn());
        if (ne != null) {
            this.removalQueue.add(ne);
            this.numElements -= ne.getNumberOfElements();
        }
    }

    public void addNodeEntry(NodeEntry entry) {
        if (!this.containsNodeEntry(entry)) {
            Fqn fqn = entry.getFqn();
            entry.queue = this;
            this.nodeMap.put(fqn, entry);
            this.evictionList.add(entry);
            this.numElements += entry.getNumberOfElements();
        }
    }

    public int getNumberOfNodes() {
        return this.nodeMap.size();
    }

    public int getNumberOfElements() {
        return this.numElements;
    }

    public void clear() {
        this.nodeMap.clear();
        this.evictionList.clear();
        this.removalQueue.clear();
        this.numElements = 0;
    }

    public void resortEvictionQueue() {
        Collections.sort(this.evictionList, this.comparator);
    }

    public void modifyElementCount(int difference) {
        this.numElements += difference;
    }

    void prune() {
        Iterator it = this.iterate();
        while (it.hasNext() && this.removalQueue.size() > 0) {
            if (!this.removalQueue.remove(it.next())) continue;
            it.remove();
        }
    }

    final List getEvictionList() {
        return this.evictionList;
    }

    final Set getRemovalQueue() {
        return this.removalQueue;
    }

    public Iterator iterate() {
        return this.evictionList.iterator();
    }

    static class LFUComparator
    implements Comparator {
        LFUComparator() {
        }

        public int compare(Object o, Object o1) {
            int ne2NodeHits;
            if (o.equals(o1)) {
                return 0;
            }
            NodeEntry ne = (NodeEntry)o;
            NodeEntry ne2 = (NodeEntry)o1;
            int neNodeHits = ne.getNumberOfNodeVisits();
            if (neNodeHits > (ne2NodeHits = ne2.getNumberOfNodeVisits())) {
                return 1;
            }
            if (neNodeHits < ne2NodeHits) {
                return -1;
            }
            if (neNodeHits == ne2NodeHits) {
                return 0;
            }
            throw new RuntimeException("Should never reach this condition");
        }
    }
}

