/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import EDU.oswego.cs.dl.util.concurrent.BoundedLinkedQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.EvictedEventNode;
import org.jboss.cache.eviction.EvictionConfiguration;
import org.jboss.cache.eviction.EvictionPolicy;
import org.jboss.cache.eviction.LRUConfiguration;

public class Region {
    private Fqn fqn_;
    private EvictionPolicy policy_;
    private EvictionConfiguration configuration_;
    protected BoundedLinkedQueue nodeEventQueue_;
    protected Log log_ = LogFactory.getLog(Region.class);
    protected int checkCapacityCount = 0;
    private static final int CAPACITY_WARN_THRESHOLD = 195900;

    Region() {
        this.createQueue();
    }

    void createQueue() {
        this.nodeEventQueue_ = new BoundedLinkedQueue(200000);
    }

    Region(String fqn, EvictionPolicy policy, EvictionConfiguration config) {
        this(Fqn.fromString(fqn), policy, config);
    }

    Region(Fqn fqn, EvictionPolicy policy, EvictionConfiguration config) {
        this.fqn_ = fqn;
        this.policy_ = policy;
        this.configuration_ = config;
        this.createQueue();
    }

    public EvictionConfiguration getEvictionConfiguration() {
        return this.configuration_;
    }

    public void setEvictionConfiguration(EvictionConfiguration configuration) {
        this.configuration_ = configuration;
    }

    public EvictionPolicy getEvictionPolicy() {
        return this.policy_;
    }

    public String getFqn() {
        return String.valueOf(this.fqn_.toString()) + "/";
    }

    public Fqn getFqnObject() {
        return this.fqn_;
    }

    public void setAddedNode(Fqn fqn) {
        this.putNodeEvent(fqn, 0);
    }

    public void setRemovedNode(Fqn fqn) {
        this.putNodeEvent(fqn, 1);
    }

    public void setVisitedNode(Fqn fqn) {
        this.putNodeEvent(fqn, 2);
    }

    public void putNodeEvent(Fqn fqn, int event) {
        this.putNodeEvent(new EvictedEventNode(fqn, event));
    }

    public void putNodeEvent(EvictedEventNode event) {
        try {
            if (++this.checkCapacityCount > 100) {
                this.checkCapacityCount = 0;
                if (this.nodeEventQueue_.size() > 195900) {
                    this.log_.warn((Object)"putNodeEvent(): eviction node event queue size is at 98% threshold value of capacity: 200000 You will need to reduce the wakeUpIntervalSeconds parameter.");
                }
            }
            this.nodeEventQueue_.put((Object)event);
        }
        catch (InterruptedException e) {
            this.log_.debug((Object)"give up put", (Throwable)e);
        }
    }

    public EvictedEventNode takeLastEventNode() {
        try {
            return (EvictedEventNode)this.nodeEventQueue_.poll(0L);
        }
        catch (InterruptedException e) {
            this.log_.debug((Object)"trace", (Throwable)e);
            return null;
        }
    }

    public int nodeEventQueueSize() {
        return this.nodeEventQueue_.size();
    }

    public void resetEvictionQueues() {
        BoundedLinkedQueue q1 = this.nodeEventQueue_;
        this.log_.info((Object)("reseteEvictionQueues(): node queue size: " + q1.size() + " region name: " + this.fqn_));
        this.createQueue();
        int i = 0;
        while (i < q1.size()) {
            try {
                q1.take();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Region region = (Region)o;
        return this.fqn_.equals(region.fqn_);
    }

    public int hashCode() {
        return this.fqn_.hashCode();
    }

    public void setTimeToLiveSeconds(long timeToLive) {
        if (!(this.getEvictionConfiguration() instanceof LRUConfiguration)) {
            throw new RuntimeException("Incorrect usage of a deprecated API!!!!");
        }
        int ttl = new Long(timeToLive).intValue();
        ((LRUConfiguration)this.getEvictionConfiguration()).setTimeToLiveSeconds(ttl);
    }

    public void setMaxNodes(int maxSize) {
        if (!(this.getEvictionConfiguration() instanceof LRUConfiguration)) {
            throw new RuntimeException("Incorrect usage of a deprecated API!!!!");
        }
        ((LRUConfiguration)this.getEvictionConfiguration()).setMaxNodes(maxSize);
    }
}

