/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.TransactionManager;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.Modification;
import org.jboss.cache.TransactionEntry;
import org.jboss.cache.TransactionTable;
import org.jboss.cache.interceptors.ActivationInterceptorMBean;
import org.jboss.cache.interceptors.CacheLoaderInterceptor;
import org.jboss.cache.marshall.JBCMethodCall;
import org.jgroups.blocks.MethodCall;

public class ActivationInterceptor
extends CacheLoaderInterceptor
implements ActivationInterceptorMBean {
    protected TransactionManager tx_mgr = null;
    protected TransactionTable tx_table = null;
    private HashMap m_txActivations = new HashMap();
    private long m_activations = 0L;
    protected ConcurrentHashMap transactions = new ConcurrentHashMap(16);
    protected static final Object NULL = new Object();

    public ActivationInterceptor() {
        this.useCacheStore = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodCall call) throws Throwable {
        JBCMethodCall m = (JBCMethodCall)call;
        Fqn fqn = null;
        Method meth = m.getMethod();
        Object[] args = m.getArgs();
        Object retval = null;
        retval = super.invoke(m);
        boolean nodeRemoved = false;
        if (this.tx_mgr != null && this.tx_mgr.getTransaction() != null) {
            GlobalTransaction gtx = this.getInvocationContext().getGlobalTransaction();
            switch (m.getMethodId()) {
                case 11: {
                    if (!this.hasModifications(args)) break;
                    this.loader.commit(gtx);
                    if (!this.cache.getUseInterceptorMbeans() || !this.statsEnabled) break;
                    Integer acts = (Integer)this.m_txActivations.get(gtx);
                    if (acts != null) {
                        this.m_activations += (long)acts.intValue();
                    }
                    this.m_txActivations.remove(gtx);
                    break;
                }
                case 12: {
                    if (!this.hasModifications(args)) break;
                    this.loader.rollback(gtx);
                    if (!this.cache.getUseInterceptorMbeans() || !this.statsEnabled) break;
                    this.m_txActivations.remove(gtx);
                    break;
                }
                case 10: 
                case 18: {
                    this.prepareCacheLoader(gtx);
                }
            }
        }
        switch (m.getMethodId()) {
            case 1: 
            case 2: 
            case 3: {
                fqn = (Fqn)args[1];
                break;
            }
            case 6: 
            case 7: {
                fqn = (Fqn)args[1];
                break;
            }
            case 15: {
                fqn = (Fqn)args[1];
                break;
            }
            case 26: {
                fqn = (Fqn)args[0];
                break;
            }
            case 31: {
                fqn = (Fqn)args[0];
                break;
            }
            case 25: {
                fqn = (Fqn)args[0];
                break;
            }
            case 17: 
            case 23: 
            case 32: {
                fqn = (Fqn)args[0];
                break;
            }
            case 5: {
                nodeRemoved = true;
                fqn = (Fqn)args[1];
            }
        }
        ActivationInterceptor activationInterceptor = this;
        synchronized (activationInterceptor) {
            DataNode n;
            if (fqn != null && nodeRemoved) {
                this.loader.remove(fqn);
            } else if (fqn != null && this.cache.exists(fqn) && this.loader.exists(fqn) && (n = this.getNode(fqn)) != null && !n.containsKey("jboss:internal:uninitialized")) {
                if (n.hasChildren()) {
                    if (this.allInitialized(n)) {
                        this.log.debug((Object)"children all initialized");
                        this.remove(fqn);
                    }
                } else if (this.loaderNoChildren(fqn)) {
                    this.log.debug((Object)("no children " + n));
                    this.remove(fqn);
                }
            }
        }
        return retval;
    }

    private void remove(Fqn fqn) throws Exception {
        this.loader.remove(fqn);
        this.cache.notifyNodeActivate(fqn, false);
        if (this.cache.getUseInterceptorMbeans() && this.statsEnabled) {
            ++this.m_activations;
        }
    }

    private boolean allInitialized(DataNode n) {
        if (!n.getChildrenLoaded()) {
            return false;
        }
        for (DataNode child : n.getChildren().values()) {
            if (!child.containsKey("jboss:internal:uninitialized")) continue;
            return false;
        }
        return true;
    }

    private boolean loaderNoChildren(Fqn fqn) {
        try {
            Set children_names = this.loader.getChildrenNames(fqn);
            return children_names == null;
        }
        catch (Exception e) {
            this.log.error((Object)("failed getting the children names for " + fqn + " from the cache loader"), (Throwable)e);
            return false;
        }
    }

    public long getActivations() {
        return this.m_activations;
    }

    public void resetStatistics() {
        super.resetStatistics();
        this.m_activations = 0L;
    }

    public Map dumpStatistics() {
        HashMap<String, Long> retval = super.dumpStatistics();
        if (retval == null) {
            retval = new HashMap<String, Long>();
        }
        retval.put("Activations", new Long(this.m_activations));
        return retval;
    }

    protected boolean hasModifications(Object[] args) {
        int hint = 1;
        if (args[hint] instanceof Boolean) {
            return (Boolean)args[hint];
        }
        int i = 0;
        while (i < args.length) {
            if (args[i] instanceof Boolean) {
                return (Boolean)args[i];
            }
            ++i;
        }
        return false;
    }

    private void prepareCacheLoader(GlobalTransaction gtx) throws Exception {
        int txActs = 0;
        TransactionEntry entry = this.tx_table.get(gtx);
        if (entry == null) {
            throw new Exception("entry for transaction " + gtx + " not found in transaction table");
        }
        List modifications = entry.getCacheLoaderModifications();
        if (modifications.size() == 0) {
            return;
        }
        ArrayList<Modification> cache_loader_modifications = new ArrayList<Modification>();
        block4: for (JBCMethodCall methodCall : modifications) {
            Method method = methodCall.getMethod();
            if (method == null) {
                throw new Exception("method call has no method: " + (Object)((Object)methodCall));
            }
            Object[] args = methodCall.getArgs();
            switch (methodCall.getMethodId()) {
                case 5: {
                    Modification mod = new Modification(4, (Fqn)args[1]);
                    cache_loader_modifications.add(mod);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    DataNode n;
                    Fqn fqn = (Fqn)args[1];
                    if (fqn == null || !this.cache.exists(fqn) || !this.loader.exists(fqn) || (n = this.getNode(fqn)) == null || n.containsKey("jboss:internal:uninitialized")) continue block4;
                    if (n.hasChildren() && this.allInitialized(n)) {
                        this.addRemoveMod(cache_loader_modifications, fqn);
                        ++txActs;
                        break;
                    }
                    if (!this.loaderNoChildren(fqn)) break;
                    this.addRemoveMod(cache_loader_modifications, fqn);
                    ++txActs;
                }
            }
        }
        if (cache_loader_modifications.size() > 0) {
            this.loader.prepare(gtx, cache_loader_modifications, false);
            if (this.cache.getUseInterceptorMbeans() && this.statsEnabled && txActs > 0) {
                this.m_txActivations.put(gtx, new Integer(txActs));
            }
        }
    }

    private void addRemoveMod(List l, Fqn fqn) {
        Modification mod = new Modification(4, fqn);
        l.add(mod);
        this.cache.notifyNodeActivate(fqn, false);
    }
}

