/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.List;
import org.jboss.cache.TreeCache;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.marshall.JBCMethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jgroups.blocks.MethodCall;

public abstract class BaseRpcInterceptor
extends Interceptor {
    private BuddyManager buddyManager;
    private boolean usingBuddyReplication;

    public void setCache(TreeCache cache) {
        this.cache = cache;
        this.buddyManager = cache.getBuddyManager();
        this.usingBuddyReplication = this.buddyManager != null;
    }

    protected void checkResponses(List rsps) throws Throwable {
        if (rsps != null) {
            for (Object rsp : rsps) {
                if (rsp == null || !(rsp instanceof Throwable)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Received Throwable from remote node", (Throwable)rsp);
                }
                throw (Throwable)rsp;
            }
        }
    }

    protected void replicateCall(JBCMethodCall call, boolean sync) throws Throwable {
        this.replicateCall(null, call, sync);
    }

    protected void replicateCall(List recipients, JBCMethodCall call, boolean sync) throws Throwable {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Broadcasting call " + (Object)((Object)call) + " to recipient list " + recipients));
        }
        if (!sync && this.cache.getUseReplQueue() && this.cache.getReplQueue() != null && !this.usingBuddyReplication) {
            this.putCallOnAsyncReplicationQueue(call);
        } else {
            List callRecipients;
            if (this.usingBuddyReplication) {
                call = this.buddyManager.transformFqns(call);
            }
            if ((callRecipients = recipients) == null) {
                callRecipients = this.usingBuddyReplication ? this.buddyManager.getBuddyAddresses() : this.cache.getMembers();
            }
            List rsps = this.cache.callRemoteMethods(callRecipients, MethodDeclarations.replicateMethod, new Object[]{call}, sync, true, this.cache.getSyncReplTimeout());
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("responses=" + rsps));
            }
            if (sync) {
                this.checkResponses(rsps);
            }
        }
    }

    protected void putCallOnAsyncReplicationQueue(MethodCall call) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Putting call " + call + " on the replication queue."));
        }
        this.cache.getReplQueue().add(MethodCallFactory.create(MethodDeclarations.replicateMethod, new Object[]{call}));
    }

    protected boolean containsModifications(JBCMethodCall m) {
        switch (m.getMethodId()) {
            case 10: 
            case 18: {
                List mods = (List)m.getArgs()[1];
                return mods.size() > 0;
            }
            case 11: 
            case 12: {
                return this.getInvocationContext().isTxHasMods();
            }
        }
        return false;
    }
}

