/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.HashSet;
import java.util.Set;
import javax.transaction.Transaction;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.TreeCache;
import org.jboss.cache.config.Option;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jgroups.blocks.MethodCall;

public class CallInterceptor
extends Interceptor {
    private static Set transactionLifecycleMethods = new HashSet();

    static {
        transactionLifecycleMethods.add(MethodDeclarations.commitMethod);
        transactionLifecycleMethods.add(MethodDeclarations.rollbackMethod);
        transactionLifecycleMethods.add(MethodDeclarations.prepareMethod);
        transactionLifecycleMethods.add(MethodDeclarations.optimisticPrepareMethod);
    }

    public void setCache(TreeCache cache) {
        super.setCache(cache);
    }

    public Object invoke(MethodCall m) throws Throwable {
        InvocationContext ctx;
        Transaction tx;
        Object retval = null;
        if (!transactionLifecycleMethods.contains(m.getMethod())) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Invoking method " + m + " on cache."));
            }
            try {
                retval = m.invoke((Object)this.cache);
            }
            catch (Throwable t) {
                retval = t;
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Suppressing invocation of method " + m + " on cache."));
        }
        if ((tx = (ctx = this.getInvocationContext()).getTransaction()) != null && this.isValid(tx)) {
            if (retval instanceof Throwable) {
                tx.setRollbackOnly();
            } else if (!this.cache.isNodeLockingOptimistic() && MethodDeclarations.isCrudMethod(m.getMethod())) {
                GlobalTransaction gtx = ctx.getGlobalTransaction();
                if (gtx == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("didn't find GlobalTransaction for " + tx + "; won't add modification to transaction list"));
                    }
                } else {
                    Option o = this.getInvocationContext().getOptionOverrides();
                    if (o != null && o.isCacheModeLocal()) {
                        this.log.debug((Object)"Not adding method to modification list since cache mode local is set.");
                    } else {
                        this.cache.getTransactionTable().addModification(gtx, m);
                    }
                    if (this.cache.getCacheLoaderManager() != null) {
                        this.cache.getTransactionTable().addCacheLoaderModification(gtx, m);
                    }
                }
            }
        }
        if (retval instanceof Throwable) {
            throw (Throwable)retval;
        }
        return retval;
    }
}

