/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrderedSynchronizationHandler
implements Synchronization {
    Transaction tx = null;
    LinkedList handlers = new LinkedList();
    static Map instances = new HashMap();
    static Log log = LogFactory.getLog(OrderedSynchronizationHandler.class);

    private OrderedSynchronizationHandler(Transaction tx) {
        this.tx = tx;
    }

    public static OrderedSynchronizationHandler getInstance(Transaction tx) throws SystemException, RollbackException {
        OrderedSynchronizationHandler retval = (OrderedSynchronizationHandler)instances.get(tx);
        if (retval != null) {
            return retval;
        }
        retval = new OrderedSynchronizationHandler(tx);
        tx.registerSynchronization((Synchronization)retval);
        instances.put(tx, retval);
        return retval;
    }

    public void registerAtHead(Synchronization handler) {
        this.register(handler, true);
    }

    public void registerAtTail(Synchronization handler) {
        this.register(handler, false);
    }

    void register(Synchronization handler, boolean head) {
        if (handler != null && !this.handlers.contains(handler)) {
            if (head) {
                this.handlers.addFirst(handler);
            } else {
                this.handlers.addLast(handler);
            }
        }
    }

    public void beforeCompletion() {
        for (Synchronization sync : this.handlers) {
            sync.beforeCompletion();
        }
    }

    public void afterCompletion(int status) {
        for (Synchronization sync : this.handlers) {
            try {
                sync.afterCompletion(status);
            }
            catch (Throwable t) {
                log.error((Object)("failed calling afterCompletion() on " + sync), t);
            }
        }
        instances.remove(this.tx);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("tx=" + this.tx + ", handlers=" + this.handlers);
        return sb.toString();
    }
}

