/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.lang.reflect.Method;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.config.Option;
import org.jboss.cache.interceptors.BaseRpcInterceptor;
import org.jboss.cache.marshall.JBCMethodCall;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jgroups.blocks.MethodCall;

public class ReplicationInterceptor
extends BaseRpcInterceptor {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invoke(MethodCall call) throws Throwable {
        JBCMethodCall m = (JBCMethodCall)call;
        InvocationContext ctx = this.getInvocationContext();
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        boolean isLocalCommitOrRollback = gtx != null && !gtx.isRemote() && (m.getMethodId() == 11 || m.getMethodId() == 12);
        Object o = isLocalCommitOrRollback ? null : super.invoke(m);
        Option optionOverride = ctx.getOptionOverrides();
        if (optionOverride != null && optionOverride.isCacheModeLocal() && ctx.getTransaction() == null) {
            this.log.trace((Object)"skip replication");
            return isLocalCommitOrRollback ? super.invoke(m) : o;
        }
        Method method = m.getMethod();
        if (ctx.getTransaction() != null) {
            if (gtx == null) return o;
            if (gtx.isRemote()) return o;
            switch (m.getMethodId()) {
                case 11: {
                    if (!this.containsModifications(m)) return super.invoke(m);
                    this.replicateCall(m, this.cache.getSyncCommitPhase());
                    return super.invoke(m);
                }
                case 10: {
                    if (!this.containsModifications(m)) return o;
                    this.runPreparePhase(m, gtx);
                    return o;
                }
                case 12: {
                    if (this.containsModifications(m) && !ctx.isLocalRollbackOnly()) {
                        this.replicateCall(m, this.cache.getSyncRollbackPhase());
                    }
                    o = super.invoke(m);
                }
                default: {
                    return o;
                }
            }
        } else if (MethodDeclarations.isCrudMethod(method)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Non-tx crud meth");
            }
            if (!ctx.isOriginLocal()) return o;
            this.handleReplicatedMethod(m, this.cache.getCacheModeInternal());
            return o;
        } else {
            if (!this.log.isTraceEnabled()) return o;
            this.log.trace((Object)"Non-tx and non crud meth");
        }
        return o;
    }

    void handleReplicatedMethod(JBCMethodCall m, int mode) throws Throwable {
        if (mode == 3 && m.getMethodId() == 4) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"forcing asynchronous replication for putFailFast()");
            }
            mode = 2;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("invoking method " + (Object)((Object)m) + ", members=" + this.cache.getMembers() + ", mode=" + this.cache.getCacheMode() + ", exclude_self=" + true + ", timeout=" + this.cache.getSyncReplTimeout()));
        }
        switch (mode) {
            case 2: {
                this.replicateCall(m, false);
                break;
            }
            case 3: {
                this.replicateCall(m, true);
            }
        }
    }

    protected void runPreparePhase(JBCMethodCall prepareMethod, GlobalTransaction gtx) throws Throwable {
        boolean async;
        boolean bl = async = this.cache.getCacheModeInternal() == 2;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("(" + this.cache.getLocalAddress() + "): running remote prepare for global tx " + gtx + " with async mode=" + async));
        }
        this.replicateCall(prepareMethod, !async);
    }
}

