/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheException;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.OptimisticTransactionEntry;
import org.jboss.cache.ReplicationException;
import org.jboss.cache.TransactionEntry;
import org.jboss.cache.TransactionTable;
import org.jboss.cache.TreeCache;
import org.jboss.cache.config.Option;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.interceptors.OrderedSynchronizationHandler;
import org.jboss.cache.interceptors.TxInterceptorMBean;
import org.jboss.cache.marshall.JBCMethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jgroups.Address;
import org.jgroups.blocks.MethodCall;

public class TxInterceptor
extends Interceptor
implements TxInterceptorMBean {
    private Map transactions = new ConcurrentHashMap(16);
    private Map rollbackTransactions = new ConcurrentHashMap(16);
    private long m_prepares = 0L;
    private long m_commits = 0L;
    private long m_rollbacks = 0L;
    static final Object NULL = new Object();
    protected TransactionManager txManager = null;
    protected TransactionTable txTable = null;
    private Map remoteTransactions = new ConcurrentHashMap();

    public void setCache(TreeCache cache) {
        super.setCache(cache);
        this.txManager = cache.getTransactionManager();
        this.txTable = cache.getTransactionTable();
    }

    public Object invoke(MethodCall call) throws Throwable {
        Object result;
        block28: {
            boolean resumeSuspended;
            Transaction suspendedTransaction;
            JBCMethodCall m = (JBCMethodCall)call;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("(" + this.cache.getLocalAddress() + ") call on method [" + (Object)((Object)m) + "]"));
            }
            if (this.isBuddyGroupOrganisationMethod(m)) {
                return super.invoke(m);
            }
            InvocationContext ctx = this.getInvocationContext();
            boolean scrubTxsOnExit = false;
            Option optionOverride = ctx.getOptionOverrides();
            ctx.setTransaction(this.txManager == null ? null : this.txManager.getTransaction());
            if (optionOverride != null && optionOverride.isFailSilently() && ctx.getTransaction() != null) {
                suspendedTransaction = this.txManager.suspend();
                resumeSuspended = true;
            } else {
                suspendedTransaction = null;
                resumeSuspended = false;
            }
            result = null;
            try {
                try {
                    if (this.isTransactionLifecycleMethod(m)) {
                        ctx.setGlobalTransaction(this.findGlobalTransaction(m.getArgs()));
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Got gtx from method call " + ctx.getGlobalTransaction()));
                        }
                        ctx.getGlobalTransaction().setRemote(this.isRemoteGlobalTx(ctx.getGlobalTransaction()));
                        if (ctx.getGlobalTransaction().isRemote()) {
                            this.remoteTransactions.put(ctx.getGlobalTransaction(), NULL);
                        }
                        switch (m.getMethodId()) {
                            case 10: 
                            case 18: {
                                if (ctx.getGlobalTransaction().isRemote()) {
                                    result = this.handleRemotePrepare(m, ctx.getGlobalTransaction());
                                    scrubTxsOnExit = true;
                                    if (this.cache.getUseInterceptorMbeans() && this.statsEnabled) {
                                        ++this.m_prepares;
                                        break;
                                    }
                                    break block28;
                                }
                                if (this.log.isTraceEnabled()) {
                                    this.log.trace((Object)"received my own message (discarding it)");
                                }
                                result = null;
                                break;
                            }
                            case 11: 
                            case 12: {
                                if (ctx.getGlobalTransaction().isRemote()) {
                                    result = this.handleRemoteCommitRollback(m, ctx.getGlobalTransaction());
                                    scrubTxsOnExit = true;
                                    break;
                                }
                                if (this.log.isTraceEnabled()) {
                                    this.log.trace((Object)"received my own message (discarding it)");
                                }
                                result = null;
                            }
                        }
                        break block28;
                    }
                    result = this.handleNonTxMethod(m);
                }
                catch (Exception e) {
                    this.log.info((Object)"There was a problem handling this request", (Throwable)e);
                    if (optionOverride == null || !optionOverride.isFailSilently()) {
                        throw e;
                    }
                    if (resumeSuspended) {
                        this.txManager.resume(suspendedTransaction);
                    } else if (ctx.getTransaction() != null && this.isValid(ctx.getTransaction())) {
                        this.copyInvocationScopeOptionsToTxScope(ctx);
                    }
                    this.scrubInvocationCtx(scrubTxsOnExit);
                }
            }
            finally {
                if (resumeSuspended) {
                    this.txManager.resume(suspendedTransaction);
                } else if (ctx.getTransaction() != null && this.isValid(ctx.getTransaction())) {
                    this.copyInvocationScopeOptionsToTxScope(ctx);
                }
                this.scrubInvocationCtx(scrubTxsOnExit);
            }
        }
        return result;
    }

    public long getPrepares() {
        return this.m_prepares;
    }

    public long getCommits() {
        return this.m_commits;
    }

    public long getRollbacks() {
        return this.m_rollbacks;
    }

    public void resetStatistics() {
        this.m_prepares = 0L;
        this.m_commits = 0L;
        this.m_rollbacks = 0L;
    }

    public Map dumpStatistics() {
        HashMap<String, Long> retval = new HashMap<String, Long>(3);
        retval.put("Prepares", new Long(this.m_prepares));
        retval.put("Commits", new Long(this.m_commits));
        retval.put("Rollbacks", new Long(this.m_rollbacks));
        return retval;
    }

    protected GlobalTransaction findGlobalTransaction(Object[] params) {
        int clue = 0;
        if (params[clue] instanceof GlobalTransaction) {
            return (GlobalTransaction)params[clue];
        }
        int i = 0;
        while (i < params.length) {
            if (params[i] instanceof GlobalTransaction) {
                return (GlobalTransaction)params[i];
            }
            ++i;
        }
        return null;
    }

    private void copyInvocationScopeOptionsToTxScope(InvocationContext ctx) {
        TransactionEntry entry = this.txTable.get(ctx.getGlobalTransaction());
        if (entry != null) {
            Option txScopeOption = new Option();
            txScopeOption.setCacheModeLocal(ctx.getOptionOverrides() != null && ctx.getOptionOverrides().isCacheModeLocal());
            entry.setOption(txScopeOption);
        }
    }

    private Object handleRemotePrepare(JBCMethodCall m, GlobalTransaction gtx) throws Throwable {
        List modifications = (List)m.getArgs()[1];
        boolean onePhase = (Boolean)m.getArgs()[this.cache.isNodeLockingOptimistic() ? 4 : 3];
        Transaction ltx = this.txTable.getLocalTransaction(gtx);
        Transaction currentTx = this.txManager.getTransaction();
        Object retval = null;
        try {
            if (ltx == null) {
                if (currentTx != null) {
                    this.txManager.suspend();
                }
                ltx = this.createLocalTxForGlobalTx(gtx);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("(" + this.cache.getLocalAddress() + "): started new local TX as result of remote PREPARE: local TX=" + ltx + ", global TX=" + gtx));
                }
            } else {
                if (!this.isValid(ltx)) {
                    throw new CacheException("Transaction " + ltx + " not in correct state to be prepared");
                }
                if (currentTx == null || !ltx.equals(currentTx)) {
                    this.txManager.suspend();
                    this.txManager.resume(ltx);
                }
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Resuming existing transaction " + ltx + ", global TX=" + gtx));
            }
            if (this.txTable.get(gtx) == null) {
                TransactionEntry entry = this.cache.isNodeLockingOptimistic() ? new OptimisticTransactionEntry() : new TransactionEntry();
                entry.setTransaction(ltx);
                this.log.debug((Object)"creating new tx entry");
                this.txTable.put(gtx, entry);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("TxTable contents: " + this.txTable));
                }
            }
            this.registerHandler(ltx, new RemoteSynchronizationHandler(gtx, ltx, this.cache));
            retval = this.cache.isNodeLockingOptimistic() ? this.handleOptimisticPrepare(m, gtx, modifications, onePhase, ltx) : this.handlePessimisticPrepare(m, gtx, modifications, onePhase, ltx);
        }
        finally {
            this.txManager.suspend();
            if (currentTx != null) {
                this.txManager.resume(currentTx);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Finished remote prepare " + gtx));
            }
        }
        return retval;
    }

    private Object handleNonTxMethod(MethodCall m) throws Throwable {
        Object result;
        boolean implicitTransaction;
        InvocationContext ctx = this.getInvocationContext();
        Transaction tx = ctx.getTransaction();
        boolean bl = implicitTransaction = this.cache.isNodeLockingOptimistic() && tx == null;
        if (implicitTransaction) {
            tx = this.createLocalTx();
            ctx.setTransaction(tx);
        }
        if (tx != null) {
            m = this.attachGlobalTransaction(tx, m);
        }
        try {
            result = super.invoke(m);
            if (implicitTransaction) {
                this.copyInvocationScopeOptionsToTxScope(ctx);
                this.txManager.commit();
            }
        }
        catch (Throwable t) {
            if (implicitTransaction) {
                this.log.warn((Object)"Rolling back, exception encountered", t);
                result = t;
                try {
                    this.txManager.rollback();
                }
                catch (Throwable th) {
                    this.log.warn((Object)"Roll back failed encountered", th);
                }
            }
            throw t;
        }
        return result;
    }

    private MethodCall attachGlobalTransaction(Transaction tx, MethodCall m) throws Exception {
        GlobalTransaction gtx;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(" local transaction exists - registering global tx if not present for " + Thread.currentThread()));
        }
        if (this.log.isTraceEnabled()) {
            GlobalTransaction tempGtx = this.txTable.get(tx);
            this.log.trace((Object)("Associated gtx in txTable is " + tempGtx));
        }
        if ((gtx = this.registerTransaction(tx)) != null) {
            m = this.replaceGtx(m, gtx);
        } else {
            gtx = this.txTable.get(tx);
        }
        this.getInvocationContext().setGlobalTransaction(gtx);
        return m;
    }

    private Object handleOptimisticPrepare(MethodCall m, GlobalTransaction gtx, List modifications, boolean onePhase, Transaction ltx) throws Throwable {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Handling optimistic remote prepare " + gtx));
        }
        this.replayModifications(modifications, ltx);
        Object retval = super.invoke(m);
        if (!this.isActive(ltx)) {
            throw new ReplicationException("prepare() failed -- local transaction status is not STATUS_ACTIVE; is " + ltx.getStatus());
        }
        return retval;
    }

    private Object handlePessimisticPrepare(JBCMethodCall m, GlobalTransaction gtx, List modifications, boolean commit, Transaction ltx) throws Exception {
        boolean success = true;
        try {
            try {
                this.replayModifications(modifications, ltx);
                if (this.isOnePhaseCommitPrepareMehod(m)) {
                    this.log.trace((Object)"Using one-phase prepare.  Not propagating the prepare call up the stack until called to do so by the sync handler.");
                } else {
                    super.invoke(m);
                }
                if (!this.isActive(ltx)) {
                    throw new ReplicationException("prepare() failed -- local transaction status is not STATUS_ACTIVE; is " + ltx.getStatus());
                }
            }
            catch (Throwable th) {
                this.log.error((Object)"prepare method invocation failed", th);
                Throwable retval = th;
                success = false;
                if (retval instanceof Exception) {
                    throw (Exception)retval;
                }
            }
        }
        finally {
            block28: {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Are we running a 1-phase commit? " + commit));
                }
                if (commit) {
                    try {
                        try {
                            if (success) {
                                ltx.commit();
                            } else {
                                ltx.rollback();
                            }
                        }
                        catch (Throwable t) {
                            this.log.error((Object)"Commit/rollback failed.", t);
                            if (success) {
                                try {
                                    this.log.info((Object)"Attempting anotehr rollback");
                                    ltx.rollback();
                                }
                                catch (Throwable t2) {
                                    this.log.error((Object)"Unable to rollback", t2);
                                }
                            }
                            this.transactions.remove(ltx);
                            this.remoteTransactions.remove(gtx);
                            break block28;
                        }
                    }
                    catch (Throwable throwable) {
                        this.transactions.remove(ltx);
                        this.remoteTransactions.remove(gtx);
                        throw throwable;
                    }
                    this.transactions.remove(ltx);
                    this.remoteTransactions.remove(gtx);
                }
            }
        }
        return null;
    }

    private Object replayModifications(List modifications, Transaction tx) {
        Object retval = null;
        if (modifications != null) {
            for (MethodCall method_call : modifications) {
                try {
                    retval = super.invoke(method_call);
                    if (!this.isActive(tx)) {
                        throw new ReplicationException("prepare() failed -- local transaction status is not STATUS_ACTIVE; is " + tx.getStatus());
                    }
                }
                catch (Throwable t) {
                    this.log.error((Object)"method invocation failed", t);
                    retval = t;
                }
                if (retval == null || !(retval instanceof Exception)) continue;
                throw new RuntimeException((Exception)retval);
            }
        }
        return retval;
    }

    private Object handleRemoteCommitRollback(JBCMethodCall m, GlobalTransaction gtx) throws Throwable {
        Transaction ltx = null;
        try {
            ltx = this.getLocalTxForGlobalTx(gtx);
        }
        catch (IllegalStateException e) {
            if (m.getMethodId() == 12) {
                this.log.warn((Object)"No local transaction for this remotely originating rollback.  Possibly rolling back before a prepare call was broadcast?");
                return null;
            }
            throw e;
        }
        Transaction currentTx = this.txManager.getTransaction();
        boolean resumeCurrentTxOnCompletion = false;
        try {
            if (!ltx.equals(currentTx)) {
                currentTx = this.txManager.suspend();
                resumeCurrentTxOnCompletion = true;
                this.txManager.resume(ltx);
                this.getInvocationContext().setTransaction(ltx);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(" executing " + (Object)((Object)m) + "() with local TX " + ltx + " under global tx " + gtx));
            }
            if (m.getMethodId() == 11) {
                this.txManager.commit();
                if (this.cache.getUseInterceptorMbeans() && this.statsEnabled) {
                    ++this.m_commits;
                }
            } else {
                this.txManager.rollback();
                if (this.cache.getUseInterceptorMbeans() && this.statsEnabled) {
                    ++this.m_rollbacks;
                }
            }
        }
        finally {
            if (resumeCurrentTxOnCompletion) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Resuming suspended transaction " + currentTx));
                }
                this.txManager.suspend();
                if (currentTx != null) {
                    this.txManager.resume(currentTx);
                    this.getInvocationContext().setTransaction(currentTx);
                }
            }
            this.remoteTransactions.remove(gtx);
            this.transactions.remove(ltx);
            this.txTable.remove(gtx);
            this.txTable.remove(ltx);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Finished remote commit/rollback method for " + gtx));
        }
        return null;
    }

    private Transaction getLocalTxForGlobalTx(GlobalTransaction gtx) throws IllegalStateException {
        Transaction ltx = this.txTable.getLocalTransaction(gtx);
        if (ltx != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Found local TX=" + ltx + ", global TX=" + gtx));
            }
        } else {
            throw new IllegalStateException(" found no local TX for global TX " + gtx);
        }
        return ltx;
    }

    private Object handleCommitRollback(MethodCall m) throws Throwable {
        GlobalTransaction gtx = this.findGlobalTransaction(m.getArgs());
        Object result = super.invoke(m);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Finished local commit/rollback method for " + gtx));
        }
        return result;
    }

    protected void runCommitPhase(GlobalTransaction gtx, Transaction tx, List modifications, boolean onePhaseCommit) {
        this.getInvocationContext().setTxHasMods(modifications != null && modifications.size() > 0);
        try {
            JBCMethodCall commitMethod;
            if (onePhaseCommit) {
                if (this.cache.isNodeLockingOptimistic()) {
                    Object[] objectArray = new Object[5];
                    objectArray[0] = gtx;
                    objectArray[1] = modifications;
                    objectArray[3] = (Address)this.cache.getLocalAddress();
                    objectArray[4] = Boolean.TRUE;
                    commitMethod = MethodCallFactory.create(MethodDeclarations.optimisticPrepareMethod, objectArray);
                } else {
                    commitMethod = MethodCallFactory.create(MethodDeclarations.prepareMethod, new Object[]{gtx, modifications, (Address)this.cache.getLocalAddress(), Boolean.TRUE});
                }
            } else {
                commitMethod = MethodCallFactory.create(MethodDeclarations.commitMethod, new Object[]{gtx});
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)(" running commit for " + gtx));
            }
            this.handleCommitRollback(commitMethod);
        }
        catch (Throwable e) {
            this.log.warn((Object)"Commit failed.  Clearing stale locks.");
            try {
                this.cleanupStaleLocks(gtx);
            }
            catch (Throwable e2) {
                this.log.error((Object)"Unable to clear stale locks", e2);
                throw new RuntimeException(e2);
            }
            throw new RuntimeException("Commit failed.", e);
        }
    }

    private void cleanupStaleLocks(GlobalTransaction gtx) throws Throwable {
        TransactionEntry entry = this.txTable.get(gtx);
        entry.releaseAllLocksLIFO(gtx);
    }

    protected void runRollbackPhase(GlobalTransaction gtx, Transaction tx, List modifications) {
        try {
            try {
                this.getInvocationContext().setTxHasMods(modifications != null && modifications.size() > 0);
                JBCMethodCall rollbackMethod = MethodCallFactory.create(MethodDeclarations.rollbackMethod, new Object[]{gtx});
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)(" running rollback for " + gtx));
                }
                this.rollbackTransactions.put(tx, gtx);
                this.handleCommitRollback(rollbackMethod);
            }
            catch (Throwable e) {
                this.log.warn((Object)"Rollback had a problem", e);
                if (tx != null) {
                    this.rollbackTransactions.remove(tx);
                }
            }
        }
        finally {
            if (tx != null) {
                this.rollbackTransactions.remove(tx);
            }
        }
    }

    protected Object runPreparePhase(GlobalTransaction gtx, List modifications) throws Throwable {
        JBCMethodCall prepareMethod;
        if (this.cache.isNodeLockingOptimistic()) {
            Object[] objectArray = new Object[5];
            objectArray[0] = gtx;
            objectArray[1] = modifications;
            objectArray[3] = (Address)this.cache.getLocalAddress();
            objectArray[4] = Boolean.FALSE;
            prepareMethod = MethodCallFactory.create(MethodDeclarations.optimisticPrepareMethod, objectArray);
        } else if (this.cache.getCacheModeInternal() != 2) {
            prepareMethod = MethodCallFactory.create(MethodDeclarations.prepareMethod, new Object[]{gtx, modifications, (Address)this.cache.getLocalAddress(), Boolean.FALSE});
        } else {
            this.log.trace((Object)"This is a REPL_ASYNC call (1 phase commit) - do nothing for beforeCompletion()");
            return null;
        }
        Transaction ltx = this.txTable.getLocalTransaction(gtx);
        if (this.txManager.getTransaction() == null || ltx == null || !this.txManager.getTransaction().equals(ltx)) {
            this.log.warn((Object)("Local transaction does not exist or does not match expected transaction " + gtx));
            throw new CacheException(" local transaction " + ltx + " does not exist or does not match expected transaction " + gtx);
        }
        Object result = super.invoke(prepareMethod);
        return result;
    }

    private boolean isRemoteGlobalTx(GlobalTransaction gtx) {
        return gtx != null && gtx.getAddress() != null && !gtx.getAddress().equals(this.cache.getLocalAddress());
    }

    private GlobalTransaction registerTransaction(Transaction tx) throws Exception {
        GlobalTransaction gtx;
        if (this.isValid(tx) && this.transactions.put(tx, NULL) == null) {
            gtx = this.cache.getCurrentTransaction(tx);
            if (gtx.isRemote()) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"is a remotely initiated gtx so no need to register a tx for it");
                }
            } else {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Registering sync handler for tx " + tx + ", gtx " + gtx));
                }
                LocalSynchronizationHandler myHandler = new LocalSynchronizationHandler(gtx, tx, this.cache);
                this.registerHandler(tx, myHandler);
            }
        } else {
            gtx = (GlobalTransaction)this.rollbackTransactions.get(tx);
            if (gtx != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Transaction " + tx + " is already registered and is rolling back."));
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Transaction " + tx + " is already registered."));
            }
        }
        return gtx;
    }

    private void registerHandler(Transaction tx, RemoteSynchronizationHandler handler) throws Exception {
        OrderedSynchronizationHandler orderedHandler = OrderedSynchronizationHandler.getInstance(tx);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("registering for TX completion: SynchronizationHandler(" + handler + ")"));
        }
        orderedHandler.registerAtHead(handler);
    }

    private MethodCall replaceGtx(MethodCall m, GlobalTransaction gtx) {
        Class<?>[] argClasses = m.getMethod().getParameterTypes();
        Object[] args = m.getArgs();
        int i = 0;
        while (i < argClasses.length) {
            if (argClasses[i].equals(GlobalTransaction.class)) {
                if (gtx.equals(args[i])) break;
                args[i] = gtx;
                m.setArgs(args);
                break;
            }
            ++i;
        }
        return m;
    }

    private Transaction createLocalTx() throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Creating transaction for thread " + Thread.currentThread()));
        }
        if (this.txManager == null) {
            throw new Exception("Failed to create local transaction; TransactionManager is null");
        }
        this.txManager.begin();
        Transaction localTx = this.txManager.getTransaction();
        return localTx;
    }

    private Transaction createLocalTxForGlobalTx(GlobalTransaction gtx) throws Exception {
        Transaction localTx = this.createLocalTx();
        this.txTable.put(localTx, gtx);
        this.getInvocationContext().setTransaction(localTx);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Created new tx for gtx " + gtx));
        }
        return localTx;
    }

    private void setInvocationContext(Transaction tx, GlobalTransaction gtx) {
        InvocationContext ctx = this.getInvocationContext();
        ctx.setTransaction(tx);
        ctx.setGlobalTransaction(gtx);
    }

    private void scrubInvocationCtx(boolean removeTxs) {
        if (removeTxs) {
            this.setInvocationContext(null, null);
        }
        this.getInvocationContext().setOptionOverrides(null);
    }

    class LocalSynchronizationHandler
    extends RemoteSynchronizationHandler {
        private boolean localRollbackOnly;

        LocalSynchronizationHandler(GlobalTransaction gtx, Transaction tx, TreeCache cache) {
            super(gtx, tx, cache);
            this.localRollbackOnly = true;
        }

        public void beforeCompletion() {
            super.beforeCompletion();
            TxInterceptor.this.setInvocationContext(this.tx, this.gtx);
            if (this.modifications.size() == 0) {
                if (TxInterceptor.this.log.isTraceEnabled()) {
                    TxInterceptor.this.log.trace((Object)"No modifications in this tx.  Skipping beforeCompletion()");
                }
                return;
            }
            TxInterceptor.this.getInvocationContext().setOptionOverrides(this.entry.getOption());
            try {
                try {
                    switch (this.tx.getStatus()) {
                        case 0: 
                        case 7: {
                            Object result = TxInterceptor.this.runPreparePhase(this.gtx, this.modifications);
                            if (result instanceof Throwable) {
                                this.tx.setRollbackOnly();
                                throw (Throwable)result;
                            }
                            break;
                        }
                        default: {
                            throw new CacheException("transaction " + this.tx + " in status " + this.tx.getStatus() + " unbale to start transaction");
                        }
                    }
                }
                catch (Throwable t) {
                    try {
                        this.tx.setRollbackOnly();
                    }
                    catch (SystemException se) {
                        throw new RuntimeException("setting tx rollback failed ", se);
                    }
                    throw new RuntimeException("", t);
                }
            }
            finally {
                this.localRollbackOnly = false;
                TxInterceptor.this.scrubInvocationCtx(false);
            }
        }

        public void afterCompletion(int status) {
            TxInterceptor.this.getInvocationContext().setLocalRollbackOnly(this.localRollbackOnly);
            super.afterCompletion(status);
        }

        public String toString() {
            return "TxInterceptor.LocalSynchronizationHandler(gtx=" + this.gtx + ", tx=" + this.tx + ")";
        }
    }

    class RemoteSynchronizationHandler
    implements Synchronization {
        Transaction tx = null;
        GlobalTransaction gtx = null;
        TreeCache cache = null;
        List modifications = null;
        TransactionEntry entry = null;

        RemoteSynchronizationHandler(GlobalTransaction gtx, Transaction tx, TreeCache cache) {
            this.gtx = gtx;
            this.tx = tx;
            this.cache = cache;
        }

        public void beforeCompletion() {
            if (TxInterceptor.this.log.isTraceEnabled()) {
                TxInterceptor.this.log.trace((Object)("Running beforeCompletion on gtx " + this.gtx));
            }
            this.entry = TxInterceptor.this.txTable.get(this.gtx);
            if (this.entry == null) {
                TxInterceptor.this.log.error((Object)"Transaction has a null transaction entry - beforeCompletion() will fail.");
                TxInterceptor.this.log.error((Object)("TxTable contents: " + TxInterceptor.this.txTable));
                throw new IllegalStateException("cannot find transaction entry for " + this.gtx);
            }
            this.modifications = this.entry.getModifications();
        }

        public void afterCompletion(int status) {
            try {
                TxInterceptor.this.setInvocationContext(this.tx, this.gtx);
                if (TxInterceptor.this.log.isTraceEnabled()) {
                    TxInterceptor.this.log.trace((Object)("calling aftercompletion for " + this.gtx));
                }
                if ((this.entry = TxInterceptor.this.txTable.get(this.gtx)) != null) {
                    this.modifications = this.entry.getModifications();
                    TxInterceptor.this.getInvocationContext().setOptionOverrides(this.entry.getOption());
                }
                TxInterceptor.this.transactions.remove(this.tx);
                switch (status) {
                    case 3: {
                        boolean onePhaseCommit;
                        boolean bl = onePhaseCommit = !this.cache.isNodeLockingOptimistic() && this.cache.getCacheModeInternal() == 2;
                        if (TxInterceptor.this.log.isDebugEnabled()) {
                            TxInterceptor.this.log.debug((Object)("Running commit phase.  One phase? " + onePhaseCommit));
                        }
                        TxInterceptor.this.runCommitPhase(this.gtx, this.tx, this.modifications, onePhaseCommit);
                        TxInterceptor.this.log.debug((Object)"Finished commit phase");
                        break;
                    }
                    case 1: 
                    case 4: {
                        TxInterceptor.this.log.debug((Object)"Running rollback phase");
                        TxInterceptor.this.runRollbackPhase(this.gtx, this.tx, this.modifications);
                        TxInterceptor.this.log.debug((Object)"Finished rollback phase");
                        break;
                    }
                    default: {
                        throw new IllegalStateException("illegal status: " + status);
                    }
                }
            }
            finally {
                TxInterceptor.this.txTable.remove(this.gtx);
                TxInterceptor.this.txTable.remove(this.tx);
                TxInterceptor.this.scrubInvocationCtx(true);
            }
        }

        public String toString() {
            return "TxInterceptor.RemoteSynchronizationHandler(gtx=" + this.gtx + ", tx=" + this.tx + ")";
        }
    }
}

