/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.transaction.Transaction;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.lock.IdentityLock;
import org.jgroups.blocks.MethodCall;

public class UnlockInterceptor
extends Interceptor {
    Map lock_table = null;
    boolean trace = this.log.isTraceEnabled();

    public void setCache(TreeCache cache) {
        super.setCache(cache);
        this.lock_table = cache.getLockTable();
    }

    public Object invoke(MethodCall m) throws Throwable {
        try {
            Object object = super.invoke(m);
            return object;
        }
        finally {
            Transaction tx;
            InvocationContext ctx = this.getInvocationContext();
            if (!(ctx.getOptionOverrides() != null && ctx.getOptionOverrides().isSuppressLocking() || (tx = ctx.getTransaction()) != null && this.isValid(tx))) {
                Thread currentThread = Thread.currentThread();
                List locks = (List)this.lock_table.get(currentThread);
                if (this.trace) {
                    this.log.trace((Object)("Attempting to release locks on current thread.  Lock table is " + this.lock_table));
                }
                if (locks != null && locks.size() > 0) {
                    this.releaseLocks(locks, currentThread);
                    this.lock_table.remove(currentThread);
                }
            }
        }
    }

    private void releaseLocks(List locks, Thread currentThread) {
        ListIterator it = locks.listIterator(locks.size());
        while (it.hasPrevious()) {
            IdentityLock lock = (IdentityLock)it.previous();
            if (this.trace) {
                this.log.trace((Object)("releasing lock for " + lock.getFqn() + ": " + lock));
            }
            lock.release(currentThread);
        }
    }
}

