/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.AsyncCacheLoader;
import org.jboss.cache.loader.AsyncExtendedCacheLoader;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.ChainingCacheLoader;
import org.jboss.cache.loader.ExtendedCacheLoader;
import org.jboss.cache.xml.XmlHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CacheLoaderManager {
    private static Log log = LogFactory.getLog(CacheLoaderManager.class);
    private CacheLoaderConfig config;
    private TreeCache cache;
    private CacheLoader loader;
    private boolean fetchPersistentState;
    private boolean extendedCacheLoader = true;

    public void setConfig(Element cacheLoaderConfig, TreeCache cache) throws Exception {
        this.cache = cache;
        this.config = new CacheLoaderConfig();
        this.config.setPassivation(XmlHelper.readBooleanContents(cacheLoaderConfig, "passivation"));
        this.config.setPreload(XmlHelper.readStringContents(cacheLoaderConfig, "preload"));
        this.config.setShared(XmlHelper.readBooleanContents(cacheLoaderConfig, "shared"));
        NodeList cacheLoaderNodes = cacheLoaderConfig.getElementsByTagName("cacheloader");
        int i = 0;
        while (i < cacheLoaderNodes.getLength()) {
            Node node = cacheLoaderNodes.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                CacheLoaderConfig.IndividualCacheLoaderConfig clc = new CacheLoaderConfig.IndividualCacheLoaderConfig();
                clc.setAsync(XmlHelper.readBooleanContents(element, "async", false));
                clc.setIgnoreModifications(XmlHelper.readBooleanContents(element, "ignoreModifications", false));
                clc.setFetchPersistentState(XmlHelper.readBooleanContents(element, "fetchPersistentState", false));
                clc.setPurgeOnStartup(XmlHelper.readBooleanContents(element, "purgeOnStartup", false));
                clc.setClassName(XmlHelper.readStringContents(element, "class"));
                clc.setProperties(XmlHelper.readPropertiesContents(element, "properties"));
                this.config.addIndividualCacheLoaderConfig(clc);
            }
            ++i;
        }
        this.loader = this.createCacheLoader();
    }

    public void setConfig(CacheLoaderConfig config, TreeCache cache) throws Exception {
        this.config = config == null ? new CacheLoaderConfig() : config;
        this.cache = cache;
        this.loader = this.createCacheLoader();
    }

    private CacheLoader createCacheLoader() throws Exception {
        CacheLoader tmpLoader = null;
        if (this.config.useChainingCacheLoader()) {
            ChainingCacheLoader ccl = tmpLoader = new ChainingCacheLoader();
            Iterator it = this.config.getIndividualCacheLoaderConfigs().iterator();
            int numLoadersWithFetchPersistentState = 0;
            while (it.hasNext()) {
                CacheLoaderConfig.IndividualCacheLoaderConfig cfg = (CacheLoaderConfig.IndividualCacheLoaderConfig)it.next();
                if (cfg.isFetchPersistentState()) {
                    ++numLoadersWithFetchPersistentState;
                    this.fetchPersistentState = true;
                }
                if (numLoadersWithFetchPersistentState > 1) {
                    throw new Exception("Invalid cache loader configuration!!  Only ONE cache loader may have fetchPersistentState set to true.  Cache will not start!");
                }
                CacheLoader l = this.createCacheLoader(cfg, this.cache);
                if (cfg.isFetchPersistentState()) {
                    this.extendedCacheLoader = this.extendedCacheLoader && l instanceof ExtendedCacheLoader;
                }
                ccl.addCacheLoader(l, cfg);
            }
        } else {
            CacheLoaderConfig.IndividualCacheLoaderConfig cfg = (CacheLoaderConfig.IndividualCacheLoaderConfig)this.config.getIndividualCacheLoaderConfigs().get(0);
            tmpLoader = this.createCacheLoader(cfg, this.cache);
            this.fetchPersistentState = cfg.isFetchPersistentState();
            this.extendedCacheLoader = tmpLoader instanceof ExtendedCacheLoader;
        }
        return tmpLoader;
    }

    private CacheLoader createCacheLoader(CacheLoaderConfig.IndividualCacheLoaderConfig cfg, TreeCache cache) throws Exception {
        CacheLoader tmpLoader = this.createInstance(cfg.getClassName());
        if (tmpLoader != null) {
            if (cfg.isAsync()) {
                AsyncCacheLoader asyncDecorator = tmpLoader instanceof ExtendedCacheLoader ? new AsyncExtendedCacheLoader((ExtendedCacheLoader)tmpLoader) : new AsyncCacheLoader(tmpLoader);
                tmpLoader = asyncDecorator;
            }
            tmpLoader.setConfig(cfg.getProperties());
            tmpLoader.setCache(cache);
            if (cache != null && cache.getUseMarshalling() && tmpLoader instanceof ExtendedCacheLoader) {
                ((ExtendedCacheLoader)tmpLoader).setRegionManager(cache.getRegionManager());
            }
        }
        return tmpLoader;
    }

    private CacheLoader createInstance(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> cl = Thread.currentThread().getContextClassLoader().loadClass(className);
        return (CacheLoader)cl.newInstance();
    }

    public void preloadCache() throws Exception {
        if (this.config.getPreload() == null || this.config.getPreload().equals("")) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("preloading transient state from cache loader " + this.loader));
        }
        StringTokenizer st = new StringTokenizer(this.config.getPreload(), ",");
        long start = System.currentTimeMillis();
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            Fqn fqn = Fqn.fromString(tok.trim());
            if (log.isTraceEnabled()) {
                log.trace((Object)("preloading " + fqn));
            }
            this.preload(fqn, true, true);
        }
        long stop = System.currentTimeMillis();
        long total = stop - start;
        if (log.isDebugEnabled()) {
            log.debug((Object)("preloading transient state from cache loader was successful (in " + total + " milliseconds)"));
        }
    }

    public void preload(Fqn fqn, boolean preloadParents, boolean preloadChildren) throws Exception {
        Set children;
        this.cache.get(fqn, (Object)"bla");
        if (preloadParents) {
            Fqn tmp_fqn = Fqn.ROOT;
            int i = 0;
            while (i < fqn.size() - 1) {
                tmp_fqn = new Fqn(tmp_fqn, fqn.get(i));
                this.cache.get(tmp_fqn, (Object)"bla");
                ++i;
            }
        }
        if (preloadChildren && (children = this.loader.getChildrenNames(fqn)) != null) {
            for (String child_name : children) {
                Fqn child_fqn = new Fqn(fqn, child_name);
                this.preload(child_fqn, false, true);
            }
        }
    }

    public CacheLoaderConfig getCacheLoaderConfig() {
        return this.config;
    }

    public CacheLoader getCacheLoader() {
        return this.loader;
    }

    public void setCacheLoader(CacheLoader loader) {
        this.loader = loader;
    }

    public boolean isPassivation() {
        return this.config.isPassivation();
    }

    public boolean isFetchPersistentState() {
        return this.fetchPersistentState;
    }

    public boolean isExtendedCacheLoader() {
        return this.extendedCacheLoader;
    }

    public void stopCacheLoader() {
        if (this.loader == null) {
            throw new RuntimeException("Problem with configured cache loader - it has been set to null!");
        }
        this.loader.stop();
        this.loader.destroy();
    }

    public void startCacheLoader() throws Exception {
        if (this.loader == null) {
            throw new RuntimeException("Improperly configured cache loader - cache loader is null!");
        }
        this.loader.create();
        this.loader.start();
        this.purgeLoaders(false);
    }

    public void purgeLoaders(boolean force) throws Exception {
        if (this.loader instanceof ChainingCacheLoader && !force) {
            ((ChainingCacheLoader)this.loader).purgeIfNecessary();
        } else {
            CacheLoaderConfig.IndividualCacheLoaderConfig first = this.getCacheLoaderConfig().getFirstCacheLoaderConfig();
            if (force || first != null && first.isPurgeOnStartup()) {
                this.loader.remove(Fqn.ROOT);
            }
        }
    }
}

