/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.TreeCache;
import org.jboss.cache.loader.DelegatingCacheLoader;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.marshall.JBCMethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jgroups.Address;
import org.jgroups.blocks.MethodCall;

public class RpcDelegatingCacheLoader
extends DelegatingCacheLoader {
    private int timeout;
    private TreeCache cache;
    private Address localAddress;
    public static final Method METHOD_GET_STATE;
    public static final Method METHOD_SET_STATE;
    public static final Method METHOD_GET_CHILDREN_NAMES;
    public static final Method METHOD_GET_WITH_2_PARAMS;
    public static final Method METHOD_GET_WITH_1_PARAM;
    public static final Method METHOD_EXISTS;
    public static final Method METHOD_PUT_WITH_3_PARAMS;
    public static final Method METHOD_PUT_WITH_2_PARAMS;
    public static final Method METHOD_REMOVE_WITH_2_PARAMS;
    public static final Method METHOD_REMOVE_WITH_1_PARAM;
    public static final Method METHOD_REMOVE_DATA;

    static {
        try {
            METHOD_GET_STATE = TreeCache.class.getDeclaredMethod("getStateBytes", new Class[0]);
            METHOD_SET_STATE = TreeCache.class.getDeclaredMethod("setStateBytes", byte[].class);
            METHOD_GET_CHILDREN_NAMES = TreeCache.class.getDeclaredMethod("getChildrenNames", Fqn.class);
            METHOD_GET_WITH_2_PARAMS = TreeCache.class.getDeclaredMethod("get", Fqn.class, Object.class);
            METHOD_GET_WITH_1_PARAM = TreeCache.class.getDeclaredMethod("get", Fqn.class);
            METHOD_EXISTS = TreeCache.class.getDeclaredMethod("exists", Fqn.class);
            METHOD_PUT_WITH_3_PARAMS = TreeCache.class.getDeclaredMethod("put", Fqn.class, Object.class, Object.class);
            METHOD_PUT_WITH_2_PARAMS = TreeCache.class.getDeclaredMethod("put", Fqn.class, Map.class);
            METHOD_REMOVE_WITH_2_PARAMS = TreeCache.class.getDeclaredMethod("remove", Fqn.class, Object.class);
            METHOD_REMOVE_WITH_1_PARAM = TreeCache.class.getDeclaredMethod("remove", Fqn.class);
            METHOD_REMOVE_DATA = TreeCache.class.getDeclaredMethod("removeData", Fqn.class);
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
            throw new ExceptionInInitializerError(ex.toString());
        }
    }

    public RpcDelegatingCacheLoader() {
    }

    public RpcDelegatingCacheLoader(TreeCache cache, int timeout) {
        this.cache = cache;
        this.timeout = timeout;
    }

    public void setConfig(Properties props) {
        if (props == null) {
            return;
        }
        String t = props.getProperty("timeout");
        this.timeout = t == null || t.length() == 0 ? 5000 : Integer.parseInt(t);
    }

    public void setCache(TreeCache cache) {
        this.cache = cache;
    }

    protected Set delegateGetChildrenNames(Fqn name) throws Exception {
        return (Set)this.doMethodCall(METHOD_GET_CHILDREN_NAMES, new Object[]{name});
    }

    protected Map delegateGet(Fqn name) throws Exception {
        DataNode n = (DataNode)this.doMethodCall(METHOD_GET_WITH_1_PARAM, new Object[]{name});
        if (n == null) {
            return null;
        }
        return n.getData();
    }

    protected boolean delegateExists(Fqn name) throws Exception {
        Boolean exists = (Boolean)this.doMethodCall(METHOD_EXISTS, new Object[]{name});
        return exists != null && exists != false;
    }

    protected Object delegatePut(Fqn name, Object key, Object value) throws Exception {
        return this.doMethodCall(METHOD_PUT_WITH_3_PARAMS, new Object[]{name, key, value});
    }

    protected void delegatePut(Fqn name, Map attributes) throws Exception {
        this.doMethodCall(METHOD_PUT_WITH_2_PARAMS, new Object[]{name, attributes});
    }

    protected void delegatePut(List modifications) throws Exception {
        for (Modification m : modifications) {
            switch (m.getType()) {
                case 2: {
                    this.put(m.getFqn(), m.getData());
                    break;
                }
                case 3: {
                    this.put(m.getFqn(), m.getData(), true);
                    break;
                }
                case 1: {
                    this.put(m.getFqn(), m.getKey(), m.getValue());
                    break;
                }
                case 6: {
                    this.removeData(m.getFqn());
                    break;
                }
                case 5: {
                    this.remove(m.getFqn(), m.getKey());
                    break;
                }
                case 4: {
                    this.remove(m.getFqn());
                    break;
                }
                default: {
                    this.log.error((Object)("modification type " + m.getType() + " not known"));
                }
            }
        }
    }

    protected Object delegateRemove(Fqn name, Object key) throws Exception {
        return this.doMethodCall(METHOD_REMOVE_WITH_2_PARAMS, new Object[]{name, key});
    }

    protected void delegateRemove(Fqn name) throws Exception {
        this.doMethodCall(METHOD_REMOVE_WITH_1_PARAM, new Object[]{name});
    }

    protected void delegateRemoveData(Fqn name) throws Exception {
        this.doMethodCall(METHOD_REMOVE_DATA, new Object[]{name});
    }

    public byte[] delegateLoadEntireState() throws Exception {
        return (byte[])this.doMethodCall(METHOD_GET_STATE, new Object[0]);
    }

    public void delegateStoreEntireState(byte[] state) throws Exception {
        this.doMethodCall(METHOD_SET_STATE, new Object[]{state});
    }

    private Object doMethodCall(Method method, Object[] args) throws Exception {
        if (this.cache.isCoordinator()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Cannot delegate to the remote coordinator because the cache is itself the coordinator.");
            }
            return null;
        }
        if (this.localAddress == null) {
            this.localAddress = (Address)this.cache.getLocalAddress();
        }
        if (this.localAddress == null) {
            throw new Exception("Cannot delegate to the remote coordinator because the cache has no local address.");
        }
        Address coordinator = this.cache.getCoordinator();
        if (coordinator == null) {
            throw new Exception("Cannot delegate to the remote coordinator because the cache has no coordinator.");
        }
        Vector<Address> members = new Vector<Address>();
        members.add(coordinator);
        JBCMethodCall methodCall = MethodCallFactory.create(method, args);
        boolean synchronous = true;
        boolean excludeSelf = true;
        List responses = this.cache.callRemoteMethods(members, (MethodCall)methodCall, synchronous, excludeSelf, (long)this.timeout);
        if (responses == null) {
            throw new Exception("Remote method call [" + this.cache.getLocalAddress() + "]->[" + coordinator + "]." + methodCall.getMethod().getName() + "() was discarded!");
        }
        Object response = responses.get(0);
        if (response instanceof TimeoutException) {
            throw new Exception("Remote method call [" + this.cache.getLocalAddress() + "]->[" + coordinator + "]." + methodCall.getMethod().getName() + "() timed out: " + response);
        }
        if (response instanceof Throwable) {
            throw new Exception("Remote method call [" + this.cache.getLocalAddress() + "]->[" + coordinator + "]." + methodCall.getMethod().getName() + "() failed!", (Throwable)response);
        }
        return response;
    }
}

