/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader.bdbje;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DeadlockException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.util.DbDump;
import com.sleepycat.je.util.DbLoad;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.TreeCache;
import org.jboss.cache.loader.CacheLoader;

public class BdbjeCacheLoader
implements CacheLoader {
    private static final int MAX_TXN_RETRIES = 10;
    private static final char LOWEST_UTF_CHAR = '\u0001';
    private static final Log log = LogFactory.getLog(BdbjeCacheLoader.class);
    private String configStr;
    private TreeCache treeCache;
    private Environment env;
    private String cacheDbName;
    private String catalogDbName;
    private Database cacheDb;
    private Database catalogDb;
    private StoredClassCatalog catalog;
    private SerialBinding serialBinding;
    private Map txnMap;
    private boolean transactional;

    public void create() throws Exception {
        String license = "\n*************************************************************************************\nBerkeley DB Java Edition version: " + JEVersion.CURRENT_VERSION.toString() + "\n" + "JBossCache can use Berkeley DB Java Edition from Sleepycat Software \n" + "(http://www.sleepycat.com/jeforjbosscache)\n" + "for persistent, reliable and transaction-protected data storage.\n" + "If you choose to use Berkeley DB Java Edition with JBossCache, you must comply with the terms\n" + "of Sleepycat's public license, included in the file LICENSE.txt.\n" + "If you prefer not to release the source code for your own application in order to comply\n" + "with the Sleepycat public license, you may purchase a different license for use of\n" + "Berkeley DB Java Edition with JBossCache.\n" + "Contact Sleepycat Software at info@sleepycat.com for pricing and terms for that license\n" + "*************************************************************************************";
        System.out.println(license);
        log.trace((Object)"Creating BdbjeCacheLoader instance.");
        this.checkNotOpen();
    }

    public void destroy() {
    }

    public void start() throws Exception {
        File homeDir;
        boolean created;
        File location;
        log.trace((Object)"Starting BdbjeCacheLoader instance.");
        this.checkNotOpen();
        if (this.treeCache == null) {
            throw new IllegalStateException("A non-null Cache property (TreeCache object) is required");
        }
        if (this.configStr == null) {
            this.configStr = System.getProperty("java.io.tmpdir");
        }
        if (!(location = new File(this.configStr)).exists() && !(created = location.mkdirs())) {
            throw new IOException("Unable to create cache loader location " + location);
        }
        if (!location.isDirectory()) {
            throw new IOException("Cache loader location [" + location + "] is not a directory!");
        }
        int offset = this.configStr.indexOf(35);
        if (offset >= 0 && offset < this.configStr.length() - 1) {
            homeDir = new File(this.configStr.substring(0, offset));
            this.cacheDbName = this.configStr.substring(offset + 1);
        } else {
            homeDir = new File(this.configStr);
            this.cacheDbName = this.treeCache.getClusterName();
        }
        this.catalogDbName = String.valueOf(this.cacheDbName) + "_class_catalog";
        this.transactional = this.treeCache.getTransactionManager() != null;
        try {
            EnvironmentConfig envConfig = new EnvironmentConfig();
            envConfig.setAllowCreate(true);
            envConfig.setTransactional(true);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Creating JE environment with home dir " + homeDir));
            }
            this.env = new Environment(homeDir, envConfig);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created JE environment " + this.env + " for cache loader " + this));
            }
            this.openDatabases();
        }
        catch (Exception e) {
            this.destroy();
            throw e;
        }
    }

    private void openDatabases() throws Exception {
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setAllowCreate(true);
        dbConfig.setTransactional(this.transactional);
        this.cacheDb = this.env.openDatabase(null, this.cacheDbName, dbConfig);
        this.catalogDb = this.env.openDatabase(null, this.catalogDbName, dbConfig);
        this.catalog = new StoredClassCatalog(this.catalogDb);
        this.serialBinding = new SerialBinding((ClassCatalog)this.catalog, null);
        this.txnMap = new ConcurrentHashMap();
    }

    private void closeDatabases() {
        if (this.cacheDb != null) {
            try {
                this.cacheDb.close();
            }
            catch (Exception shouldNotOccur) {
                log.warn((Object)"Caught unexpected exception", (Throwable)shouldNotOccur);
            }
        }
        if (this.catalogDb != null) {
            try {
                this.catalogDb.close();
            }
            catch (Exception shouldNotOccur) {
                log.warn((Object)"Caught unexpected exception", (Throwable)shouldNotOccur);
            }
        }
        this.cacheDb = null;
        this.catalogDb = null;
        this.catalog = null;
        this.serialBinding = null;
        this.txnMap = null;
    }

    public void stop() {
        this.closeDatabases();
        if (this.env != null) {
            try {
                this.env.close();
            }
            catch (Exception shouldNotOccur) {
                log.warn((Object)"Unexpected exception", (Throwable)shouldNotOccur);
            }
        }
        this.env = null;
    }

    public void setConfig(Properties props) {
        this.checkNotOpen();
        String string = this.configStr = props != null ? props.getProperty("location") : null;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Configuring cache loader with location = " + this.configStr));
        }
    }

    public void setCache(TreeCache c) {
        this.checkNotOpen();
        this.treeCache = c;
    }

    public Set getChildrenNames(Fqn name) throws Exception {
        this.checkOpen();
        this.checkNonNull(name, "name");
        DatabaseEntry prefixEntry = this.makeKeyEntry(name);
        DatabaseEntry dataEntry = new DatabaseEntry();
        dataEntry.setPartial(0, 0, true);
        String namePart = "";
        int namePartIndex = name.size();
        HashSet<String> set = null;
        Cursor cursor = this.cacheDb.openCursor(null, null);
        try {
            DatabaseEntry keyEntry;
            OperationStatus status;
            while ((status = cursor.getSearchKeyRange(keyEntry = this.makeKeyEntry(prefixEntry, namePart), dataEntry, null)) == OperationStatus.SUCCESS) {
                if (!this.startsWith(keyEntry, prefixEntry)) {
                    break;
                }
                if (set == null) {
                    set = new HashSet<String>();
                }
                Fqn childName = this.makeKeyObject(keyEntry);
                namePart = childName.get(namePartIndex).toString();
                set.add(namePart);
                namePart = String.valueOf(namePart) + '\u0001';
            }
        }
        finally {
            cursor.close();
        }
        if (set != null) {
            return Collections.unmodifiableSet(set);
        }
        return null;
    }

    public Map get(Fqn name) throws Exception {
        this.checkOpen();
        this.checkNonNull(name, "name");
        DatabaseEntry keyEntry = this.makeKeyEntry(name);
        DatabaseEntry foundData = new DatabaseEntry();
        OperationStatus status = this.cacheDb.get(null, keyEntry, foundData, null);
        if (status == OperationStatus.SUCCESS) {
            return this.makeDataObject(foundData, true);
        }
        return null;
    }

    public boolean exists(Fqn name) throws Exception {
        this.checkOpen();
        this.checkNonNull(name, "name");
        DatabaseEntry keyEntry = this.makeKeyEntry(name);
        DatabaseEntry foundData = new DatabaseEntry();
        foundData.setPartial(0, 0, true);
        OperationStatus status = this.cacheDb.get(null, keyEntry, foundData, null);
        return status == OperationStatus.SUCCESS;
    }

    public Object put(Fqn name, Object key, Object value) throws Exception {
        Object oldVal;
        this.checkOpen();
        this.checkNonNull(name, "name");
        if (this.transactional) {
            Modification mod = new Modification(1, name, key, value);
            this.commitModification(mod);
            oldVal = mod.getOldValue();
        } else {
            oldVal = this.doPut(null, name, key, value);
        }
        return oldVal;
    }

    private Object doPut(Transaction txn, Fqn name, Object key, Object value) throws Exception {
        Object oldVal = null;
        Map<Object, Object> map = new HashMap<Object, Object>();
        map.put(key, value);
        DatabaseEntry dataEntry = this.makeDataEntry(map);
        DatabaseEntry keyEntry = this.makeKeyEntry(name);
        Cursor cursor = this.cacheDb.openCursor(txn, null);
        try {
            OperationStatus status = cursor.putNoOverwrite(keyEntry, dataEntry);
            if (status == OperationStatus.SUCCESS) {
                this.createParentNodes(cursor, name);
            } else {
                DatabaseEntry foundData = new DatabaseEntry();
                status = cursor.getSearchKey(keyEntry, foundData, LockMode.RMW);
                if (status == OperationStatus.SUCCESS) {
                    map = this.makeDataObject(foundData, true);
                    oldVal = map.put(key, value);
                    cursor.putCurrent(this.makeDataEntry(map));
                }
            }
        }
        finally {
            cursor.close();
        }
        return oldVal;
    }

    public void put(Fqn name, Map values) throws Exception {
        this.checkOpen();
        this.checkNonNull(name, "name");
        if (this.transactional) {
            this.commitModification(new Modification(2, name, values));
        } else {
            this.doPut(null, name, values);
        }
    }

    private void doPut(Transaction txn, Fqn name, Map values) throws Exception {
        DatabaseEntry dataEntry = this.makeDataEntry(values);
        DatabaseEntry keyEntry = this.makeKeyEntry(name);
        Cursor cursor = this.cacheDb.openCursor(txn, null);
        try {
            OperationStatus status = cursor.putNoOverwrite(keyEntry, dataEntry);
            if (status == OperationStatus.SUCCESS) {
                this.createParentNodes(cursor, name);
            } else {
                DatabaseEntry foundData = new DatabaseEntry();
                status = cursor.getSearchKey(keyEntry, foundData, LockMode.RMW);
                if (status == OperationStatus.SUCCESS) {
                    Map map = this.makeDataObject(foundData, true);
                    if (values != null) {
                        map.putAll(values);
                    }
                    cursor.putCurrent(this.makeDataEntry(map));
                }
            }
        }
        finally {
            cursor.close();
        }
    }

    private void doPutErase(Transaction txn, Fqn name, Map values) throws Exception {
        DatabaseEntry dataEntry = this.makeDataEntry(values);
        DatabaseEntry keyEntry = this.makeKeyEntry(name);
        Cursor cursor = this.cacheDb.openCursor(txn, null);
        try {
            cursor.put(keyEntry, dataEntry);
            this.createParentNodes(cursor, name);
        }
        finally {
            cursor.close();
        }
    }

    public void put(List modifications) throws Exception {
        this.checkOpen();
        this.checkNonNull(modifications, "modifications");
        if (this.transactional) {
            this.commitModifications(modifications);
        } else {
            this.doPut(null, modifications);
        }
    }

    private void doPut(Transaction txn, List modifications) throws Exception {
        for (Modification mod : modifications) {
            Fqn name = mod.getFqn();
            switch (mod.getType()) {
                case 1: {
                    Object oldVal = this.doPut(txn, name, mod.getKey(), mod.getValue());
                    mod.setOldValue(oldVal);
                    break;
                }
                case 2: {
                    this.doPut(txn, name, mod.getData());
                    break;
                }
                case 3: {
                    this.doPutErase(txn, name, mod.getData());
                    break;
                }
                case 5: {
                    Object oldVal = this.doRemove(txn, name, mod.getKey());
                    mod.setOldValue(oldVal);
                    break;
                }
                case 4: {
                    this.doRemove(txn, name);
                    break;
                }
                case 6: {
                    this.doRemoveData(txn, name);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Modification type: " + mod.getType());
                }
            }
        }
    }

    private void createParentNodes(Cursor cursor, Fqn name) throws Exception {
        DatabaseEntry dataEntry = this.makeDataEntry(null);
        int nParts = name.size() - 1;
        while (nParts >= 1) {
            DatabaseEntry keyEntry = this.makeKeyEntry(name, nParts);
            OperationStatus status = cursor.putNoOverwrite(keyEntry, dataEntry);
            if (status != OperationStatus.SUCCESS) break;
            --nParts;
        }
    }

    public void remove(Fqn name) throws Exception {
        this.checkOpen();
        this.checkNonNull(name, "name");
        if (this.transactional) {
            this.commitModification(new Modification(4, name));
        } else {
            this.doRemove(null, name);
        }
    }

    private void doRemove(Transaction txn, Fqn name) throws Exception {
        DatabaseEntry keyEntry = this.makeKeyEntry(name);
        DatabaseEntry foundKey = new DatabaseEntry();
        DatabaseEntry foundData = new DatabaseEntry();
        foundData.setPartial(0, 0, true);
        Cursor cursor = this.cacheDb.openCursor(txn, null);
        try {
            OperationStatus status = cursor.getSearchKey(keyEntry, foundData, LockMode.RMW);
            while (status == OperationStatus.SUCCESS) {
                cursor.delete();
                status = cursor.getNext(foundKey, foundData, LockMode.RMW);
                if (status != OperationStatus.SUCCESS || this.startsWith(foundKey, keyEntry)) continue;
                status = OperationStatus.NOTFOUND;
            }
        }
        finally {
            cursor.close();
        }
    }

    public Object remove(Fqn name, Object key) throws Exception {
        Object oldVal;
        this.checkOpen();
        this.checkNonNull(name, "name");
        if (this.transactional) {
            Modification mod = new Modification(5, name, key);
            this.commitModification(mod);
            oldVal = mod.getOldValue();
        } else {
            oldVal = this.doRemove(null, name, key);
        }
        return oldVal;
    }

    private Object doRemove(Transaction txn, Fqn name, Object key) throws Exception {
        Object oldVal = null;
        DatabaseEntry keyEntry = this.makeKeyEntry(name);
        DatabaseEntry foundData = new DatabaseEntry();
        Cursor cursor = this.cacheDb.openCursor(txn, null);
        try {
            OperationStatus status = cursor.getSearchKey(keyEntry, foundData, LockMode.RMW);
            if (status == OperationStatus.SUCCESS) {
                Map map = this.makeDataObject(foundData, true);
                oldVal = map.remove(key);
                cursor.putCurrent(this.makeDataEntry(map));
            }
        }
        finally {
            cursor.close();
        }
        return oldVal;
    }

    public void removeData(Fqn name) throws Exception {
        this.checkOpen();
        this.checkNonNull(name, "name");
        if (this.transactional) {
            this.commitModification(new Modification(6, name));
        } else {
            this.doRemoveData(null, name);
        }
    }

    private void doRemoveData(Transaction txn, Fqn name) throws Exception {
        DatabaseEntry dataEntry = new DatabaseEntry();
        dataEntry.setPartial(0, 0, true);
        DatabaseEntry keyEntry = this.makeKeyEntry(name);
        Cursor cursor = this.cacheDb.openCursor(txn, null);
        try {
            OperationStatus status = cursor.getSearchKey(keyEntry, dataEntry, LockMode.RMW);
            if (status == OperationStatus.SUCCESS) {
                cursor.putCurrent(this.makeDataEntry(null));
            }
        }
        finally {
            cursor.close();
        }
    }

    public void prepare(Object tx, List modifications, boolean onePhase) throws Exception {
        this.checkOpen();
        this.checkNonNull(modifications, "modifications");
        if (!onePhase) {
            this.checkNonNull(tx, "tx");
        }
        if (!this.transactional) {
            throw new UnsupportedOperationException("prepare() not allowed with a non-transactional cache loader");
        }
        Transaction txn = this.performTransaction(modifications);
        if (onePhase) {
            txn.commit();
        } else {
            this.txnMap.put(tx, txn);
        }
    }

    private void commitModification(Modification mod) throws Exception {
        this.commitModifications(Collections.singletonList(mod));
    }

    private void commitModifications(List mods) throws Exception {
        if (!this.transactional) {
            throw new IllegalStateException();
        }
        Transaction txn = this.performTransaction(mods);
        txn.commit();
    }

    private Transaction performTransaction(List modifications) throws Exception {
        int retries = 10;
        while (true) {
            Transaction txn = this.env.beginTransaction(null, null);
            try {
                this.doPut(txn, modifications);
                return txn;
            }
            catch (Exception e) {
                txn.abort();
                if (e instanceof DeadlockException && retries > 0) {
                    --retries;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public void commit(Object tx) throws Exception {
        this.checkOpen();
        this.checkNonNull(tx, "tx");
        Transaction txn = (Transaction)this.txnMap.remove(tx);
        if (txn != null) {
            txn.commit();
        } else if (this.transactional) {
            throw new IllegalArgumentException("Unknown txn key: " + tx);
        }
    }

    public void rollback(Object tx) {
        this.checkOpen();
        this.checkNonNull(tx, "tx");
        Transaction txn = (Transaction)this.txnMap.remove(tx);
        if (txn != null) {
            try {
                txn.abort();
            }
            catch (Exception exception) {}
        } else if (this.transactional) {
            throw new IllegalArgumentException("Unknown txn key: " + tx);
        }
    }

    public byte[] loadEntireState() throws Exception {
        boolean isEmpty;
        this.checkOpen();
        Cursor cursor = this.cacheDb.openCursor(null, null);
        try {
            isEmpty = cursor.getFirst(new DatabaseEntry(), new DatabaseEntry(), null) != OperationStatus.SUCCESS;
        }
        finally {
            cursor.close();
        }
        if (isEmpty) {
            return new byte[0];
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        PrintStream ps = new PrintStream((OutputStream)baos, false, "US-ASCII");
        this.dumpDatabase(this.cacheDbName, ps);
        this.dumpDatabase(this.catalogDbName, ps);
        ps.flush();
        return baos.toByteArray();
    }

    private void dumpDatabase(String dbName, PrintStream ps) throws Exception {
        DbDump dumper = new DbDump(this.env, dbName, ps, false);
        dumper.dump();
    }

    public void storeEntireState(byte[] state) throws Exception {
        this.checkOpen();
        this.closeDatabases();
        this.env.removeDatabase(null, this.cacheDbName);
        this.env.removeDatabase(null, this.catalogDbName);
        if (state != null && state.length > 0) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(state)));
            this.loadDatabase(this.cacheDbName, reader);
            this.loadDatabase(this.catalogDbName, reader);
        }
        this.openDatabases();
    }

    private void loadDatabase(String dbName, BufferedReader reader) throws Exception {
        DbLoad loader = new DbLoad();
        loader.setEnv(this.env);
        loader.setDbName(dbName);
        loader.setInputReader(reader);
        loader.setNoOverwrite(false);
        loader.setTextFileMode(false);
        loader.setIgnoreUnknownConfig(true);
        loader.load();
    }

    private boolean startsWith(DatabaseEntry entry, DatabaseEntry prefix) {
        int size = prefix.getSize();
        if (size > entry.getSize()) {
            return false;
        }
        byte[] d1 = entry.getData();
        byte[] d2 = prefix.getData();
        int o1 = entry.getOffset();
        int o2 = prefix.getOffset();
        int i = 0;
        while (i < size) {
            if (d1[o1 + i] != d2[o2 + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Fqn makeKeyObject(DatabaseEntry entry) {
        Fqn name = Fqn.ROOT;
        TupleInput tupleInput = TupleBinding.entryToInput((DatabaseEntry)entry);
        while (tupleInput.available() > 0) {
            String part = tupleInput.readString();
            name = new Fqn(name, part);
        }
        return name;
    }

    private DatabaseEntry makeKeyEntry(Fqn name) {
        return this.makeKeyEntry(name, name.size());
    }

    private DatabaseEntry makeKeyEntry(Fqn name, int nParts) {
        TupleOutput tupleOutput = new TupleOutput();
        int i = 0;
        while (i < nParts) {
            tupleOutput.writeString(name.get(i).toString());
            ++i;
        }
        DatabaseEntry entry = new DatabaseEntry();
        TupleBinding.outputToEntry((TupleOutput)tupleOutput, (DatabaseEntry)entry);
        return entry;
    }

    private DatabaseEntry makeKeyEntry(DatabaseEntry prefix, String namePart) {
        TupleOutput tupleOutput = new TupleOutput();
        tupleOutput.writeFast(prefix.getData(), prefix.getOffset(), prefix.getSize());
        tupleOutput.writeString(namePart);
        DatabaseEntry entry = new DatabaseEntry();
        TupleBinding.outputToEntry((TupleOutput)tupleOutput, (DatabaseEntry)entry);
        return entry;
    }

    private Map makeDataObject(DatabaseEntry entry, boolean createIfNull) {
        HashMap map = (HashMap)this.serialBinding.entryToObject(entry);
        if (createIfNull && map == null) {
            map = new HashMap();
        }
        return map;
    }

    private DatabaseEntry makeDataEntry(Map map) {
        if (map != null) {
            if (map.size() == 0) {
                map = null;
            } else if (!(map instanceof Serializable)) {
                map = new HashMap(map);
            }
        }
        DatabaseEntry entry = new DatabaseEntry();
        this.serialBinding.objectToEntry((Object)map, entry);
        return entry;
    }

    private void checkOpen() {
        if (this.env == null) {
            throw new IllegalStateException("Operation not allowed before calling create()");
        }
    }

    private void checkNotOpen() {
        if (this.env != null) {
            throw new IllegalStateException("Operation not allowed after calling create()");
        }
    }

    private void checkNonNull(Object param, String paramName) {
        if (param == null) {
            throw new NullPointerException("Parameter must not be null: " + paramName);
        }
    }
}

