/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader.rmi;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.Node;
import org.jboss.cache.TreeCacheMBean;
import org.jboss.cache.loader.rmi.RemoteTreeCache;

public class RemoteTreeCacheImpl
extends UnicastRemoteObject
implements RemoteTreeCache {
    private static final long serialVersionUID = 3096209368650710385L;
    private TreeCacheMBean cache;

    public RemoteTreeCacheImpl(TreeCacheMBean cache) throws RemoteException {
        this.cache = cache;
    }

    public Set getChildrenNames(Fqn fqn) throws Exception, RemoteException {
        return this.cache.getChildrenNames(fqn);
    }

    public Object get(Fqn name, Object key) throws Exception, RemoteException {
        return this.cache.get(name, key);
    }

    public Node get(Fqn name) throws Exception, RemoteException {
        return this.cache.get(name);
    }

    public boolean exists(Fqn name) throws Exception, RemoteException {
        return this.cache.exists(name);
    }

    public Object put(Fqn name, Object key, Object value) throws Exception, RemoteException {
        return this.cache.put(name, key, value);
    }

    public void put(Fqn name, Map attributes) throws Exception, RemoteException {
        this.cache.put(name, attributes);
    }

    public void put(List modifications) throws Exception, RemoteException {
        for (Modification m : modifications) {
            switch (m.getType()) {
                case 2: 
                case 3: {
                    this.cache.put(m.getFqn(), m.getData());
                    break;
                }
                case 1: {
                    this.cache.put(m.getFqn(), m.getKey(), m.getValue());
                    break;
                }
                case 6: {
                    this.cache.removeData(m.getFqn());
                    break;
                }
                case 5: {
                    this.cache.remove(m.getFqn(), m.getKey());
                    break;
                }
                case 4: {
                    this.cache.remove(m.getFqn());
                    break;
                }
                default: {
                    System.err.println("modification type " + m.getType() + " not known");
                }
            }
        }
    }

    public Object remove(Fqn name, Object key) throws Exception, RemoteException {
        return this.cache.remove(name, key);
    }

    public void remove(Fqn name) throws Exception, RemoteException {
        this.cache.remove(name);
    }

    public void removeData(Fqn name) throws Exception, RemoteException {
        this.cache.removeData(name);
    }
}

