/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import java.io.Serializable;
import java.util.Comparator;
import org.jboss.cache.Fqn;

public class FqnComparator
implements Comparator,
Serializable {
    static final long serialVersionUID = -102183636437493134L;
    public static final FqnComparator INSTANCE = new FqnComparator();

    public int compare(Object o1, Object o2) {
        Fqn fqn1 = (Fqn)o1;
        Fqn fqn2 = (Fqn)o2;
        int s1 = fqn1.size();
        int s2 = fqn2.size();
        if (s1 == 0) {
            return s2 == 0 ? 0 : -1;
        }
        if (s2 == 0) {
            return 1;
        }
        int size = Math.min(s1, s2);
        int i = 0;
        while (i < size) {
            Object e2;
            Object e1 = fqn1.get(i);
            if (e1 != (e2 = fqn2.get(i))) {
                int c;
                if (e1 == null) {
                    return 0;
                }
                if (e2 == null) {
                    return 1;
                }
                if (!e1.equals(e2) && (c = this.compareElements(e1, e2)) != 0) {
                    return c;
                }
            }
            ++i;
        }
        return s1 - s2;
    }

    protected int compareElements(Object e1, Object e2) {
        if (e1.getClass() == e2.getClass() && e1 instanceof Comparable) {
            return ((Comparable)e1).compareTo(e2);
        }
        return e1.toString().compareTo(e2.toString());
    }
}

