/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.statetransfer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.Version;
import org.jboss.cache.statetransfer.StateTransferGenerator;
import org.jboss.cache.statetransfer.StateTransferGenerator_123;
import org.jboss.cache.statetransfer.StateTransferGenerator_124;
import org.jboss.cache.statetransfer.StateTransferGenerator_1241;
import org.jboss.cache.statetransfer.StateTransferGenerator_140;
import org.jboss.cache.statetransfer.StateTransferIntegrator;
import org.jboss.cache.statetransfer.StateTransferIntegrator_123;
import org.jboss.cache.statetransfer.StateTransferIntegrator_124;
import org.jboss.cache.statetransfer.StateTransferIntegrator_1241;
import org.jboss.cache.statetransfer.StateTransferIntegrator_140;
import org.jboss.invocation.MarshalledValueInputStream;

public abstract class StateTransferFactory {
    private static final short RV_123 = Version.getVersionShort("1.2.3");
    private static final short RV_124 = Version.getVersionShort("1.2.4");
    private static final short RV_124SP1 = Version.getVersionShort("1.2.4.SP1");
    private static final short RV_140 = Version.getVersionShort("1.4.0");

    public static StateTransferGenerator getStateTransferGenerator(TreeCache cache) {
        short version = cache.getReplicationVersionShort();
        if (version == RV_124) {
            return new StateTransferGenerator_124(cache);
        }
        if (version == RV_124SP1) {
            return new StateTransferGenerator_1241(cache);
        }
        if (version <= RV_123 && version > 0) {
            return new StateTransferGenerator_123(cache);
        }
        if (version < RV_140 && version > 0) {
            return new StateTransferGenerator_1241(cache);
        }
        return new StateTransferGenerator_140(cache);
    }

    public static StateTransferIntegrator getStateTransferIntegrator(byte[] state, Fqn targetFqn, TreeCache cache) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(state);
        bais.mark(1024);
        short version = 0;
        MarshalledValueInputStream in = new MarshalledValueInputStream((InputStream)bais);
        try {
            try {
                version = in.readShort();
            }
            catch (IOException io) {
                version = RV_123;
            }
            if (version == RV_124) {
                StateTransferIntegrator_124 stateTransferIntegrator_124 = new StateTransferIntegrator_124((ObjectInputStream)in, targetFqn, cache);
                return stateTransferIntegrator_124;
            }
            if (version == RV_124SP1) {
                StateTransferIntegrator_1241 stateTransferIntegrator_1241 = new StateTransferIntegrator_1241(state, targetFqn, cache);
                return stateTransferIntegrator_1241;
            }
            if (version <= RV_123 && version > 0) {
                StateTransferIntegrator_123 stateTransferIntegrator_123 = new StateTransferIntegrator_123(state, targetFqn, cache);
                return stateTransferIntegrator_123;
            }
            if (version < RV_140 && version > 0) {
                StateTransferIntegrator_1241 stateTransferIntegrator_1241 = new StateTransferIntegrator_1241(state, targetFqn, cache);
                return stateTransferIntegrator_1241;
            }
            StateTransferIntegrator_140 stateTransferIntegrator_140 = new StateTransferIntegrator_140(state, targetFqn, cache);
            return stateTransferIntegrator_140;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }
}

