/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.statetransfer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.DataNode;
import org.jboss.cache.TreeCache;
import org.jboss.cache.statetransfer.StateTransferGenerator;
import org.jgroups.util.Util;

class StateTransferGenerator_123
implements StateTransferGenerator {
    private Log log = LogFactory.getLog((String)this.getClass().getName());
    private TreeCache cache;

    StateTransferGenerator_123(TreeCache cache) {
        this.cache = cache;
    }

    public byte[] generateStateTransfer(DataNode rootNode, boolean generateTransient, boolean generatePersistent, boolean suppressErrors) throws Throwable {
        if (rootNode.getFqn().size() > 0) {
            throw new IllegalArgumentException("Invalid node " + rootNode.getFqn() + " -- StateTransferVersion 123 only supports " + "transferring  FQN '/'");
        }
        byte[] transient_state = null;
        byte[] persistent_state = null;
        byte[][] states = new byte[2][];
        byte[] retval = null;
        states[1] = null;
        states[0] = null;
        try {
            if (generateTransient) {
                this.log.info((Object)"locking the tree to obtain transient state");
                states[0] = transient_state = Util.objectToByteBuffer((Object)rootNode);
                this.log.info((Object)("returning the transient state (" + transient_state.length + " bytes)"));
            }
        }
        catch (Throwable t) {
            this.log.error((Object)"failed getting the transient state", t);
        }
        try {
            if (generatePersistent) {
                this.log.info((Object)"getting the persistent state");
                states[1] = persistent_state = this.cache.getCacheLoader().loadEntireState();
                this.log.info((Object)("returning the persistent state (" + persistent_state.length + " bytes)"));
            }
        }
        catch (Throwable t) {
            this.log.error((Object)"failed getting the persistent state", t);
        }
        try {
            retval = Util.objectToByteBuffer((Object)states);
        }
        catch (Throwable t) {
            this.log.error((Object)"failed serializing transient and persistent state", t);
        }
        return retval;
    }
}

