/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.statetransfer;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeNode;
import org.jboss.cache.aop.InternalDelegate;
import org.jboss.cache.aop.PojoCache;
import org.jboss.cache.factories.NodeFactory;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.ExtendedCacheLoader;
import org.jboss.cache.loader.NodeData;
import org.jboss.cache.statetransfer.StateTransferIntegrator;
import org.jboss.invocation.MarshalledValueInputStream;

class StateTransferIntegrator_124
implements StateTransferIntegrator {
    private Log log = LogFactory.getLog((String)this.getClass().getName());
    private TreeCache cache;
    private Fqn targetFqn;
    private byte[] transient_state;
    private byte[] associated_state;
    private byte[] persistent_state;
    private boolean transientSet;
    private NodeFactory factory;
    private byte nodeType;

    StateTransferIntegrator_124(ObjectInputStream state, Fqn targetFqn, TreeCache cache) throws Exception {
        this.targetFqn = targetFqn;
        this.cache = cache;
        this.factory = NodeFactory.getInstance();
        this.nodeType = (byte)(cache.isNodeLockingOptimistic() ? 3 : 1);
        byte[][] states = (byte[][])state.readObject();
        this.transient_state = states[0];
        this.associated_state = states[1];
        this.persistent_state = states[2];
        if (this.log.isTraceEnabled()) {
            if (this.transient_state != null) {
                this.log.trace((Object)("transient state: " + this.transient_state.length + " bytes"));
            }
            if (this.associated_state != null) {
                this.log.trace((Object)("associated state: " + this.associated_state.length + " bytes"));
            }
            if (this.persistent_state != null) {
                this.log.trace((Object)("persistent state: " + this.persistent_state.length + " bytes"));
            }
        }
    }

    public void integrateTransientState(DataNode target, ClassLoader cl) throws Exception {
        if (this.transient_state != null) {
            ClassLoader oldCL = null;
            try {
                if (cl != null) {
                    oldCL = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(cl);
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("integrating transient state for " + target));
                }
                this.integrateStateTransfer(target, this.transient_state);
                this.transientSet = true;
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("transient state successfully integrated for " + this.targetFqn));
                }
                this.integrateAssociatedState();
            }
            finally {
                if (!this.transientSet) {
                    target.clear();
                    target.removeAllChildren();
                }
                if (oldCL != null) {
                    Thread.currentThread().setContextClassLoader(oldCL);
                }
            }
        }
    }

    private void integrateAssociatedState() throws Exception {
        if (this.associated_state != null && this.cache instanceof PojoCache) {
            Node refMapNode = this.cache.get(InternalDelegate.JBOSS_INTERNAL_MAP);
            ByteArrayInputStream in_stream = new ByteArrayInputStream(this.associated_state);
            MarshalledValueInputStream in = new MarshalledValueInputStream((InputStream)in_stream);
            try {
                Object[] nameValue;
                while ((nameValue = (Object[])in.readObject()) != null) {
                    TreeNode target = refMapNode.getChild(nameValue[0]);
                    if (target == null) {
                        Fqn fqn = new Fqn(InternalDelegate.JBOSS_INTERNAL_MAP, nameValue[0]);
                        target = this.factory.createDataNode(this.nodeType, nameValue[0], fqn, (DataNode)refMapNode, null, true, this.cache);
                        refMapNode.addChild(nameValue[0], target);
                    }
                    target.put(nameValue[0], nameValue[1]);
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("associated state successfully integrated for " + this.targetFqn));
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("No need to integrate associated state for " + this.targetFqn));
        }
    }

    public void integratePersistentState() throws Exception {
        if (this.persistent_state != null) {
            CacheLoader loader = this.cache.getCacheLoader();
            if (loader == null) {
                this.log.error((Object)"cache loader is null, cannot set persistent state");
            } else if (this.targetFqn.size() == 0) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"setting the persistent state");
                }
                loader.storeEntireState(this.persistent_state);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"setting the persistent state was successful");
                }
            } else if (loader instanceof ExtendedCacheLoader) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"setting the persistent state");
                }
                ((ExtendedCacheLoader)loader).storeState(this.persistent_state, this.targetFqn);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"setting the persistent state was successful");
                }
            } else {
                this.log.error((Object)"cache loader does not implement ExtendedCacheLoader, cannot set persistent state");
            }
        }
    }

    private void integrateStateTransfer(DataNode target, byte[] transient_state) throws IOException, ClassNotFoundException {
        target.removeAllChildren();
        ByteArrayInputStream in_stream = new ByteArrayInputStream(transient_state);
        MarshalledValueInputStream in = new MarshalledValueInputStream((InputStream)in_stream);
        NodeData nd = (NodeData)in.readObject();
        Map attrs = nd.getAttributes();
        if (attrs != null) {
            target.put(attrs, true);
        } else {
            target.clear();
        }
        this.integrateStateTransferChildren(target, (ObjectInputStream)in);
        in.close();
    }

    private NodeData integrateStateTransferChildren(DataNode parent, ObjectInputStream in) throws IOException, ClassNotFoundException {
        int parent_level = parent.getFqn().size();
        int target_level = parent_level + 1;
        try {
            NodeData nd = (NodeData)in.readObject();
            while (nd != null) {
                Fqn fqn = nd.getFqn();
                int size = fqn.size();
                if (size <= parent_level) {
                    return nd;
                }
                if (size > target_level) {
                    throw new IllegalStateException("NodeData " + fqn + " is not a direct child of " + parent.getFqn());
                }
                Object name = fqn.get(size - 1);
                DataNode target = this.factory.createDataNode(this.nodeType, name, fqn, parent, nd.getAttributes(), true, this.cache);
                parent.addChild(name, target);
                nd = this.integrateStateTransferChildren(target, in);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return null;
    }
}

