/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util;

import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.BaseInterceptor;
import org.jboss.cache.interceptors.Interceptor;

public class MBeanConfigurator {
    private static final String MBEAN_CLASS_SUFFIX = "MBean";
    private static final String MBEAN_KEY = ",treecache-interceptor=";
    private static final String PREFIX = "jboss.cache:service=";

    public static void registerInterceptors(MBeanServer server, TreeCache cache, boolean registerCache) throws Exception {
        ObjectName tmpObj;
        String tmpName;
        if (server == null || cache == null) {
            return;
        }
        List interceptors = cache.getInterceptors();
        Interceptor interceptor = null;
        String string = tmpName = cache.getServiceName() != null ? cache.getServiceName().toString() : null;
        if (tmpName == null) {
            tmpName = PREFIX + cache.getClusterName();
            if (cache.getClusterName() == null) {
                tmpName = PREFIX + cache.getClass().getName() + System.currentTimeMillis();
            }
        }
        if (registerCache && !server.isRegistered(tmpObj = new ObjectName(tmpName))) {
            server.registerMBean(cache, tmpObj);
        }
        int i = 0;
        while (i < interceptors.size()) {
            interceptor = (Interceptor)interceptors.get(i);
            boolean mbeanExists = true;
            try {
                Class.forName(String.valueOf(interceptor.getClass().getName()) + MBEAN_CLASS_SUFFIX);
            }
            catch (Throwable e) {
                mbeanExists = false;
            }
            String className = interceptor.getClass().getName();
            String serviceName = String.valueOf(tmpName) + MBEAN_KEY + className.substring(className.lastIndexOf(46) + 1);
            ObjectName objName = new ObjectName(serviceName);
            if (!server.isRegistered(objName)) {
                if (mbeanExists) {
                    server.registerMBean(interceptor, objName);
                } else {
                    server.registerMBean(new BaseInterceptor(), objName);
                }
            }
            ++i;
        }
    }

    public static void unregisterInterceptors(MBeanServer server, TreeCache cache, boolean unregisterCache) throws Exception {
        ObjectName tmpObj;
        String tmpName;
        if (server == null || cache == null) {
            return;
        }
        List interceptors = cache.getInterceptors();
        Interceptor interceptor = null;
        String string = tmpName = cache.getServiceName() != null ? cache.getServiceName().toString() : null;
        if (tmpName == null) {
            tmpName = PREFIX + cache.getClusterName();
            if (cache.getClusterName() == null) {
                tmpName = PREFIX + cache.getClass().getName() + System.currentTimeMillis();
            }
        }
        int i = 0;
        while (i < interceptors.size()) {
            interceptor = (Interceptor)interceptors.get(i);
            String className = interceptor.getClass().getName();
            String serviceName = String.valueOf(tmpName) + MBEAN_KEY + className.substring(className.lastIndexOf(46) + 1);
            ObjectName objName = new ObjectName(serviceName);
            if (server.isRegistered(objName)) {
                server.unregisterMBean(objName);
            }
            ++i;
        }
        if (unregisterCache && server.isRegistered(tmpObj = new ObjectName(tmpName))) {
            server.unregisterMBean(tmpObj);
        }
    }
}

