/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlHelper {
    public static String getAttr(Element elem, String myName, String tagName, String attributeName) {
        NodeList list = elem.getElementsByTagName(tagName);
        int s = 0;
        while (s < list.getLength()) {
            Element element;
            String name;
            Node node = list.item(s);
            if (node.getNodeType() == 1 && (name = (element = (Element)node).getAttribute(attributeName)).equals(myName)) {
                String valueStr = XmlHelper.getElementContent(element, true);
                return valueStr;
            }
            ++s;
        }
        return null;
    }

    public static String getElementContent(Element element, boolean trim) {
        NodeList nl = element.getChildNodes();
        String attributeText = "";
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n instanceof Text) {
                attributeText = String.valueOf(attributeText) + ((Text)n).getData();
            }
            ++i;
        }
        if (trim) {
            attributeText = attributeText.trim();
        }
        return attributeText;
    }

    public static String readStringContents(Element element, String tagName) {
        NodeList nodes = element.getElementsByTagName(tagName);
        if (nodes.getLength() > 0) {
            Node node = nodes.item(0);
            Element ne = (Element)node;
            NodeList nl2 = ne.getChildNodes();
            Node node2 = nl2.item(0);
            if (node2 != null) {
                String value = node2.getNodeValue();
                if (value == null) {
                    return "";
                }
                return value.trim();
            }
            return "";
        }
        return "";
    }

    public static String escapeBackslashes(String value) {
        StringBuffer buf = new StringBuffer(value);
        int looper = 0;
        while (looper < buf.length()) {
            char curr = buf.charAt(looper);
            char next = '\u0000';
            if (looper + 1 < buf.length()) {
                next = buf.charAt(looper + 1);
            }
            if (curr == '\\') {
                if (next != '\\') {
                    buf.insert(looper, '\\');
                }
                ++looper;
            }
            ++looper;
        }
        return buf.toString();
    }

    public static Properties readPropertiesContents(Element element, String tagName) throws IOException {
        String stringContents = XmlHelper.readStringContents(element, tagName);
        if (stringContents == null) {
            return new Properties();
        }
        stringContents = XmlHelper.escapeBackslashes(stringContents);
        ByteArrayInputStream is = new ByteArrayInputStream(stringContents.trim().getBytes("ISO8859_1"));
        Properties properties = new Properties();
        properties.load(is);
        is.close();
        return properties;
    }

    public static boolean readBooleanContents(Element element, String tagName) {
        return XmlHelper.readBooleanContents(element, tagName, false);
    }

    public static boolean readBooleanContents(Element element, String tagName, boolean defaultValue) {
        String val = XmlHelper.readStringContents(element, tagName);
        if (val.equalsIgnoreCase("true") || val.equalsIgnoreCase("false")) {
            return Boolean.valueOf(val);
        }
        return defaultValue;
    }

    public static Element stringToElement(String xml) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes("utf8"));
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document d = builder.parse(bais);
        bais.close();
        return d.getDocumentElement();
    }
}

