/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.sockets;

import EDU.oswego.cs.dl.util.concurrent.FIFOSemaphore;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;

public class QueuedClientSocketFactory
implements RMIClientSocketFactory,
Externalizable {
    private transient FIFOSemaphore permits;
    private long numPermits;

    public QueuedClientSocketFactory() {
    }

    public QueuedClientSocketFactory(long nPermits) {
        this.permits = new FIFOSemaphore(nPermits);
        this.numPermits = nPermits;
    }

    public Socket createSocket(String host, int port) throws IOException {
        Socket socket;
        try {
            this.permits.acquire();
            socket = new Socket(host, port);
            Object var5_5 = null;
        }
        catch (InterruptedException ex) {
            try {
                throw new IOException("Failed to acquire FIFOSemaphore for ClientSocketFactory");
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.permits.release();
                throw throwable;
            }
        }
        this.permits.release();
        return socket;
    }

    public boolean equals(Object obj) {
        return obj instanceof QueuedClientSocketFactory;
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.numPermits);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.numPermits = in.readLong();
        this.permits = new FIFOSemaphore(this.numPermits);
    }
}

