/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Method;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class MethodHashing {
    static Map hashMap = new WeakHashMap();

    public static Method findMethodByHash(Class clazz, long hash) throws Exception {
        Method[] methods = clazz.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (MethodHashing.methodHash(methods[i]) == hash) {
                return methods[i];
            }
            ++i;
        }
        if (clazz.getSuperclass() != null) {
            return MethodHashing.findMethodByHash(clazz.getSuperclass(), hash);
        }
        return null;
    }

    public static long methodHash(Method method) throws Exception {
        Class<?>[] parameterTypes = method.getParameterTypes();
        String methodDesc = method.getName() + "(";
        int j = 0;
        while (j < parameterTypes.length) {
            methodDesc = methodDesc + MethodHashing.getTypeString(parameterTypes[j]);
            ++j;
        }
        methodDesc = methodDesc + ")" + MethodHashing.getTypeString(method.getReturnType());
        long hash = 0L;
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
        MessageDigest messagedigest = MessageDigest.getInstance("SHA");
        DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
        dataoutputstream.writeUTF(methodDesc);
        dataoutputstream.flush();
        byte[] abyte0 = messagedigest.digest();
        int j2 = 0;
        while (j2 < Math.min(8, abyte0.length)) {
            hash += (long)(abyte0[j2] & 0xFF) << j2 * 8;
            ++j2;
        }
        return hash;
    }

    public static Map getInterfaceHashes(Class intf) {
        Method[] methods = intf.getDeclaredMethods();
        HashMap<String, Long> map = new HashMap<String, Long>();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            try {
                long hash = MethodHashing.methodHash(method);
                map.put(method.toString(), new Long(hash));
            }
            catch (Exception e) {
                // empty catch block
            }
            ++i;
        }
        return map;
    }

    static String getTypeString(Class cl) {
        if (cl == Byte.TYPE) {
            return "B";
        }
        if (cl == Character.TYPE) {
            return "C";
        }
        if (cl == Double.TYPE) {
            return "D";
        }
        if (cl == Float.TYPE) {
            return "F";
        }
        if (cl == Integer.TYPE) {
            return "I";
        }
        if (cl == Long.TYPE) {
            return "J";
        }
        if (cl == Short.TYPE) {
            return "S";
        }
        if (cl == Boolean.TYPE) {
            return "Z";
        }
        if (cl == Void.TYPE) {
            return "V";
        }
        if (cl.isArray()) {
            return "[" + MethodHashing.getTypeString(cl.getComponentType());
        }
        return "L" + cl.getName().replace('.', '/') + ";";
    }

    public static long calculateHash(Method method) {
        Map methodHashes = (Map)hashMap.get(method.getDeclaringClass());
        if (methodHashes == null) {
            methodHashes = MethodHashing.getInterfaceHashes(method.getDeclaringClass());
            WeakHashMap newHashMap = new WeakHashMap();
            newHashMap.putAll(hashMap);
            newHashMap.put(method.getDeclaringClass(), methodHashes);
            hashMap = newHashMap;
        }
        return (Long)methodHashes.get(method.toString());
    }
}

