/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.Stack;
import org.jboss.logging.Logger;
import org.jboss.util.collection.Iterators;

public class TCLStack {
    private static final Logger log = Logger.getLogger(class$org$jboss$util$TCLStack == null ? (class$org$jboss$util$TCLStack = TCLStack.class$("org.jboss.util.TCLStack")) : class$org$jboss$util$TCLStack);
    private static final ThreadLocal stackTL = new ThreadLocal(){

        protected Object initialValue() {
            return new Stack();
        }
    };
    static /* synthetic */ Class class$org$jboss$util$TCLStack;

    private static Stack getStack() {
        return (Stack)stackTL.get();
    }

    public static void push(ClassLoader cl) {
        boolean trace = log.isTraceEnabled();
        Thread currentThread = Thread.currentThread();
        ClassLoader oldCL = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(cl);
        TCLStack.getStack().push(oldCL);
        if (trace) {
            log.trace("Setting TCL to " + cl + "; pushing " + oldCL);
            log.trace("Stack: " + TCLStack.getStack());
        }
    }

    public static ClassLoader pop() {
        try {
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = (ClassLoader)TCLStack.getStack().pop();
            ClassLoader oldCL = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(cl);
            if (log.isTraceEnabled()) {
                log.trace("Setting TCL to " + cl + "; popped: " + oldCL);
                log.trace("Stack: " + TCLStack.getStack());
            }
            return oldCL;
        }
        catch (EmptyStackException ignore) {
            log.warn("Attempt to pop empty stack ingored", ignore);
            return null;
        }
    }

    public static int size() {
        return TCLStack.getStack().size();
    }

    public static Iterator iterator() {
        return Iterators.makeImmutable(TCLStack.getStack().iterator());
    }

    public static ClassLoader get(int index) throws ArrayIndexOutOfBoundsException {
        return (ClassLoader)TCLStack.getStack().get(index);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

