/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ReferenceCache<K, V> {
    private final ConcurrentMap<ReferenceKey<K>, Future<ReferenceValue<V>>> cache;
    private final ReferenceFactory keyFactory;
    private final ReferenceFactory valueFactory;
    private final ReferenceFactory lookupFactory;
    private final ReferenceQueueRunner queue;

    public ReferenceCache(Type keyType, Type valueType) {
        this(keyType, valueType, 0);
    }

    public ReferenceCache(Type keyType, Type valueType, int initialSize) {
        this.keyFactory = this.toFactory(keyType);
        this.valueFactory = this.toFactory(valueType);
        this.lookupFactory = new StrongReferenceFactory();
        this.cache = new ConcurrentHashMap<ReferenceKey<K>, Future<ReferenceValue<V>>>(initialSize);
        this.queue = new ReferenceQueueRunner();
        Thread t = new Thread(this.queue);
        t.setDaemon(true);
        t.start();
    }

    private final ReferenceFactory<K, V> toFactory(Type type) {
        switch (type) {
            case Strong: {
                return new StrongReferenceFactory();
            }
            case Weak: {
                return new WeakReferenceFactory();
            }
            case Soft: {
                return new SoftReferenceFactory();
            }
        }
        throw new IllegalArgumentException("Invalid ReferenceType: " + (Object)((Object)type));
    }

    protected abstract V create(K var1);

    public V get(final Object key) {
        try {
            ReferenceKey<Object> refKey = this.lookupFactory.createKey(this.queue, key);
            Future<ReferenceValue<V>> f = (FutureTask<ReferenceValue<V>>)this.cache.get(refKey);
            V result = this.dereferenceValue(f);
            if (result == null) {
                Callable call = new Callable(){

                    public ReferenceValue<V> call() throws Exception {
                        Object created = ReferenceCache.this.create(key);
                        if (created != null) {
                            return ReferenceCache.this.valueFactory.createValue(ReferenceCache.this.queue, created);
                        }
                        return null;
                    }
                };
                FutureTask<ReferenceValue<V>> task = new FutureTask<ReferenceValue<V>>(call);
                refKey = this.keyFactory.createKey(this.queue, key);
                f = this.cache.putIfAbsent(refKey, task);
                if (f == null) {
                    f = task;
                    task.run();
                } else {
                    System.out.println(f + " value: " + this.dereferenceValue(f));
                }
                result = this.dereferenceValue(f);
            }
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private V dereferenceValue(ReferenceValue<V> refValue) {
        return refValue == null ? null : (V)refValue.get();
    }

    private V dereferenceValue(Future<ReferenceValue<V>> futureValue) {
        try {
            return futureValue == null ? null : (V)this.dereferenceValue(futureValue.get());
        }
        catch (Exception e) {
            return null;
        }
    }

    public V put(K key, final V value) {
        Callable call;
        FutureTask task;
        ReferenceKey<K> refKey = this.keyFactory.createKey(this.queue, key);
        FutureTask f = this.cache.putIfAbsent(refKey, task = new FutureTask(call = new Callable(){

            public ReferenceValue<V> call() throws Exception {
                return ReferenceCache.this.valueFactory.createValue(ReferenceCache.this.queue, value);
            }
        }));
        if (f == null) {
            f = task;
            task.run();
        }
        return value;
    }

    public V remove(Object key) {
        ReferenceKey<Object> keyRef = this.lookupFactory.createKey(this.queue, key);
        return this.dereferenceValue((Future)this.cache.remove(keyRef));
    }

    public int size() {
        return this.cache.size();
    }

    public void clear() {
        this.cache.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        Strong,
        Weak,
        Soft;

    }

    private class ReferenceQueueRunner
    extends ReferenceQueue
    implements Runnable {
        private ReferenceQueueRunner() {
        }

        public void run() {
            Reference ref = null;
            while (true) {
                try {
                    while (true) {
                        if ((ref = this.remove()) == null) {
                            continue;
                        }
                        ref.clear();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ReferenceValue<V> {
        public V get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class ReferenceKey<K> {
        private final int hashCode;

        public ReferenceKey(K key) {
            this.hashCode = key.hashCode();
        }

        protected abstract K get();

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            K me = this.get();
            if (me != null) {
                if (obj == me) {
                    return true;
                }
                if (obj instanceof ReferenceKey) {
                    K them = ((ReferenceKey)obj).get();
                    return me == them || me.equals(them);
                }
            }
            return false;
        }

        public void remove() {
            ReferenceCache.this.cache.remove(this);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SoftReferenceFactory
    extends ReferenceFactory<K, V> {
        private SoftReferenceFactory() {
        }

        @Override
        public ReferenceValue<V> createValue(final ReferenceQueue queue, final V value) {
            return new ReferenceValue<V>(){
                private final SoftReference<V> ref;
                {
                    this.ref = new SoftReference<Object>(value, queue);
                }

                @Override
                public V get() {
                    return this.ref.get();
                }
            };
        }

        @Override
        public ReferenceKey<K> createKey(ReferenceQueue queue, K key) {
            return new SoftReferenceKey(queue, key);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class SoftReferenceKey
        extends ReferenceKey<K> {
            private final SoftReference<K> ref;

            public SoftReferenceKey(ReferenceQueue queue, K key) {
                super(key);
                this.ref = new SoftReference<K>(key, queue){

                    @Override
                    public void clear() {
                        SoftReferenceKey.this.remove();
                        super.clear();
                    }
                };
            }

            @Override
            public K get() {
                return this.ref.get();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WeakReferenceFactory
    extends ReferenceFactory<K, V> {
        private WeakReferenceFactory() {
        }

        @Override
        public ReferenceValue<V> createValue(final ReferenceQueue queue, final V value) {
            return new ReferenceValue<V>(){
                private final WeakReference<V> ref;
                {
                    this.ref = new WeakReference<Object>(value, queue);
                }

                @Override
                public V get() {
                    return this.ref.get();
                }
            };
        }

        @Override
        public ReferenceKey<K> createKey(ReferenceQueue queue, K key) {
            return new WeakReferenceKey(queue, key);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class WeakReferenceKey
        extends ReferenceKey<K> {
            private final WeakReference<K> ref;

            public WeakReferenceKey(ReferenceQueue queue, K key) {
                super(key);
                this.ref = new WeakReference<K>(key, queue){

                    @Override
                    public void clear() {
                        WeakReferenceKey.this.remove();
                        super.clear();
                    }
                };
            }

            @Override
            public K get() {
                return this.ref.get();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StrongReferenceFactory
    extends ReferenceFactory<K, V> {
        private StrongReferenceFactory() {
        }

        @Override
        public ReferenceValue<V> createValue(ReferenceQueue queue, final V value) {
            return new ReferenceValue<V>(){

                @Override
                public V get() {
                    return value;
                }
            };
        }

        @Override
        public ReferenceKey<K> createKey(ReferenceQueue queue, final K key) {
            return new ReferenceKey<K>(key){

                @Override
                public K get() {
                    return key;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class ReferenceFactory<K, V> {
        public abstract ReferenceKey<K> createKey(ReferenceQueue var1, K var2);

        public abstract ReferenceValue<V> createValue(ReferenceQueue var1, V var2);
    }
}

