/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import EDU.oswego.cs.dl.util.concurrent.ReentrantLock;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.ClassLoadingTask;
import org.jboss.mx.loading.ClassToStringAction;
import org.jboss.mx.loading.LoadMgr3;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.loading.UnifiedLoaderRepository3;
import org.jboss.util.collection.SoftSet;
import org.jboss.util.loading.Translator;

public abstract class RepositoryClassLoader
extends URLClassLoader {
    private static final Logger log = Logger.getLogger(RepositoryClassLoader.class);
    private static final URL[] EMPTY_URL_ARRAY = new URL[0];
    protected LoaderRepository repository = null;
    protected Exception unregisterTrace;
    private int addedOrder;
    protected ClassLoader parent = null;
    private Set classBlackList = Collections.synchronizedSet(new HashSet());
    private Set resourceBlackList = Collections.synchronizedSet(new HashSet());
    private ConcurrentReaderHashMap resourceCache = new ConcurrentReaderHashMap();
    protected ReentrantLock loadLock = new ReentrantLock();
    private int loadClassDepth;

    protected RepositoryClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.parent = parent;
        String mode = ClassToStringAction.getProperty("org.jboss.mx.loading.blacklistMode", null);
        if (mode == null || mode.equalsIgnoreCase("HashSet")) {
            this.classBlackList = Collections.synchronizedSet(new HashSet());
            this.resourceBlackList = Collections.synchronizedSet(new HashSet());
        } else if (mode.equalsIgnoreCase("SoftSet")) {
            this.classBlackList = Collections.synchronizedSet(new SoftSet());
            this.resourceBlackList = Collections.synchronizedSet(new SoftSet());
        }
    }

    public abstract ObjectName getObjectName() throws MalformedObjectNameException;

    public LoaderRepository getLoaderRepository() {
        return this.repository;
    }

    public void setRepository(LoaderRepository repository) {
        log.debug((Object)("setRepository, repository=" + repository + ", cl=" + this));
        this.repository = repository;
    }

    public int getAddedOrder() {
        return this.addedOrder;
    }

    public void setAddedOrder(int addedOrder) {
        this.addedOrder = addedOrder;
    }

    public Class loadClassLocally(String name, boolean resolve) throws ClassNotFoundException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("loadClassLocally, " + this + " name=" + name));
        }
        if (name == null || name.length() == 0) {
            throw new ClassNotFoundException("Null or empty class name");
        }
        Class<?> result = null;
        try {
            if (this.isClassBlackListed(name)) {
                if (trace) {
                    log.trace((Object)("Class in blacklist, name=" + name));
                }
                throw new ClassNotFoundException("Class Not Found(blacklist): " + name);
            }
            try {
                Class<?> clazz = result = super.loadClass(name, resolve);
                return clazz;
            }
            catch (ClassNotFoundException cnfe) {
                block15: {
                    Class<?> clazz;
                    block16: {
                        block17: {
                            this.addToClassBlackList(name);
                            if (name.charAt(0) != '[') break block15;
                            result = Class.forName(name, true, this);
                            this.removeFromClassBlackList(name);
                            clazz = result;
                            if (!trace) break block16;
                            if (result == null) break block17;
                            log.trace((Object)("loadClassLocally, " + this + " name=" + name + " class=" + result + " cl=" + result.getClassLoader()));
                            break block16;
                        }
                        log.trace((Object)("loadClassLocally, " + this + " name=" + name + " not found"));
                    }
                    return clazz;
                }
                if (trace) {
                    log.trace((Object)("CFNE: Adding to blacklist: " + name));
                }
                throw cnfe;
            }
        }
        finally {
            if (trace) {
                if (result != null) {
                    log.trace((Object)("loadClassLocally, " + this + " name=" + name + " class=" + result + " cl=" + result.getClassLoader()));
                } else {
                    log.trace((Object)("loadClassLocally, " + this + " name=" + name + " not found"));
                }
            }
        }
    }

    public URL getResourceLocally(String name) {
        URL resURL = (URL)this.resourceCache.get((Object)name);
        if (resURL != null) {
            return resURL;
        }
        if (this.isResourceBlackListed(name)) {
            return null;
        }
        resURL = super.getResource(name);
        if (log.isTraceEnabled()) {
            log.trace((Object)("getResourceLocally(" + this + "), name=" + name + ", resURL:" + resURL));
        }
        if (resURL == null) {
            this.addToResourceBlackList(name);
        } else {
            this.resourceCache.put((Object)name, (Object)resURL);
        }
        return resURL;
    }

    public URL getURL() {
        URL[] urls = super.getURLs();
        if (urls.length > 0) {
            return urls[0];
        }
        return null;
    }

    public void unregister() {
        log.debug((Object)("Unregistering cl=" + this));
        if (this.repository != null) {
            this.repository.removeClassLoader(this);
        }
        this.clearBlackLists();
        this.resourceCache.clear();
        this.repository = null;
        this.unregisterTrace = new Exception();
    }

    public URL[] getClasspath() {
        return super.getURLs();
    }

    public URL[] getAllURLs() {
        return this.repository.getURLs();
    }

    public void addToClassBlackList(String name) {
        this.classBlackList.add(name);
    }

    public void removeFromClassBlackList(String name) {
        this.classBlackList.remove(name);
    }

    public boolean isClassBlackListed(String name) {
        return this.classBlackList.contains(name);
    }

    public void clearClassBlackList() {
        this.classBlackList.clear();
    }

    public void addToResourceBlackList(String name) {
        this.resourceBlackList.add(name);
    }

    public void removeFromResourceBlackList(String name) {
        this.resourceBlackList.remove(name);
    }

    public boolean isResourceBlackListed(String name) {
        return this.resourceBlackList.contains(name);
    }

    public void clearResourceBlackList() {
        this.resourceBlackList.clear();
    }

    public void clearBlackLists() {
        this.clearClassBlackList();
        this.clearResourceBlackList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("loadClass " + this + " name=" + name + ", loadClassDepth=" + this.loadClassDepth));
        }
        Class clazz = null;
        try {
            if (this.repository != null && (clazz = this.repository.getCachedClass(name)) != null) {
                if (log.isTraceEnabled()) {
                    StringBuffer buffer = new StringBuffer("Loaded class from cache, ");
                    ClassToStringAction.toString(clazz, buffer);
                    log.trace((Object)buffer.toString());
                }
                Class clazz2 = clazz;
                return clazz2;
            }
            Class clazz3 = clazz = this.loadClassImpl(name, resolve, Integer.MAX_VALUE);
            return clazz3;
        }
        finally {
            if (trace) {
                if (clazz != null) {
                    log.trace((Object)("loadClass " + this + " name=" + name + " class=" + clazz + " cl=" + clazz.getClassLoader()));
                } else {
                    log.trace((Object)("loadClass " + this + " name=" + name + " not found"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClassBefore(String name) throws ClassNotFoundException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("loadClassBefore " + this + " name=" + name));
        }
        Class clazz = null;
        try {
            Class clazz2 = clazz = this.loadClassImpl(name, false, this.addedOrder);
            return clazz2;
        }
        finally {
            if (trace) {
                if (clazz != null) {
                    log.trace((Object)("loadClassBefore " + this + " name=" + name + " class=" + clazz + " cl=" + clazz.getClassLoader()));
                } else {
                    log.trace((Object)("loadClassBefore " + this + " name=" + name + " not found"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Class loadClassImpl(String name, boolean resolve, int stopAt) throws ClassNotFoundException {
        ClassLoadingTask task;
        block21: {
            ++this.loadClassDepth;
            boolean trace = log.isTraceEnabled();
            if (trace) {
                log.trace((Object)("loadClassImpl, name=" + name + ", resolve=" + resolve));
            }
            if (this.repository == null) {
                try {
                    return super.loadClass(name, resolve);
                }
                catch (ClassNotFoundException ignored) {
                    String msg = "Invalid use of destroyed classloader, UCL destroyed at:";
                    throw new ClassNotFoundException(msg, this.unregisterTrace);
                }
            }
            boolean acquired = this.attempt(1L);
            while (!acquired) {
                try {
                    if (trace) {
                        log.trace((Object)"Waiting for loadClass lock");
                    }
                    this.wait();
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                acquired = this.attempt(1L);
            }
            task = null;
            try {
                UnifiedLoaderRepository3 ulr3;
                Thread t = Thread.currentThread();
                if (this.loadLock.holds() == 1L) {
                    LoadMgr3.registerLoaderThread(this, t);
                }
                if (LoadMgr3.beginLoadTask(task = new ClassLoadingTask(name, this, t, stopAt), ulr3 = (UnifiedLoaderRepository3)this.repository)) break block21;
                while (task.threadTaskCount != 0) {
                    try {
                        LoadMgr3.nextTask(t, task, ulr3);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                if (this.loadLock.holds() == 1L) {
                    LoadMgr3.endLoadTask(task);
                }
                this.release();
                this.notifyAll();
                --this.loadClassDepth;
                throw throwable;
            }
        }
        if (this.loadLock.holds() == 1L) {
            LoadMgr3.endLoadTask(task);
        }
        this.release();
        this.notifyAll();
        --this.loadClassDepth;
        if (task.loadedClass != null) {
            return task.loadedClass;
        }
        if (task.loadException instanceof ClassNotFoundException) {
            throw (ClassNotFoundException)task.loadException;
        }
        if (task.loadException instanceof NoClassDefFoundError) {
            throw (NoClassDefFoundError)task.loadException;
        }
        if (task.loadException == null) {
            throw new IllegalStateException("ClassLoadingTask.loadedTask is null, name: " + name);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Unexpected error during load of:" + name), task.loadException);
        }
        String msg = "Unexpected error during load of: " + name + ", msg=" + task.loadException.getMessage();
        ClassNotFoundException cnfe = new ClassNotFoundException(msg, task.loadException);
        throw cnfe;
    }

    public URL getResource(String name) {
        if (this.repository != null) {
            return this.repository.getResource(name, this);
        }
        return null;
    }

    public Enumeration findResources(String name) throws IOException {
        Vector resURLs = new Vector();
        if (this.repository == null) {
            String msg = "Invalid use of destroyed classloader, UCL destroyed at:";
            IOException e = new IOException(msg);
            e.initCause(this.unregisterTrace);
            throw e;
        }
        this.repository.getResources(name, this, resURLs);
        return resURLs.elements();
    }

    public Enumeration findResourcesLocally(String name) throws IOException {
        return super.findResources(name);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("findClass, name=" + name));
        }
        if (this.isClassBlackListed(name)) {
            if (trace) {
                log.trace((Object)("Class in blacklist, name=" + name));
            }
            throw new ClassNotFoundException("Class Not Found(blacklist): " + name);
        }
        Translator translator = this.repository.getTranslator();
        if (translator != null) {
            try {
                URL classUrl = this.getClassURL(name);
                byte[] rawcode = this.loadByteCode(classUrl);
                URL codeSourceUrl = this.getCodeSourceURL(name, classUrl);
                ProtectionDomain pd = this.getProtectionDomain(codeSourceUrl);
                byte[] bytecode = translator.transform((ClassLoader)this, name, null, pd, rawcode);
                if (bytecode == null) {
                    bytecode = rawcode;
                }
                this.definePackage(name);
                return this.defineClass(name, bytecode, 0, bytecode.length, pd);
            }
            catch (ClassNotFoundException e) {
                throw e;
            }
            catch (Throwable ex) {
                throw new ClassNotFoundException(name, ex);
            }
        }
        Class clazz = null;
        try {
            clazz = this.findClassLocally(name);
        }
        catch (ClassNotFoundException e) {
            if (trace) {
                log.trace((Object)("CFNE: Adding to blacklist: " + name));
            }
            this.addToClassBlackList(name);
            throw e;
        }
        return clazz;
    }

    protected Class findClassLocally(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    protected void definePackage(String className) {
        int i = className.lastIndexOf(46);
        if (i == -1) {
            return;
        }
        try {
            this.definePackage(className.substring(0, i), null, null, null, null, null, null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void addURL(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        if (this.repository.addClassLoaderURL(this, url)) {
            log.debug((Object)("Added url: " + url + ", to ucl: " + this));
            String query = url.getQuery();
            if (query != null) {
                String ext = url.toExternalForm();
                String ext2 = ext.substring(0, ext.length() - query.length() - 1);
                try {
                    url = new URL(ext2);
                }
                catch (MalformedURLException e) {
                    log.warn((Object)("Failed to strip query from: " + url), (Throwable)e);
                }
            }
            super.addURL(url);
            this.clearBlackLists();
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("Ignoring duplicate url: " + url + ", for ucl: " + this));
        }
    }

    public URL[] getURLs() {
        return EMPTY_URL_ARRAY;
    }

    public Package getPackage(String name) {
        return super.getPackage(name);
    }

    public Package[] getPackages() {
        return super.getPackages();
    }

    public final boolean equals(Object other) {
        return super.equals(other);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return super.toString() + "{ url=" + this.getURL() + " }";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean attempt(long waitMS) {
        boolean acquired = false;
        boolean trace = log.isTraceEnabled();
        boolean threadWasInterrupted = Thread.interrupted();
        try {
            acquired = this.loadLock.attempt(waitMS);
        }
        catch (InterruptedException e) {
        }
        finally {
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
        if (trace) {
            log.trace((Object)("attempt(" + this.loadLock.holds() + ") was: " + acquired + " for :" + this));
        }
        return acquired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acquire() {
        boolean threadWasInterrupted = Thread.interrupted();
        try {
            this.loadLock.acquire();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (threadWasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("acquired(" + this.loadLock.holds() + ") for :" + this));
        }
    }

    protected void release() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("release(" + this.loadLock.holds() + ") for :" + this));
        }
        this.loadLock.release();
        if (log.isTraceEnabled()) {
            log.trace((Object)("released, holds: " + this.loadLock.holds()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] loadByteCode(String classname) throws ClassNotFoundException, IOException {
        byte[] bytecode = null;
        URL classURL = this.getClassURL(classname);
        InputStream is = null;
        try {
            is = classURL.openStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] tmp = new byte[1024];
            int read = 0;
            while ((read = is.read(tmp)) > 0) {
                baos.write(tmp, 0, read);
            }
            bytecode = baos.toByteArray();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return bytecode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] loadByteCode(URL classURL) throws ClassNotFoundException, IOException {
        byte[] bytecode = null;
        InputStream is = null;
        try {
            is = classURL.openStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] tmp = new byte[1024];
            int read = 0;
            while ((read = is.read(tmp)) > 0) {
                baos.write(tmp, 0, read);
            }
            bytecode = baos.toByteArray();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return bytecode;
    }

    protected ProtectionDomain getProtectionDomain(URL codesourceUrl) {
        Certificate[] certs = null;
        CodeSource cs = new CodeSource(codesourceUrl, certs);
        PermissionCollection permissions = Policy.getPolicy().getPermissions(cs);
        if (log.isTraceEnabled()) {
            log.trace((Object)("getProtectionDomain, url=" + codesourceUrl + " codeSource=" + cs + " permissions=" + permissions));
        }
        return new ProtectionDomain(cs, permissions);
    }

    private URL getCodeSourceURL(String classname, URL classURL) throws MalformedURLException {
        String classRsrcName = classname.replace('.', '/') + ".class";
        String urlAsString = classURL.toString();
        int idx = urlAsString.indexOf(classRsrcName);
        if (idx == -1) {
            return classURL;
        }
        urlAsString = urlAsString.substring(0, idx);
        return new URL(urlAsString);
    }

    private URL getClassURL(String classname) throws ClassNotFoundException {
        String classRsrcName = classname.replace('.', '/') + ".class";
        URL classURL = this.getResourceLocally(classRsrcName);
        if (classURL == null) {
            String msg = "Failed to find: " + classname + " as resource: " + classRsrcName;
            throw new ClassNotFoundException(msg);
        }
        return classURL;
    }
}

