/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.util;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLUtil {
    private static final Logger log = Logger.getLogger(XMLUtil.class);
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public static Element stringToElement(String s) throws Exception {
        return XMLUtil.readerToElement(new StringReader(s));
    }

    public static Element urlToElement(URL url) throws Exception {
        return XMLUtil.readerToElement(new InputStreamReader(url.openStream()));
    }

    public static Element readerToElement(Reader r) throws Exception {
        int c;
        StringBuffer buff = new StringBuffer();
        while ((c = r.read()) != -1) {
            buff.append((char)c);
        }
        String s = buff.toString();
        s = XMLUtil.doReplace(s, "jboss.messaging.groupname", "MessagingPostOffice");
        s = XMLUtil.doReplace(s, "jboss.messaging.datachanneludpaddress", "228.6.6.6");
        s = XMLUtil.doReplace(s, "jboss.messaging.controlchanneludpaddress", "228.7.7.7");
        s = XMLUtil.doReplace(s, "jboss.messaging.datachanneludpport", "45567");
        s = XMLUtil.doReplace(s, "jboss.messaging.controlchanneludpport", "45568");
        s = XMLUtil.doReplace(s, "jboss.messaging.ipttl", "2");
        s = XMLUtil.doReplace(s, "jboss.messaging.ipttl", "8");
        StringReader sreader = new StringReader(s);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document doc = parser.parse(new InputSource(sreader));
        return doc.getDocumentElement();
    }

    public static String elementToString(Node n) {
        String name = n.getNodeName();
        short type = n.getNodeType();
        if (4 == type) {
            return "<![CDATA[" + n.getNodeValue() + "]]>";
        }
        if (name.startsWith("#")) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append('<').append(name);
        NamedNodeMap attrs = n.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node attr = attrs.item(i);
                sb.append(' ').append(attr.getNodeName()).append("=\"").append(attr.getNodeValue()).append("\"");
            }
        }
        String textContent = null;
        NodeList children = n.getChildNodes();
        if (children.getLength() == 0) {
            textContent = XMLUtil.getTextContent(n);
            if (textContent != null && !"".equals(textContent)) {
                sb.append(textContent).append("</").append(name).append('>');
            } else {
                sb.append("/>").append('\n');
            }
        } else {
            sb.append('>').append('\n');
            boolean hasValidChildren = false;
            for (int i = 0; i < children.getLength(); ++i) {
                String childToString = XMLUtil.elementToString(children.item(i));
                if ("".equals(childToString)) continue;
                sb.append(childToString);
                hasValidChildren = true;
            }
            if (!hasValidChildren && (textContent = XMLUtil.getTextContent(n)) != null) {
                sb.append(textContent);
            }
            sb.append("</").append(name).append('>');
        }
        return sb.toString();
    }

    public static String getTextContent(Node n) {
        if (n.hasChildNodes()) {
            StringBuffer sb = new StringBuffer();
            NodeList nl = n.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                sb.append(XMLUtil.elementToString(nl.item(i)));
                if (i >= nl.getLength() - 1) continue;
                sb.append('\n');
            }
            String s = sb.toString();
            if (s.length() != 0) {
                return s;
            }
        }
        Method[] methods = Node.class.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!"getTextContent".equals(methods[i].getName())) continue;
            Method getTextContext = methods[i];
            try {
                return (String)getTextContext.invoke((Object)n, EMPTY_ARRAY);
            }
            catch (Exception e) {
                log.error((Object)("Failed to invoke getTextContent() on node " + n), (Throwable)e);
                return null;
            }
        }
        String textContent = null;
        if (n.hasChildNodes()) {
            NodeList nl = n.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                String s;
                int idx;
                Node c = nl.item(i);
                if (c.getNodeType() != 3) continue;
                textContent = n.getNodeValue();
                if (textContent == null && (idx = (s = c.toString()).indexOf("#text:")) != -1 && (textContent = s.substring(idx + 6).trim()).endsWith("]")) {
                    textContent = textContent.substring(0, textContent.length() - 1);
                }
                if (textContent == null) break;
            }
            String s = n.toString();
            int i = s.indexOf(62);
            int i2 = s.indexOf("</");
            if (i != -1 && i2 != -1) {
                textContent = s.substring(i + 1, i2);
            }
        }
        return textContent;
    }

    public static void assertEquivalent(Node node, Node node2) {
        if (node == null) {
            throw new IllegalArgumentException("the first node to be compared is null");
        }
        if (node2 == null) {
            throw new IllegalArgumentException("the second node to be compared is null");
        }
        if (!node.getNodeName().equals(node2.getNodeName())) {
            throw new IllegalArgumentException("nodes have different node names");
        }
        int attrCount = 0;
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null) {
            attrCount = attrs.getLength();
        }
        int attrCount2 = 0;
        NamedNodeMap attrs2 = node2.getAttributes();
        if (attrs2 != null) {
            attrCount2 = attrs2.getLength();
        }
        if (attrCount != attrCount2) {
            throw new IllegalArgumentException("nodes hava a different number of attributes");
        }
        block0: for (int i = 0; i < attrCount; ++i) {
            Node n = attrs.item(i);
            String name = n.getNodeName();
            String value = n.getNodeValue();
            for (int j = 0; j < attrCount; ++j) {
                Node n2 = attrs2.item(j);
                String name2 = n2.getNodeName();
                String value2 = n2.getNodeValue();
                if (name.equals(name2) && value.equals(value2)) continue block0;
            }
            throw new IllegalArgumentException("attribute " + name + "=" + value + " doesn't match");
        }
        boolean hasChildren = node.hasChildNodes();
        if (hasChildren != node2.hasChildNodes()) {
            throw new IllegalArgumentException("one node has children and the other doesn't");
        }
        if (hasChildren) {
            NodeList nl = node.getChildNodes();
            NodeList nl2 = node2.getChildNodes();
            short[] toFilter = new short[]{3, 2, 8};
            List nodes = XMLUtil.filter(nl, toFilter);
            List nodes2 = XMLUtil.filter(nl2, toFilter);
            int length = nodes.size();
            if (length != nodes2.size()) {
                throw new IllegalArgumentException("nodes hava a different number of children");
            }
            for (int i = 0; i < length; ++i) {
                Node n = (Node)nodes.get(i);
                Node n2 = (Node)nodes2.get(i);
                XMLUtil.assertEquivalent(n, n2);
            }
        }
    }

    public static String stripCDATA(String s) {
        if ((s = s.trim()).startsWith("<![CDATA[")) {
            int i = (s = s.substring(9)).indexOf("]]>");
            if (i == -1) {
                throw new IllegalStateException("argument starts with <![CDATA[ but cannot find pairing ]]>");
            }
            s = s.substring(0, i);
        }
        return s;
    }

    private static List filter(NodeList nl, short[] typesToFilter) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        block0: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            short type = n.getNodeType();
            for (int j = 0; j < typesToFilter.length; ++j) {
                if (typesToFilter[j] == type) continue block0;
            }
            nodes.add(n);
        }
        return nodes;
    }

    private static String doReplace(String s, String propertyName, String defaultValue) {
        String sysProp = System.getProperty(propertyName);
        s = s.replace("${" + propertyName + ":" + defaultValue + "}", sysProp == null ? defaultValue : sysProp);
        return s;
    }
}

