/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Constants;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.OutputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.HttpMessages;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.res.StringManager;

public class InternalOutputBuffer
implements OutputBuffer,
ByteChunk.ByteOutputChannel {
    protected static StringManager sm = StringManager.getManager("org.apache.coyote.http11");
    protected Response response;
    protected MimeHeaders headers;
    protected boolean committed;
    protected boolean finished;
    protected byte[] buf;
    protected int pos;
    protected OutputStream outputStream;
    protected OutputBuffer outputStreamOutputBuffer;
    protected OutputFilter[] filterLibrary;
    protected OutputFilter[] activeFilters;
    protected int lastActiveFilter;
    protected ByteChunk socketBuffer;
    protected boolean useSocketBuffer = false;

    public InternalOutputBuffer(Response response) {
        this(response, 49152);
    }

    public InternalOutputBuffer(Response response, int headerBufferSize) {
        this.response = response;
        this.headers = response.getMimeHeaders();
        this.buf = new byte[headerBufferSize];
        this.outputStreamOutputBuffer = new OutputStreamOutputBuffer();
        this.filterLibrary = new OutputFilter[0];
        this.activeFilters = new OutputFilter[0];
        this.lastActiveFilter = -1;
        this.socketBuffer = new ByteChunk();
        this.socketBuffer.setByteOutputChannel(this);
        this.committed = false;
        this.finished = false;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setSocketBuffer(int socketBufferSize) {
        if (socketBufferSize > 500) {
            this.useSocketBuffer = true;
            this.socketBuffer.allocate(socketBufferSize, socketBufferSize);
        } else {
            this.useSocketBuffer = false;
        }
    }

    public void addFilter(OutputFilter filter) {
        OutputFilter[] newFilterLibrary = new OutputFilter[this.filterLibrary.length + 1];
        for (int i = 0; i < this.filterLibrary.length; ++i) {
            newFilterLibrary[i] = this.filterLibrary[i];
        }
        newFilterLibrary[this.filterLibrary.length] = filter;
        this.filterLibrary = newFilterLibrary;
        this.activeFilters = new OutputFilter[this.filterLibrary.length];
    }

    public OutputFilter[] getFilters() {
        return this.filterLibrary;
    }

    public void clearFilters() {
        this.filterLibrary = new OutputFilter[0];
        this.lastActiveFilter = -1;
    }

    public void addActiveFilter(OutputFilter filter) {
        if (this.lastActiveFilter == -1) {
            filter.setBuffer(this.outputStreamOutputBuffer);
        } else {
            for (int i = 0; i <= this.lastActiveFilter; ++i) {
                if (this.activeFilters[i] != filter) continue;
                return;
            }
            filter.setBuffer(this.activeFilters[this.lastActiveFilter]);
        }
        this.activeFilters[++this.lastActiveFilter] = filter;
        filter.setResponse(this.response);
    }

    public void flush() throws IOException {
        if (!this.committed) {
            this.response.action(ActionCode.ACTION_COMMIT, null);
        }
        if (this.useSocketBuffer) {
            this.socketBuffer.flushBuffer();
        }
    }

    public void recycle() {
        this.response.recycle();
        this.socketBuffer.recycle();
        this.outputStream = null;
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.committed = false;
        this.finished = false;
    }

    public void nextRequest() {
        this.response.recycle();
        this.socketBuffer.recycle();
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            this.activeFilters[i].recycle();
        }
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.committed = false;
        this.finished = false;
    }

    public void endRequest() throws IOException {
        if (!this.committed) {
            this.response.action(ActionCode.ACTION_COMMIT, null);
        }
        if (this.finished) {
            return;
        }
        if (this.lastActiveFilter != -1) {
            this.activeFilters[this.lastActiveFilter].end();
        }
        if (this.useSocketBuffer) {
            this.socketBuffer.flushBuffer();
        }
        this.finished = true;
    }

    public void sendAck() throws IOException {
        if (!this.committed) {
            this.outputStream.write(org.apache.coyote.http11.Constants.ACK_BYTES);
        }
    }

    public void sendStatus() {
        this.write(org.apache.coyote.http11.Constants.HTTP_11_BYTES);
        this.buf[this.pos++] = 32;
        int status = this.response.getStatus();
        switch (status) {
            case 200: {
                this.write(org.apache.coyote.http11.Constants._200_BYTES);
                break;
            }
            case 400: {
                this.write(org.apache.coyote.http11.Constants._400_BYTES);
                break;
            }
            case 404: {
                this.write(org.apache.coyote.http11.Constants._404_BYTES);
                break;
            }
            default: {
                this.write(status);
            }
        }
        this.buf[this.pos++] = 32;
        String message = this.response.getMessage();
        if (message == null) {
            this.write(this.getMessage(status));
        } else {
            this.write(message);
        }
        if (Constants.IS_SECURITY_ENABLED) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    InternalOutputBuffer.this.buf[InternalOutputBuffer.this.pos++] = 13;
                    InternalOutputBuffer.this.buf[InternalOutputBuffer.this.pos++] = 10;
                    return null;
                }
            });
        } else {
            this.buf[this.pos++] = 13;
            this.buf[this.pos++] = 10;
        }
    }

    private String getMessage(final int message) {
        if (Constants.IS_SECURITY_ENABLED) {
            return (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return HttpMessages.getMessage(message);
                }
            });
        }
        return HttpMessages.getMessage(message);
    }

    public void sendHeader(MessageBytes name, MessageBytes value) {
        this.write(name);
        this.buf[this.pos++] = 58;
        this.buf[this.pos++] = 32;
        this.write(value);
        this.buf[this.pos++] = 13;
        this.buf[this.pos++] = 10;
    }

    public void sendHeader(ByteChunk name, ByteChunk value) {
        this.write(name);
        this.buf[this.pos++] = 58;
        this.buf[this.pos++] = 32;
        this.write(value);
        this.buf[this.pos++] = 13;
        this.buf[this.pos++] = 10;
    }

    public void sendHeader(String name, String value) {
        this.write(name);
        this.buf[this.pos++] = 58;
        this.buf[this.pos++] = 32;
        this.write(value);
        this.buf[this.pos++] = 13;
        this.buf[this.pos++] = 10;
    }

    public void endHeaders() {
        this.buf[this.pos++] = 13;
        this.buf[this.pos++] = 10;
    }

    public int doWrite(ByteChunk chunk, Response res) throws IOException {
        if (!this.committed) {
            this.response.action(ActionCode.ACTION_COMMIT, null);
        }
        if (this.lastActiveFilter == -1) {
            return this.outputStreamOutputBuffer.doWrite(chunk, res);
        }
        return this.activeFilters[this.lastActiveFilter].doWrite(chunk, res);
    }

    protected void commit() throws IOException {
        this.committed = true;
        this.response.setCommitted(true);
        if (this.pos > 0) {
            if (this.useSocketBuffer) {
                this.socketBuffer.append(this.buf, 0, this.pos);
            } else {
                this.outputStream.write(this.buf, 0, this.pos);
            }
        }
    }

    protected void write(MessageBytes mb) {
        if (mb.getType() == 2) {
            ByteChunk bc = mb.getByteChunk();
            this.write(bc);
        } else if (mb.getType() == 3) {
            CharChunk cc = mb.getCharChunk();
            this.write(cc);
        } else {
            this.write(mb.toString());
        }
    }

    protected void write(ByteChunk bc) {
        int length = bc.getLength();
        System.arraycopy(bc.getBytes(), bc.getStart(), this.buf, this.pos, length);
        this.pos += length;
    }

    protected void write(CharChunk cc) {
        int start = cc.getStart();
        int end = cc.getEnd();
        char[] cbuf = cc.getBuffer();
        for (int i = start; i < end; ++i) {
            int c = cbuf[i];
            if (c <= 31 && c != 9) {
                c = 32;
            } else if (c == 127) {
                c = 32;
            }
            this.buf[this.pos++] = (byte)c;
        }
    }

    public void write(byte[] b) {
        System.arraycopy(b, 0, this.buf, this.pos, b.length);
        this.pos += b.length;
    }

    protected void write(String s) {
        if (s == null) {
            return;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            int c = s.charAt(i);
            if (c <= 31 && c != 9) {
                c = 32;
            } else if (c == 127) {
                c = 32;
            }
            this.buf[this.pos++] = (byte)c;
        }
    }

    protected void write(int i) {
        this.write(String.valueOf(i));
    }

    public void realWriteBytes(byte[] cbuf, int off, int len) throws IOException {
        if (len > 0) {
            this.outputStream.write(cbuf, off, len);
        }
    }

    protected class OutputStreamOutputBuffer
    implements OutputBuffer {
        protected OutputStreamOutputBuffer() {
        }

        public int doWrite(ByteChunk chunk, Response res) throws IOException {
            int length = chunk.getLength();
            if (InternalOutputBuffer.this.useSocketBuffer) {
                InternalOutputBuffer.this.socketBuffer.append(chunk.getBuffer(), chunk.getStart(), length);
            } else {
                InternalOutputBuffer.this.outputStream.write(chunk.getBuffer(), chunk.getStart(), length);
            }
            return length;
        }
    }
}

