/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tomcat.util.IntrospectionUtils;
import org.jboss.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DomUtil {
    private static Logger log = Logger.getLogger(DomUtil.class);

    public static String getContent(Node n) {
        if (n == null) {
            return null;
        }
        Node n1 = DomUtil.getChild(n, 3);
        if (n1 == null) {
            return null;
        }
        String s1 = n1.getNodeValue();
        return s1.trim();
    }

    public static Node getChild(Node parent, String name) {
        if (parent == null) {
            return null;
        }
        Node first = parent.getFirstChild();
        if (first == null) {
            return null;
        }
        for (Node node = first; node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            if (name != null && name.equals(node.getNodeName())) {
                return node;
            }
            if (name != null) continue;
            return node;
        }
        return null;
    }

    public static String getAttribute(Node element, String attName) {
        NamedNodeMap attrs = element.getAttributes();
        if (attrs == null) {
            return null;
        }
        Node attN = attrs.getNamedItem(attName);
        if (attN == null) {
            return null;
        }
        return attN.getNodeValue();
    }

    public static void setAttribute(Node node, String attName, String val) {
        NamedNodeMap attributes = node.getAttributes();
        Attr attNode = node.getOwnerDocument().createAttribute(attName);
        attNode.setNodeValue(val);
        attributes.setNamedItem(attNode);
    }

    public static void removeAttribute(Node node, String attName) {
        NamedNodeMap attributes = node.getAttributes();
        attributes.removeNamedItem(attName);
    }

    public static void setText(Node node, String val) {
        Node chld = DomUtil.getChild(node, 3);
        if (chld == null) {
            Text textN = node.getOwnerDocument().createTextNode(val);
            node.appendChild(textN);
            return;
        }
        chld.setNodeValue(val);
    }

    public static Node findChildWithAtt(Node parent, String elemName, String attName, String attVal) {
        Node child = DomUtil.getChild(parent, 1);
        if (attVal == null) {
            while (child != null && (elemName == null || elemName.equals(child.getNodeName())) && DomUtil.getAttribute(child, attName) != null) {
                child = DomUtil.getNext(child, elemName, 1);
            }
        } else {
            while (child != null && (elemName == null || elemName.equals(child.getNodeName())) && !attVal.equals(DomUtil.getAttribute(child, attName))) {
                child = DomUtil.getNext(child, elemName, 1);
            }
        }
        return child;
    }

    public static String getChildContent(Node parent, String name) {
        Node first = parent.getFirstChild();
        if (first == null) {
            return null;
        }
        for (Node node = first; node != null; node = node.getNextSibling()) {
            if (!name.equals(node.getNodeName())) continue;
            return DomUtil.getContent(node);
        }
        return null;
    }

    public static Node getChild(Node parent, int type) {
        Node n;
        for (n = parent.getFirstChild(); n != null && type != n.getNodeType(); n = n.getNextSibling()) {
        }
        if (n == null) {
            return null;
        }
        return n;
    }

    public static Node getNext(Node current) {
        String name = current.getNodeName();
        short type = current.getNodeType();
        return DomUtil.getNext(current, name, type);
    }

    public static Node getNext(Node current, String name, int type) {
        Node first = current.getNextSibling();
        if (first == null) {
            return null;
        }
        for (Node node = first; node != null; node = node.getNextSibling()) {
            if (type >= 0 && node.getNodeType() != type) continue;
            if (name == null) {
                return node;
            }
            if (!name.equals(node.getNodeName())) continue;
            return node;
        }
        return null;
    }

    public static void setAttributes(Object o, Node parent) {
        NamedNodeMap attrs = parent.getAttributes();
        if (attrs == null) {
            return;
        }
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node n = attrs.item(i);
            String name = n.getNodeName();
            String value = n.getNodeValue();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Attribute " + parent.getNodeName() + " " + name + "=" + value));
            }
            try {
                IntrospectionUtils.setProperty(o, name, value);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static Document readXml(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setIgnoringComments(false);
        dbf.setIgnoringElementContentWhitespace(true);
        DocumentBuilder db = null;
        db = dbf.newDocumentBuilder();
        db.setEntityResolver(new NullResolver());
        Document doc = db.parse(is);
        return doc;
    }

    public static void writeXml(Node n, OutputStream os) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer t = tf.newTransformer();
        t.setOutputProperty("indent", "yes");
        t.transform(new DOMSource(n), new StreamResult(os));
    }

    public static class NullResolver
    implements EntityResolver {
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("ResolveEntity: " + publicId + " " + systemId));
            }
            return new InputSource(new StringReader(""));
        }
    }
}

