/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.jgroups.Address;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.ExitEvent;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.View;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.Util;

public class TotalTokenDemo
extends JFrame
implements Runnable {
    private JChannel channel;
    JTabbedPane tabbedPane = new JTabbedPane();
    private ReceiverThread receiverThread;
    private ColorPanel colorPanel;
    private ControlPanel control = new ControlPanel();
    private int mSize = 1024;
    private volatile boolean transmitting = false;
    private String channelProperties;
    private Dimension preffered;

    public TotalTokenDemo(String props) {
        this.channelProperties = props;
        try {
            this.channel = new JChannel(this.channelProperties);
        }
        catch (ChannelException e) {
            System.err.println("Could not create channel, exiting ....");
            e.printStackTrace(System.err);
        }
        this.addPanel("Control", this.control);
        this.getContentPane().add(this.tabbedPane);
        this.connect();
    }

    public void addPanel(String name, JPanel panel) {
        if (this.tabbedPane.getTabCount() == 0) {
            this.preffered = panel.getPreferredSize();
        }
        panel.setPreferredSize(this.preffered);
        this.tabbedPane.add(name, panel);
    }

    public JChannel getChannel() {
        return this.channel;
    }

    public void connect() {
        try {
            this.channel.connect("TOTAL_TOKEN_DEMO_GROUP");
        }
        catch (ChannelException e) {
            e.printStackTrace();
        }
        this.receiverThread = new ReceiverThread();
        this.receiverThread.start();
        Address a = this.channel.getLocalAddress();
        if (a != null) {
            this.setTitle(a.toString());
        } else {
            this.setTitle("Not connected");
        }
        this.control.connected();
    }

    public void run() {
        Random r = new Random();
        while (true) {
            Util.sleep(10L);
            try {
                if (this.transmitting) {
                    this.channel.send(new Message(null, null, new TotalPayload(r.nextInt(255))));
                    continue;
                }
                Util.sleep(200L);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void disconnect() {
        this.transmitting = false;
        this.receiverThread.shutDown();
        this.channel.disconnect();
        this.control.disconnected();
        this.setTitle("Not connected");
    }

    static void help() {
        System.out.println("\nTotalTokenDemo [-help] [-props <protocol stack definition>]");
        System.out.println("-props: argument can be an old-style protocol stack specification, or it can be a URL. In the latter case, the protocol specification will be read from the URL\n");
    }

    public static void main(String[] args) {
        String props = null;
        for (int i = 0; i < args.length; ++i) {
            if ("-help".equals(args[i])) {
                TotalTokenDemo.help();
                return;
            }
            if (!"-props".equals(args[i])) {
                TotalTokenDemo.help();
                return;
            }
            props = args[++i];
        }
        if (props == null) {
            props = "UDP(mcast_addr=224.0.0.35;mcast_port=45566;ip_ttl=32;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=2000;num_initial_members=5):FD_SOCK:VERIFY_SUSPECT(timeout=1500):UNICAST(timeout=5000):FRAG(frag_size=8192;down_thread=false;up_thread=false):TOTAL_TOKEN(block_sending=50;unblock_sending=10):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true)";
        }
        TotalTokenDemo ttd = new TotalTokenDemo(props);
        ttd.setDefaultCloseOperation(3);
        ttd.pack();
        ttd.show();
        new Thread(ttd).start();
    }

    static /* synthetic */ int access$702(TotalTokenDemo x0, int x1) {
        x0.mSize = x1;
        return x0.mSize;
    }

    class StackPanel
    extends JPanel {
        ProtocolStack stack;

        public StackPanel(JChannel channel) {
            this.setBorder(BorderFactory.createTitledBorder("ProtocolStack"));
            this.setLayout(new GridLayout(0, 2));
            this.stack = channel.getProtocolStack();
            Iterator iter = this.stack.getProtocols().iterator();
            String[] debugLevels = new String[]{"DEBUG", "INFO", "ERROR"};
            while (iter.hasNext()) {
                Protocol p = (Protocol)iter.next();
                JLabel field = new JLabel(p.getName());
                JComboBox<String> pane = new JComboBox<String>(debugLevels);
                this.add(field);
                this.add(pane);
            }
        }
    }

    class ColorPanel
    extends JPanel {
        long seq1;
        long seq2;
        long seq3;

        public ColorPanel() {
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
        }

        public Dimension getPreferredSize() {
            Dimension layoutSize = super.getPreferredSize();
            int max = Math.max(layoutSize.width, layoutSize.height);
            return new Dimension(max + 20, max + 20);
        }

        public void setSeq(long seq1, long seq2, long seq3) {
            this.seq1 = seq1;
            this.seq2 = seq2;
            this.seq3 = seq3;
            this.repaint();
        }

        protected void paintComponent(Graphics g) {
            Dimension size = this.getSize();
            int x = 0;
            int y = 0;
            g.setColor(new Color((int)this.seq1, (int)this.seq2, (int)this.seq3));
            g.fillRect(x, y, size.width, size.height);
        }
    }

    class ControlPanel
    extends JPanel {
        private final String DISCONNECT = "Disconnect";
        private final String CONNECT = "Connect";
        JTextField numMessagesInLastView;
        JTextField throughput;
        JTextField viewNumber;
        JTextField messageSize;
        JTextField state;
        JButton transmit;
        JButton connectButton;
        JTabbedPane pane;

        public ControlPanel() {
            JPanel labelPane = new JPanel();
            labelPane.setLayout(new GridLayout(0, 1));
            labelPane.add(new JLabel("Message size"));
            labelPane.add(new JLabel("Current view"));
            labelPane.add(new JLabel("Throughput"));
            labelPane.add(new JLabel("Last view count"));
            TotalTokenDemo.this.colorPanel = new ColorPanel();
            this.connectButton = new JButton("Disconnect");
            this.connectButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ ControlPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    JButton b = (JButton)e.getSource();
                    String current_state = b.getText();
                    if ("Connect".equals(current_state)) {
                        ControlPanel.access$600(this.this$1).connect();
                    } else if ("Disconnect".equals(current_state)) {
                        ControlPanel.access$600(this.this$1).disconnect();
                    }
                }
            });
            this.transmit = new JButton(new TransmitAction());
            labelPane.add(this.connectButton);
            labelPane.add(this.transmit);
            int size = 10;
            this.messageSize = new JTextField(size);
            this.messageSize.setText("" + TotalTokenDemo.this.mSize);
            this.messageSize.addActionListener(new ActionListener(this){
                private final /* synthetic */ ControlPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    TotalTokenDemo.access$702(ControlPanel.access$600(this.this$1), Integer.parseInt(this.this$1.messageSize.getText()));
                }
            });
            this.viewNumber = new JTextField(size);
            this.viewNumber.setEditable(false);
            this.throughput = new JTextField(size);
            this.throughput.setEditable(false);
            this.numMessagesInLastView = new JTextField(size);
            this.numMessagesInLastView.setEditable(false);
            this.state = new JTextField(size);
            this.state.setEditable(false);
            JPanel fieldPane = new JPanel();
            fieldPane.setLayout(new GridLayout(0, 1));
            fieldPane.add(this.messageSize);
            fieldPane.add(this.viewNumber);
            fieldPane.add(this.throughput);
            fieldPane.add(this.numMessagesInLastView);
            fieldPane.add(this.state);
            fieldPane.add(TotalTokenDemo.this.colorPanel);
            JPanel contentPane = new JPanel();
            contentPane.setBorder(BorderFactory.createTitledBorder("Control"));
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)labelPane, "Center");
            contentPane.add((Component)fieldPane, "East");
            this.setLayout(new BorderLayout());
            this.add(contentPane);
        }

        public void connected() {
            this.connectButton.setText("Disconnect");
            this.state.setText("connected ok");
        }

        public void disconnected() {
            this.connectButton.setText("Connect");
            this.state.setText("disconnected ok");
        }

        static /* synthetic */ TotalTokenDemo access$600(ControlPanel x0) {
            return x0.TotalTokenDemo.this;
        }
    }

    class TransmitAction
    extends AbstractAction {
        private static final String TRANSMIT_OFF = "transmit off";
        private static final String TRANSMIT_ON = "transmit on";

        TransmitAction() {
            this.putValue("Name", TRANSMIT_OFF);
        }

        public void actionPerformed(ActionEvent e) {
            if (this.getValue("Name") == TRANSMIT_OFF) {
                this.putValue("Name", TRANSMIT_ON);
                TotalTokenDemo.this.transmitting = true;
            } else {
                this.putValue("Name", TRANSMIT_OFF);
                TotalTokenDemo.this.transmitting = false;
            }
        }
    }

    public static class TotalPayload
    implements Serializable {
        private int seqRandom;

        public TotalPayload(int random) {
            this.seqRandom = random;
        }

        public int getRandomSequence() {
            return this.seqRandom;
        }
    }

    private class ReceiverThread
    extends Thread {
        volatile boolean running = true;
        Thread nullifier = null;
        private long startTimeThroughput = System.currentTimeMillis();
        private long oneSecond = 1000L;
        private long throughput = 1L;

        public ReceiverThread() {
            this.nullifier = new Thread(new Runnable(this){
                private final /* synthetic */ ReceiverThread this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    while (this.this$1.running) {
                        Util.sleep(2000L);
                        if (System.currentTimeMillis() - ReceiverThread.access$000(this.this$1) <= 2000L) continue;
                        TotalTokenDemo.access$200((TotalTokenDemo)ReceiverThread.access$100((ReceiverThread)this.this$1)).throughput.setText("0 KB/sec");
                    }
                }
            });
            this.nullifier.start();
        }

        public void shutDown() {
            this.running = false;
        }

        private void measureThrougput(long size) {
            if (System.currentTimeMillis() - this.startTimeThroughput > this.oneSecond) {
                ((TotalTokenDemo)TotalTokenDemo.this).control.throughput.setText("" + this.throughput / 1024L + " KB/sec");
                this.startTimeThroughput = System.currentTimeMillis();
                this.throughput = 0L;
            } else {
                this.throughput += size;
            }
        }

        public void run() {
            Message msg = null;
            int counter = 0;
            Vector<Integer> v = new Vector<Integer>();
            while (this.running) {
                Util.sleep(10L);
                try {
                    Object tmp = TotalTokenDemo.this.channel.receive(0L);
                    if (tmp == null) continue;
                    if (tmp instanceof View) {
                        View vw = (View)tmp;
                        ((TotalTokenDemo)TotalTokenDemo.this).control.viewNumber.setText("" + vw.getVid().getId());
                        ((TotalTokenDemo)TotalTokenDemo.this).control.numMessagesInLastView.setText("" + counter);
                        counter = 0;
                        v.clear();
                        continue;
                    }
                    if (tmp instanceof ExitEvent) {
                        System.out.println("received EXIT");
                        break;
                    }
                    if (!(tmp instanceof Message)) continue;
                    msg = (Message)tmp;
                    this.measureThrougput(msg.size());
                    TotalPayload p = null;
                    p = (TotalPayload)msg.getObject();
                    v.addElement(new Integer(p.getRandomSequence()));
                    int size = v.size();
                    if (size % 50 == 0) {
                        int value = 0;
                        int i = 0;
                        Iterator iter = v.iterator();
                        while (iter.hasNext()) {
                            int seq = (Integer)iter.next();
                            if (++i % 2 == 0) {
                                value *= seq;
                                continue;
                            }
                            if (i % 3 == 0) {
                                value -= seq;
                                continue;
                            }
                            value += seq;
                        }
                        v.clear();
                        value = Math.abs(value);
                        int r = value % 85;
                        int g = value % 170;
                        int b = value % 255;
                        TotalTokenDemo.this.colorPanel.setSeq(r, g, b);
                    }
                    ++counter;
                }
                catch (ChannelNotConnectedException e) {
                    e.printStackTrace();
                }
                catch (ChannelClosedException e) {
                    e.printStackTrace();
                }
                catch (TimeoutException e) {
                    e.printStackTrace();
                }
            }
        }

        static /* synthetic */ long access$000(ReceiverThread x0) {
            return x0.startTimeThroughput;
        }

        static /* synthetic */ TotalTokenDemo access$100(ReceiverThread x0) {
            return x0.TotalTokenDemo.this;
        }
    }
}

