/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.blocks.MethodCall;
import org.jgroups.protocols.GMS;
import org.jgroups.protocols.GmsImpl;
import org.jgroups.protocols.PingRsp;
import org.jgroups.util.Util;

public class ClientGmsImpl
extends GmsImpl {
    Vector initial_mbrs = new Vector(7);
    Object view_installation_mutex = new Object();
    boolean joined = false;
    static /* synthetic */ Class class$org$jgroups$Address;

    public ClientGmsImpl(GMS g) {
        this.gms = g;
    }

    public void init() {
        this.initial_mbrs.removeAllElements();
        this.joined = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(Address mbr) {
        Address coord = null;
        while (!this.joined) {
            this.findInitialMembers();
            if (this.joined) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)"joined successfully");
                }
                return;
            }
            if (this.initial_mbrs.size() == 0) {
                if (this.gms.disable_initial_coord) {
                    if (!this.log.isInfoEnabled()) continue;
                    this.log.info((Object)("received an initial membership of 0, but cannot become coordinator (disable_initial_coord=" + this.gms.disable_initial_coord + "), will retry fetching the initial membership"));
                    continue;
                }
                this.joined = true;
                this.gms.view_id = new ViewId(mbr);
                this.gms.members.add(mbr);
                Event view_evt = new Event(6, this.gms.makeView(this.gms.members.getMembers(), this.gms.view_id));
                this.gms.passDown(view_evt);
                this.gms.passUp(view_evt);
                this.gms.becomeCoordinator();
                this.gms.passUp(new Event(16));
                this.gms.passDown(new Event(16));
                if (!this.log.isInfoEnabled()) break;
                this.log.info((Object)"created group (first member)");
                break;
            }
            coord = this.determineCoord(this.initial_mbrs);
            if (coord == null) {
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn((Object)("could not determine coordinator from responses " + this.initial_mbrs));
                continue;
            }
            Object object = this.view_installation_mutex;
            synchronized (object) {
                try {
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)("sending handleJoin() to " + coord));
                    }
                    MethodCall call = new MethodCall("handleJoin", new Object[]{mbr}, new Class[]{class$org$jgroups$Address == null ? ClientGmsImpl.class$("org.jgroups.Address") : class$org$jgroups$Address});
                    this.gms.callRemoteMethod(coord, call, 6, 0L);
                    this.view_installation_mutex.wait(this.gms.join_timeout);
                }
                catch (Exception e) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)("exception is " + e));
                    }
                    continue;
                }
            }
            if (this.joined) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)"joined successfully");
                }
                return;
            }
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"failed, retrying");
            }
            Util.sleep(this.gms.join_retry_timeout);
        }
    }

    public void leave(Address mbr) {
        this.wrongMethod("leave");
    }

    public void suspect(Address mbr) {
    }

    public void merge(Vector other_coords) {
        this.wrongMethod("merge");
    }

    public boolean handleJoin(Address mbr) {
        this.wrongMethod("handleJoin");
        return false;
    }

    public void handleLeave(Address mbr, boolean suspected) {
        this.wrongMethod("handleLeave");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleViewChange(ViewId new_view, Vector mems) {
        if (this.gms.local_addr != null && mems != null && mems.contains(this.gms.local_addr)) {
            Object object = this.view_installation_mutex;
            synchronized (object) {
                this.joined = true;
                this.view_installation_mutex.notify();
                this.gms.installView(new_view, mems);
                this.gms.becomeParticipant();
                this.gms.passUp(new Event(16));
                this.gms.passDown(new Event(16));
            }
            object = this.initial_mbrs;
            synchronized (object) {
                this.initial_mbrs.notifyAll();
            }
        }
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)("am not member of " + mems + ", will not install view"));
        }
    }

    public View handleMerge(ViewId other_view, Vector other_members) {
        this.wrongMethod("handleMerge");
        return null;
    }

    public void handleSuspect(Address mbr) {
        this.wrongMethod("handleSuspect");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleUpEvent(Event evt) {
        switch (evt.getType()) {
            case 13: {
                Vector tmp = (Vector)evt.getArg();
                Vector vector = this.initial_mbrs;
                synchronized (vector) {
                    if (tmp != null && tmp.size() > 0) {
                        for (int i = 0; i < tmp.size(); ++i) {
                            this.initial_mbrs.addElement(tmp.elementAt(i));
                        }
                    }
                    this.initial_mbrs.notify();
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void findInitialMembers() {
        Vector vector = this.initial_mbrs;
        synchronized (vector) {
            this.initial_mbrs.removeAllElements();
            this.gms.passDown(new Event(12));
            if (this.initial_mbrs.size() == 0) {
                try {
                    this.initial_mbrs.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            for (int i = 0; i < this.initial_mbrs.size(); ++i) {
                PingRsp ping_rsp = (PingRsp)this.initial_mbrs.elementAt(i);
                if (ping_rsp.own_addr == null || this.gms.local_addr == null || !ping_rsp.own_addr.equals(this.gms.local_addr)) continue;
                this.initial_mbrs.removeElementAt(i);
                break;
            }
        }
    }

    Address determineCoord(Vector mbrs) {
        int count;
        Address winner = null;
        if (mbrs == null || mbrs.size() < 1) {
            return null;
        }
        Hashtable<Address, Integer> votes = new Hashtable<Address, Integer>(5);
        for (int i = 0; i < mbrs.size(); ++i) {
            PingRsp mbr = (PingRsp)mbrs.elementAt(i);
            if (mbr.coord_addr == null) continue;
            if (!votes.containsKey(mbr.coord_addr)) {
                votes.put(mbr.coord_addr, new Integer(1));
                continue;
            }
            count = (Integer)votes.get(mbr.coord_addr);
            votes.put(mbr.coord_addr, new Integer(count + 1));
        }
        if (votes.size() > 1) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("there was more than 1 candidate for coordinator: " + votes));
            } else if (this.log.isInfoEnabled()) {
                this.log.info((Object)("election results: " + votes));
            }
        }
        int most_votes = 0;
        Enumeration e = votes.keys();
        while (e.hasMoreElements()) {
            Address tmp = (Address)e.nextElement();
            count = (Integer)votes.get(tmp);
            if (count <= most_votes) continue;
            winner = tmp;
            most_votes = count;
        }
        votes.clear();
        return winner;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

