/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Promise;
import org.jgroups.util.TimeScheduler;

public class FD_SIMPLE
extends Protocol {
    Address local_addr = null;
    TimeScheduler timer = null;
    HeartbeatTask task = null;
    long interval = 3000L;
    long timeout = 3000L;
    Vector members = new Vector();
    HashMap counters = new HashMap();
    int max_missed_hbs = 5;
    final String name = "FD_SIMPLE";

    public String getName() {
        return "FD_SIMPLE";
    }

    public void init() throws Exception {
        this.timer = this.stack.timer;
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = Long.parseLong(str);
            props.remove("timeout");
        }
        if ((str = props.getProperty("interval")) != null) {
            this.interval = Long.parseLong(str);
            props.remove("interval");
        }
        if ((str = props.getProperty("max_missed_hbs")) != null) {
            this.max_missed_hbs = Integer.parseInt(str);
            props.remove("max_missed_hbs");
        }
        if (props.size() > 0) {
            System.err.println("FD_SIMPLE.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void stop() {
        if (this.task != null) {
            this.task.stop();
            this.task = null;
        }
    }

    public void up(Event evt) {
        FdHeader hdr = null;
        boolean counter_reset = false;
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                Address sender = msg.getSrc();
                this.resetCounter(sender);
                counter_reset = true;
                hdr = (FdHeader)msg.removeHeader("FD_SIMPLE");
                if (hdr == null) break;
                switch (hdr.type) {
                    case 1: {
                        Message rsp = new Message(sender, null, null);
                        rsp.putHeader("FD_SIMPLE", new FdHeader(2));
                        this.passDown(new Event(1, rsp));
                        return;
                    }
                    case 2: {
                        if (this.log.isInfoEnabled()) {
                            this.log.info((Object)("received I_AM_ALIVE response from " + sender));
                        }
                        if (this.task != null) {
                            this.task.receivedHeartbeatResponse(sender);
                        }
                        if (!counter_reset) {
                            this.resetCounter(sender);
                        }
                        return;
                    }
                }
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("FdHeader type " + hdr.type + " not known"));
                }
                return;
            }
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                View new_view = (View)evt.getArg();
                this.members.clear();
                this.members.addAll(new_view.getMembers());
                if (new_view.size() > 1) {
                    if (this.task == null) {
                        this.task = new HeartbeatTask();
                        if (this.log.isInfoEnabled()) {
                            this.log.info((Object)"starting heartbeat task");
                        }
                        this.timer.add(this.task, true);
                    }
                } else if (this.task != null) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)"stopping heartbeat task");
                    }
                    this.task.stop();
                    this.task = null;
                }
                Iterator it = this.counters.keySet().iterator();
                while (it.hasNext()) {
                    Address key = (Address)it.next();
                    if (this.members.contains(key)) continue;
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)("removing " + key + " from counters"));
                    }
                    it.remove();
                }
                break;
            }
        }
        this.passDown(evt);
    }

    Address getHeartbeatDest() {
        Address retval = null;
        if (this.members == null || this.members.size() < 2 || this.local_addr == null) {
            return null;
        }
        Vector members_copy = (Vector)this.members.clone();
        members_copy.removeElement(this.local_addr);
        int size = members_copy.size();
        int r = (int)(Math.random() * (double)(size + 1)) % size;
        retval = (Address)members_copy.elementAt(r);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int incrementCounter(Address mbr) {
        int ret = 0;
        if (mbr == null) {
            return ret;
        }
        HashMap hashMap = this.counters;
        synchronized (hashMap) {
            Integer cnt = (Integer)this.counters.get(mbr);
            if (cnt == null) {
                cnt = new Integer(0);
                this.counters.put(mbr, cnt);
            } else {
                ret = cnt + 1;
                this.counters.put(mbr, new Integer(ret));
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetCounter(Address mbr) {
        if (mbr == null) {
            return;
        }
        HashMap hashMap = this.counters;
        synchronized (hashMap) {
            this.counters.put(mbr, new Integer(0));
        }
    }

    String printCounters() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.counters.keySet().iterator();
        while (it.hasNext()) {
            Address key = (Address)it.next();
            sb.append(key).append(": ").append(this.counters.get(key)).append('\n');
        }
        return sb.toString();
    }

    class HeartbeatTask
    implements TimeScheduler.Task {
        boolean stopped = false;
        Promise promise = new Promise();
        Address dest = null;

        HeartbeatTask() {
        }

        void stop() {
            this.stopped = true;
        }

        public boolean cancelled() {
            return this.stopped;
        }

        public long nextInterval() {
            return FD_SIMPLE.this.interval;
        }

        public void receivedHeartbeatResponse(Address from) {
            if (from != null && this.dest != null && from.equals(this.dest)) {
                this.promise.setResult(from);
            }
        }

        public void run() {
            int num_missed_hbs = 0;
            this.dest = FD_SIMPLE.this.getHeartbeatDest();
            if (this.dest == null) {
                if (FD_SIMPLE.this.log.isWarnEnabled()) {
                    FD_SIMPLE.this.log.warn((Object)"heartbeat destination was null, will not send ARE_YOU_ALIVE message");
                }
                return;
            }
            if (FD_SIMPLE.this.log.isInfoEnabled()) {
                FD_SIMPLE.this.log.info((Object)("sending ARE_YOU_ALIVE message to " + this.dest + ", counters are\n" + FD_SIMPLE.this.printCounters()));
            }
            this.promise.reset();
            Message msg = new Message(this.dest, null, null);
            msg.putHeader("FD_SIMPLE", new FdHeader(1));
            FD_SIMPLE.this.passDown(new Event(1, msg));
            this.promise.getResult(FD_SIMPLE.this.timeout);
            num_missed_hbs = FD_SIMPLE.this.incrementCounter(this.dest);
            if (num_missed_hbs >= FD_SIMPLE.this.max_missed_hbs) {
                if (FD_SIMPLE.this.log.isInfoEnabled()) {
                    FD_SIMPLE.this.log.info((Object)("missed " + num_missed_hbs + " from " + this.dest + ", suspecting member"));
                }
                FD_SIMPLE.this.passUp(new Event(9, this.dest));
            }
        }
    }

    public static class FdHeader
    extends Header {
        static final int ARE_YOU_ALIVE = 1;
        static final int I_AM_ALIVE = 2;
        int type = 1;

        public FdHeader() {
        }

        FdHeader(int type) {
            this.type = type;
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    return "[FD_SIMPLE: ARE_YOU_ALIVE]";
                }
                case 2: {
                    return "[FD_SIMPLE: I_AM_ALIVE]";
                }
            }
            return "[FD_SIMPLE: unknown type (" + this.type + ")]";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
        }
    }
}

